package org.sensors2.osc.fragments.bluetoothOverlay;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.CompoundButton;
import android.widget.RelativeLayout;
import android.widget.TextView;

import org.sensors2.osc.R;
import org.sensors2.osc.bluetoothSensors.sensorHandlers.Helpers;
import org.sensors2.osc.bluetoothSensors.sensorHandlers.models.Characteristic;
import org.sensors2.osc.bluetoothSensors.sensorHandlers.models.Device;

import java.util.ArrayList;
import java.util.List;

import androidx.annotation.NonNull;

public class DeviceListAdapter extends ArrayAdapter<Device> {

    private final int resource;
    private DeviceStatusCallback callback;

    public DeviceListAdapter(@NonNull Context context, int resource) {
        super(context, resource);
        this.resource = resource;
    }

    public DeviceListAdapter(@NonNull Context context, int resource, int textViewResourceId) {
        super(context, resource, textViewResourceId);
        this.resource = resource;
    }

    public DeviceListAdapter(@NonNull Context context, int resource, int textViewResourceId, @NonNull List<Device> objects) {
        super(context, resource, textViewResourceId, objects);
        this.resource = resource;
    }

    public DeviceListAdapter(@NonNull Context context, int resource, int textViewResourceId, @NonNull Device[] objects) {
        super(context, resource, textViewResourceId, objects);
        this.resource = resource;
    }

    public DeviceListAdapter(@NonNull Context context, int resource, @NonNull List<Device> objects) {
        super(context, resource, objects);
        this.resource = resource;
    }

    public DeviceListAdapter(@NonNull Context context, int resource, @NonNull Device[] objects) {
        super(context, resource, objects);
        this.resource = resource;
    }

    @NonNull
    @Override
    public View getView(int position, View convertView, @NonNull ViewGroup parent) {
        View v = convertView;
        if (v == null) {
            LayoutInflater vi;
            vi = LayoutInflater.from(getContext());
            v = vi.inflate(resource, null);
        }
        final Device device = this.getItem(position);
        if (device == null){
            return v;
        }

        TextView groupName = v.findViewById(R.id.bt_group_name);
        groupName.setText(device.getName());
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams) groupName.getLayoutParams();
        layoutParams.addRule(RelativeLayout.LEFT_OF,R.id.bt_active);
        groupName.setLayoutParams((layoutParams));
        TextView characteristicList = v.findViewById(R.id.bt_osc_addresses);
        List<String> oscAddresses = new ArrayList<>();
        for (Characteristic characteristic: device.getCharacteristics()) {
            String oscAddress = "/" + Helpers.CreateOscAddress(device.getOscAddress(), characteristic.getId());
            oscAddresses.add(oscAddress);
        }
        characteristicList.setText(String.join(System.getProperty("line.separator"), oscAddresses));
        CompoundButton activeButton = v.findViewById(R.id.bt_active);
        activeButton.setOnCheckedChangeListener((buttonView, isChecked) -> {
            if (buttonView.isPressed() && callback != null){
                callback.changeBluetoothDeviceStatus(device.getAddress(), isChecked);
            }
        });
        activeButton.setChecked(device.getActive());
        return v;
    }

    public void setDeviceStatusCallback(DeviceStatusCallback callback){
        this.callback = callback;
    }

    public interface DeviceStatusCallback {
        void changeBluetoothDeviceStatus(String deviceAddress, boolean active);
    }
}