package org.sensors2.osc.bluetoothSensors.sensorHandlers.models;

import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattService;

import androidx.annotation.Nullable;

public class GattData {
    private final BluetoothGatt gatt;
    private final BluetoothGattService service;

    public GattData(BluetoothGattService gattService, BluetoothGatt gatt) {
        this.service = gattService;
        this.gatt = gatt;
    }

    public BluetoothGattService getService() {
        return service;
    }

    public BluetoothGatt getGatt() {
        return gatt;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (obj == null){
            return false;
        }
        if (!(obj instanceof GattData)){
            return false;
        }
        GattData other = (GattData) obj;
        return other.getGatt().equals(gatt) && other.getService().equals(service);
    }
}
