package org.sensors2.osc.bluetoothSensors.sensorHandlers.models;

import org.sensors2.osc.bluetoothSensors.sensorHandlers.Helpers;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class Device {
    private final String name;
    private final String address;
    private final List<Characteristic> characteristics = new ArrayList<>();
    private boolean active;

    public Device(String address, String name) {
        this.address = address;
        this.name = name;
    }

    public void addCharacteristic(Characteristic characteristic){
        characteristics.add(characteristic);
    }

    public String getAddress() {
        return address;
    }

    public String getOscAddress(){
        return Helpers.urlifyMacAddress(address);
    }

    public String getName() {
        return name;
    }

    public boolean getActive() {
        return active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public List<Characteristic> getCharacteristics() {
        return characteristics;
    }

    public boolean containsCharacteristic(UUID uuid) {
        String id = Helpers.getSiginicantString(uuid);
        for (Characteristic characteristic: characteristics) {
            if (characteristic.getId().equals(id)) {
                return true;
            }
        }
        return false;
    }
}
