package org.sensors2.osc.bluetoothSensors.sensorHandlers;

import java.util.UUID;

public class Helpers {
    private static final String BLUETOOTH_PREFIX = "bt";

    public static String getSiginicantString(UUID btId){
        // All Bluetooth IDs are UUID with 00000000-0000-1000-8000-00805f9b34fb + significant bytes
        // The significant bytes are the ones used in documentation, see https://www.bluetooth.com/wp-content/uploads/Files/Specification/HTML/Assigned_Numbers/out/en/Assigned_Num
        long significantPart = btId.getMostSignificantBits() >>> 32;
        return String.format("%#x", significantPart);
    }

    public static String urlifyMacAddress(String deviceId) {
        // : may be problematic in OSC addresses, although technically allowed
        return deviceId.replace(':', '-');
    }

    public static String CreateOscAddress(String cleanedDeviceId, String cleanedGattId){
        return String.format("%s/%s/%s", BLUETOOTH_PREFIX, cleanedDeviceId, cleanedGattId);
    }
}
