package org.sensors2.osc.bluetoothSensors.sensorHandlers;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattService;
import android.os.Build;

import org.sensors2.osc.bluetoothSensors.sensorHandlers.models.GattData;

import java.util.ArrayList;
import java.util.List;

import androidx.annotation.RequiresApi;

@RequiresApi(api = Build.VERSION_CODES.JELLY_BEAN_MR2)
public abstract class BaseSensorHandler implements  SensorHandler {
    final List<GattData> gatts = new ArrayList<>();
    @Override
    public void addGatt(BluetoothGatt gatt, BluetoothGattService gattService) {
        gatts.add(new GattData(gattService, gatt));
    }

    @SuppressLint("MissingPermission")
    @Override
    public void disconnect() {
        for(GattData data :gatts){
            BluetoothGatt gatt = data.getGatt();
            gatt.disconnect();
            gatt.close();
        }
        gatts.clear();
    }
}
