group = "org.secuso.pfa-core"
plugins {
    alias(libs.plugins.android.lib)
    alias(libs.plugins.kotlin.android)
}
android {
    namespace = "org.secuso.ui.view"
    compileSdk = 34

    defaultConfig {
        minSdk = 17

        testInstrumentationRunner = "androidx.test.runner.AndroidJUnitRunner"
        consumerProguardFiles("consumer-rules.pro")
    }

    buildFeatures {
        dataBinding = true
        viewBinding = true
        buildConfig = true
    }

    buildTypes {
        release {
            isMinifyEnabled = false
            proguardFiles(getDefaultProguardFile("proguard-android-optimize.txt"), "proguard-rules.pro")
        }
    }
    compileOptions {
        sourceCompatibility = JavaVersion.VERSION_1_8
        targetCompatibility = JavaVersion.VERSION_1_8
    }
    kotlinOptions {
        jvmTarget = "1.8"
    }
}

dependencies {

    implementation(libs.ax.core.ktx)
    implementation(libs.ax.appcompat)
    implementation(libs.material)
    testImplementation(libs.junit)
    androidTestImplementation(libs.ax.test.junit)
    androidTestImplementation(libs.espresso)
    implementation(libs.ax.pref)
    implementation(libs.ax.recyclerview.selection)

    implementation("org.secuso.pfacore:model")

    implementation(libs.ax.work.runtime)
    implementation(libs.ax.work.runtime.ktx)
    androidTestImplementation(libs.ax.work.testing)
}