[![PFA](https://img.shields.io/static/v1?label=Privacy%20Friendly%20Apps&message=Project%20Page&style=flat-square&color=3680BB&logo=data:image/png;base64,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)][PFA]
[![Twitter](https://img.shields.io/badge/twitter-@SECUSOResearch-%231DA1F2.svg?&style=flat-square&logo=twitter&logoColor=1DA1F2)][Twitter]
[![Mastodon](https://img.shields.io/badge/mastodon-@SECUSO__Research@baw%C3%BC.social-%233088D4.svg?&style=flat-square&logo=mastodon&logoColor=3088D4)][Mastodon]
<!-- [![Translation status](https://hosted.weblate.org/widget/pfa/qr-scanner/qr-scanner-android-app/svg-badge.svg)](https://hosted.weblate.org/engage/pfa/) -->

[PFA]: https://secuso.org/pfa
[Mastodon]: https://xn--baw-joa.social/@SECUSO_Research
[Twitter]: https://twitter.com/SECUSOResearch


# Privacy Friendly Apps Core (PFA-Core)

The Privacy Friendly Apps Core library is developed for the Privacy Friendly Apps project.
It provides functionality used across many Privacy Friendly Apps.

## Motivation

Whilst developing a single app is a one-time burden, maintaining all of our apps became a time-demanding chore, only getting worse whilst Android develops further.
To this time seemingly small features, like multiple themes, lack in most of our apps and are wished by many, but developing them, finding errors, keeping consistency, ... is a lot of work for every single app.
Changes in the Android-Permission-Handling, updating app information and other things require repetitive work across all apps without any sane way to automate due to differing structure.

To ease this burden the PFA-Core library provides an easy to use framework to be used by the Privacy Friendly Apps. 
It automatically handles the backup and restore process, creating and opening the default activities, applying and changing themes, requesting and handling permissions and other UI-related things.
To be future-ready, the PFA-Core Library is designed and built to provide a easy option to switch in between Jetpack Compose and the normal XML-based View approach. 

## Structure

The PFA-Core library is split into three modules:

* model

    This module declares the common API used by the UI-modules. It also provides the XML based resources like the PrivacyFriendlyCoreTheme, strings, drawables, ...
    The base implementation and interfaces to interact with permissions, dialogs, preferences, ...    
    It does not provide any UI-Related implementation.

* ui-view

    This module declares activities and implementations to the model crate by using XML-based View UIs were possible.
    Min-SDK: 17

* ui-compose

    This module declares activities and implementations using Jetpack Compose and suits the declarative nature of the PFA-Core model best. 
    Min-SDK: 21

## Building

Further development requires Android Studio, we recommend to use the latest version.

### API Reference

Target SDK: 34

<!-- ## Translation

If you want to help translate this app, you can use [Weblate](https://hosted.weblate.org/projects/pfa/qr-scanner/qr-scanner-android-app/).

<a href="https://hosted.weblate.org/engage/pfa/">
<img src="https://hosted.weblate.org/widget/pfa/qr-scanner/qr-scanner-android-app/multi-auto.svg" alt="Translation status" />
</a> -->

## License

PFA-Core is licensed under the GPLv3.
Copyright (C) 2024-2025 Patrick Schneider <br>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.

The icons used in the nagivation drawer are licensed under the [CC BY 2.5](http://creativecommons.org/licenses/by/2.5/). In addition to them the app uses icons from [Google Design Material Icons](https://design.google.com/icons/index.html) licensed under Apache License Version 2.0. All other images (the logo of Privacy Friendly Apps, the SECUSO logo and the app logo) copyright Karlsruhe Institute of Technology.

<a href="https://github.com/SecUSo/pfa-core/graphs/contributors">
  <img src="https://contrib.rocks/image?repo=SecUSo/pfa-core&max=100&columns=20" />
</a>

