# Roto for Android

Roto is an offline, privacy‑first Android app that answers one simple question:

> **“What’s on the rota tomorrow?”**

It keeps rotating schedules on‑device—school dinners, shifts, collections, rehearsals—honouring real calendar Mondays for Week 1 / Week 2 / Week 3… style cycles, and supports one‑off overrides without ever touching a central server.

Roto is developed and maintained by **AnicetusCer**.

## Features

- Today and tomorrow at a glance  
- Browse any calendar date (including weekends)  
- Flexible labelled slots with optional tags and notes  
- Looping week cycles with a repeat anchor  
- Per-date overrides and top-level `special_events` (single string or array for multiple banners on the same day)  
- Supports local JSON files and HTTPS shared-link rotas (cached offline, with refresh)  
- Recent rotas list with share/copy for remote links and a loaded card that surfaces rename/share/refresh controls  
- Custom themes that apply to both app and widget; safe-area padding toggle for devices with gesture bars/notches  
- Homescreen widget for quick rota summaries  
- No analytics, tracking, or proprietary dependencies

For a full walkthrough of the JSON schema, see `docs/SCHEMA.md` in the source repository.

## Downloads

Roto is distributed through open app stores and direct APKs.

- Google Play: _link to be added once published_  
- F‑Droid: _link to be added once the package is accepted_  
- Source code & releases: <https://github.com/AnicetusCer/roto>

## Privacy & legal

- [Privacy policy](./PRIVACY.md)  
- [Legal & warranty summary](./LEGAL.md)  
- Full license: `LICENSE`  
- Disclaimer: `DISCLAIMER.md`

## Support & feedback

Roto is a one‑person, spare‑time project. If you find it useful:

- Report bugs or request features on GitHub: <https://github.com/AnicetusCer/roto/issues>  
- Consider sending a tip via the Ko‑fi link inside the app.
