
The Revengate World
===================

Revengate takes place in a steampunk parallel universe closely based on Earth during the Victorian era.  Magic exists, human races are more spread out than they are on our Earth, guns are still impractical, Europe is widely developed, but so are many other nations around the world.

## On Timelines

What follows describes a world and events that are very similar to our real world. Where confusion is possible, the out-game real world is refered to as "Earth timeline" or "player's timeline". In contrast, the in-game world is either "the Revengate timeline" or "the hero's timeline". The in-game planet is called Revena. 


## World
The game starts in 502 AP, which roughly corresponds to 1855 CE in the Earth timeline. The setting is Victorian era Franconia, located roughly where modern France is. See World Events for more details on the current calendar era.

Technology, science, and medicine is comparable to that of 1855 CE on Earth, except for a few specific discoveries that came a couple decades early or a couple decades late. The industrial revolution is getting started. Guns are all impractical muzzle loaders. Magic is fairly common and its proponents are at odd with the industrial elite. Electricity is rare, steam and clockwork mechanisms are the main sources of mechanized work. Hot air balloons can be seen once in a while, steerable airships are about to be invented.

There are many ideological conflicts in the world: science vs magic, democracy vs autocratic rule, hedonism vs industrial efficiency, colonialism vs local autonomy. In time, the hero will get to pick a side for many of these conflicts, with pro and cons on both sides of the conflicts.

## Look and feel
Movies with the adequate feel include:
* The Prestige (2006)
* Sherlock Holmes (2009)

The action taking place in Franconia rather than London, everything is a little more decorated and a little less industrial. Some early hints of Art Nouveau can be seen here and there. Men almost all sport a beard or a mustache and have some kind of headwear: newsboy caps, bowler hats, top hats. Corsets and crinolines are very common elements of ladies fashion. 

Other fashion inspiration: https://historyten.com/victorian-era/victorian-era-fashion-trends/

Cafés and absinthe lounges are very popular in Franconia.

## Currency
The Franc has the same purchasing power as $5 USD of our era, roughly one basic meal. Franconia has wide reaching trade routes and one can trade in Francs in most ports around the world, but they will have to trade in local currency or in gold if they venture further inland outside of Franconia.

## Places

- Franconia: roughly modern day France
- Saxonia: roughly modern day England
- Prussia: roughly modern day Germany

## Organizations 

### Lux Co.

The game starts with the hero being recruited by the Compagnie des Lumières, usually referred to as Lux Co. This is an underground organization that hires field agents to further its pro-science agenda. The elitist organization is not in favour of democracy, preferring an autocratic rule by an educated few. Lux Co. is very well financed and can provide advanced equipment and training to the hero after he or she succeeds in a handful of missions.

## Major Events
### Great Plague of 1347

The Black Plague swept Eurasia from 1347 to 1353 CE. When the world could finally claim victory on the epidemic, nothing was the same anymore and so a new calendar era was started, noted "AP" for Abscido Pestis, Après la Peste, and After the Plague.

Many institutions fell with the passing of their members and out of necessity, the commoners started enjoying a great deal more freedom. One notable societal change, at least from what we can make up from the written records, is that magic used to be fairly common before the epidemic, but vanished almost entirely by the time the outbreak got under control. The reason why is still a topic of speculation.

From texts written around the time of the plague, people didn't seem to notice that magic was gone at first. Busy with survival and with rebuilding society, they probably had little use for charms and spells, so they gave their attention to more pragmatic matters. 

It's possible that the flood of contaminated patients seeking help from their local healing mage put those magic users at an elevated risk of infection and that they got hit harder by the disease as a result. Some have proposed that there might have been something different in the blood of magic users that made them more vulnerable, a plausible theory that is also impossible to validate.

The grimmest theories propose that most magic users got executed during the plague years. Since many other groups were subjected to similar injustice either for being blamed as the engineers of the plague or for their inability to do anything about it, it's not a big stretch of imagination that mages who would have been seen as all powerful would coon become the victims of desperate mobs. If the mob theory turns out to be true, it would also explain why the few magic-using survivors would all of a sudden want to keep a very low profile.

One major difficulty with tracing the disappearance of magic is the unreliability of written records. The various religious organisations have historically been the best at keeping records, but they are also all notorious for using a lot of editorial freedom to only explain events with a narrative that fits their particular brand of "miracle".


### Modern Magic

In the past 50 years or so, magic has seen a resurgence, but for the most part, spells are little more than party tricks and very few expect it to every play a significant part in an industrialized society. It's very possible that during the 450 years of discontinuity, important elements of magical teaching were lost forever, or perhaps well hidden from the public eye until the time is right. 

One thing is certain: you can't walk into a book store and buy a spell book. If someone wants to learn magic, they must first find someone who already knows it and discover a way to gain their trust.


### How Magic Works

Some people and creatures have an innate affinity with magic. Those without it can sometimes be taught how to channel magic, but they will never achieve mastery of the magical arts. A certain level of intelligence is necessary to be trained in magic.

Channeling magic, sometimes also called "casting spells", always has a cost: the magician's mental clarity, some material, or even someone's vitality. To channel a spell, you  must both know it (instinctively or from training) and be able to pay its cost.

A channeling device is usually an intricate clockwork mechanism moving potent crystals into their most effective configurations. If you have been trained to its usage, a channeling device can help you channel spells. Finding one that you are unfamiliar with won't help you in any way. Channeling devices can have a variety of effects: they can let you channel harder spells than your training alone would allow, they can lower the cost of a spell, or they can increase the power of a spell. Channeling devices have fragile mechanisms that are easily damaged in combat or by overloading while channeling. Some of them consume a power reserve and they will stop working after a certain number of uses.

At its core, magical channeling manipulates aether. It either turns aether into matter or energy; or it turns matter and energy into aether. Some regions of the world are more rich in aether while others are completely devoid of it. This imposes strong geographical limitations on the effectiveness of magic. It's not simply that more aether makes magic more potent. For example, aether can be saturated, a situation that won't affect aether-using spells, but completely disable aether-producing spells. 

No instrument is known to be able to measure the aether density of a place, but magic sensitive beings can usually perceive fluctuations in aether when they move from place to place. It's not uncommon for places of worship and spiritual landmarks to be built in aether-rich regions.

Mana is not the measure of any particular substances, it's a number on an arbitrary scale representing how much channeling someone could do based on their affinity and their current state of mental and physical exhaustion.
