package org.residuum.alligator.utils;

import android.content.Context;
import android.content.res.Resources;
import android.util.TypedValue;

import androidx.annotation.AttrRes;
import androidx.annotation.ColorInt;

public enum Color {
    ;

    @ColorInt
    public static int getColorFromAttr(Context context, @AttrRes int attr) {
        Resources.Theme theme = context.getTheme();
        TypedValue typedValue = new TypedValue();
        if (theme.resolveAttribute(attr, typedValue, true)) {
            return typedValue.data;
        }
        return 0;
    }
}
