package org.residuum.alligator.settings;


import android.annotation.SuppressLint;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseExpandableListAdapter;
import android.widget.TextView;

import org.residuum.alligator.R;

import java.util.List;

import androidx.annotation.NonNull;

public class SampleGroupAdapter extends BaseExpandableListAdapter {

    private final Context context;
    private List<? extends SampleGroup> sampleGroups;

    public SampleGroupAdapter(final Context context, @NonNull final List<? extends SampleGroup> sampleGroups) {
        this.context = context;
        this.sampleGroups = sampleGroups;
    }

    public void setSampleGroups(@NonNull final List<? extends SampleGroup> sampleGroups) {
        this.sampleGroups = sampleGroups;
        this.notifyDataSetChanged();
    }

    @Override
    public int getGroupCount() {
        return this.sampleGroups.size();
    }

    @Override
    public int getChildrenCount(final int groupPosition) {
        final List<SampleInformation> samples = this.sampleGroups.get(groupPosition).getSamples();
        return samples.size();
    }

    @Override
    public Object getGroup(final int groupPosition) {
        return this.sampleGroups.get(groupPosition);
    }

    @Override
    public Object getChild(final int groupPosition, final int childPosition) {
        final List<SampleInformation> sampleList =
                this.sampleGroups.get(groupPosition).getSamples();
        return sampleList.get(childPosition);
    }

    @Override
    public long getGroupId(final int groupPosition) {
        return groupPosition;
    }

    @Override
    public long getChildId(final int groupPosition, final int childPosition) {
        return childPosition;
    }

    @Override
    public boolean hasStableIds() {
        return true;
    }

    @Override
    public View getGroupView(final int groupPosition, final boolean isLastChild, View view,
                             final ViewGroup parent) {

        final SampleGroup sampleGroup = (SampleGroup) this.getGroup(groupPosition);
        if (null == view) {
            final LayoutInflater inf = (LayoutInflater)
                    this.context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
            view = inf.inflate(R.layout.settings_samplegroup, null);
        }

        final TextView heading = view.findViewById(R.id.group_name);
        heading.setText(sampleGroup.getName().trim());
        return view;
    }

    @SuppressLint("SetTextI18n")
    @Override
    public View getChildView(final int groupPosition, final int childPosition, final boolean isLastChild,
                             View view, final ViewGroup parent) {
        final SampleInformation sample = (SampleInformation) this.getChild(groupPosition, childPosition);
        if (null == view) {
            final LayoutInflater inflater = (LayoutInflater) this.context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
            view = inflater.inflate(R.layout.settings_sample_item, null);
        }
        final TextView sampleName = view.findViewById(R.id.sampleName);
        final TextView bpm = view.findViewById(R.id.bpm);
        if (null != sample.getFileName()) {
            sampleName.setText(sample.getFileName());
            bpm.setText(Integer.toString(sample.getBpm()));
            bpm.setVisibility(View.VISIBLE);
        } else {
            sampleName.setText(R.string.empty);
            bpm.setVisibility(View.GONE);
        }
        return view;
    }

    @Override
    public boolean isChildSelectable(final int groupPosition, final int childPosition) {
        return true;
    }
}