package org.residuum.alligator.samplefiles;

import android.content.Context;

import org.residuum.alligator.R;
import org.residuum.alligator.settings.AppSettings;

import java.io.IOException;

import androidx.annotation.NonNull;

public class SamplePackResetter implements SampleContentOperator {
    private final Context context;
    private final AppSettings appSettings;
    private final SampleContentCallback callback;

    public SamplePackResetter(Context context, AppSettings appSettings, SampleContentCallback sampleContentCallback) {
        this.context = context;
        this.appSettings = appSettings;
        this.callback = sampleContentCallback;
    }

    @Override
    public void operateOnData(@NonNull FileContent content) {
        try {
            appSettings.reset(context);
            callback.onSuccess(new SampleContentOperationResult());
        } catch (IOException e) {
            callback.onError(context.getString(R.string.error_resetting_samples));
        }
    }
}
