package org.residuum.alligator.activities;

import android.annotation.SuppressLint;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import android.view.WindowInsets;

import java.util.Objects;

import androidx.appcompat.app.AppCompatActivity;

public abstract class ShowHideActivity extends AppCompatActivity {
    private static final int UI_ANIMATION_DELAY = 300;
    private final Handler mHideHandler = new Handler(Objects.requireNonNull(Looper.myLooper()));
    protected View mContentView;
    private final Runnable mHidePart2Runnable = new Runnable() {
        @SuppressLint("InlinedApi")
        @Override
        public void run() {
            if (Build.VERSION_CODES.R <= Build.VERSION.SDK_INT) {
                if (null == mContentView) {
                    return;
                }
                Objects.requireNonNull(ShowHideActivity.this.mContentView.getWindowInsetsController()).hide(
                        WindowInsets.Type.statusBars() | WindowInsets.Type.navigationBars());
            } else {
                ShowHideActivity.this.mContentView.setSystemUiVisibility(View.SYSTEM_UI_FLAG_LOW_PROFILE
                        | View.SYSTEM_UI_FLAG_FULLSCREEN
                        | View.SYSTEM_UI_FLAG_LAYOUT_STABLE
                        | View.SYSTEM_UI_FLAG_IMMERSIVE_STICKY
                        | View.SYSTEM_UI_FLAG_LAYOUT_HIDE_NAVIGATION
                        | View.SYSTEM_UI_FLAG_HIDE_NAVIGATION);
            }
        }
    };
    private boolean mVisible;
    private final Runnable mHideRunnable = this::hide;

    @Override
    protected void onCreate(final Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    @Override
    protected void onStart() {
        super.onStart();
        this.delayedHide();
        this.mContentView.setOnClickListener(view -> this.toggle());
    }

    private void delayedHide() {
        this.mHideHandler.removeCallbacks(this.mHideRunnable);
        this.mHideHandler.postDelayed(this.mHideRunnable, 100);
    }

    private void toggle() {
        if (this.mVisible) {
            this.hide();
        } else {
            this.show();
        }
    }

    private void hide() {
        this.mVisible = false;
        this.mHideHandler.postDelayed(this.mHidePart2Runnable, ShowHideActivity.UI_ANIMATION_DELAY);
    }

    private void show() {
        if (Build.VERSION_CODES.R <= Build.VERSION.SDK_INT) {
            if (null == mContentView) {
                return;
            }
            Objects.requireNonNull(this.mContentView.getWindowInsetsController()).show(
                    WindowInsets.Type.statusBars() | WindowInsets.Type.navigationBars());
        } else {
            this.mContentView.setSystemUiVisibility(View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN
                    | View.SYSTEM_UI_FLAG_LAYOUT_HIDE_NAVIGATION);
        }
        this.mVisible = true;
        this.mHideHandler.removeCallbacks(this.mHidePart2Runnable);
    }
}
