package org.residuum.alligator.activities;

import android.annotation.SuppressLint;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import android.view.Menu;

import org.residuum.alligator.R;
import org.residuum.alligator.databinding.HelpActivityBinding;
import org.residuum.alligator.settings.AppSettings;

import java.io.IOException;

import androidx.appcompat.app.AppCompatDelegate;
import androidx.core.app.NavUtils;

import static androidx.appcompat.app.AppCompatDelegate.MODE_NIGHT_NO;
import static androidx.appcompat.app.AppCompatDelegate.MODE_NIGHT_YES;

public class HelpActivity extends ShowHideActivity {
    private HelpActivityBinding mViewBinding;

    @Override
    protected void onCreate(final Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mViewBinding = HelpActivityBinding.inflate(this.getLayoutInflater());
        this.setContentView(this.mViewBinding.getRoot());
        this.mContentView = this.mViewBinding.fullscreenContent;
        try {
            final AppSettings appSettings = AppSettings.loadSettings(this);
            AppCompatDelegate.setDefaultNightMode(appSettings.getColorSettings());
            final boolean isNightMode;
            switch (appSettings.getColorSettings()) {
                case MODE_NIGHT_YES:
                    isNightMode = true;
                    break;
                case MODE_NIGHT_NO:
                    isNightMode = false;
                    break;
                default:
                    final int nightModeFlags = this.getApplicationContext().getResources()
                            .getConfiguration().uiMode & Configuration.UI_MODE_NIGHT_MASK;
                    isNightMode = MODE_NIGHT_YES == appSettings.getColorSettings()
                            || Configuration.UI_MODE_NIGHT_YES == nightModeFlags;
                    break;
            }
            if (isNightMode) {
                this.mViewBinding.demoImage.setImageResource(R.drawable.help_demo_night);
            } else {
                this.mViewBinding.demoImage.setImageResource(R.drawable.help_demo);
            }
        } catch (final IOException e) {
            throw new RuntimeException(e);
        }
        this.createMenu();

    }

    @SuppressLint("NonConstantResourceId")
    private void createMenu() {
        this.mViewBinding.actionBar.inflateMenu(R.menu.main);
        final Menu mainMenu = this.mViewBinding.actionBar.getMenu();
        mainMenu.removeItem(R.id.action_about);
        //mainMenu.removeItem(R.id.action_guide);
        this.mViewBinding.actionBar.setOnMenuItemClickListener(item -> {
            switch (item.getItemId()) {
                case R.id.action_settings:
                    this.startActivity(new Intent(this, SettingsActivity.class));
                    break;
                case R.id.action_bar:
                    NavUtils.navigateUpFromSameTask(this);
                    return true;
            }
            return true;
        });
    }
}