package org.residuum.alligator.activities;


import android.annotation.SuppressLint;
import android.content.Intent;
import android.os.Bundle;
import android.view.Menu;

import org.residuum.alligator.BuildConfig;
import org.residuum.alligator.R;
import org.residuum.alligator.databinding.AboutActivityBinding;
import org.residuum.alligator.settings.AppSettings;

import java.io.IOException;

import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatDelegate;
import androidx.core.app.NavUtils;

public class AboutActivity extends ShowHideActivity {
    private AboutActivityBinding mViewBinding;

    @Override
    protected void onCreate(@NonNull Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        mViewBinding = AboutActivityBinding.inflate(getLayoutInflater());
        this.mContentView = this.mViewBinding.fullscreenContent;
        setContentView(mViewBinding.getRoot());
        try {
            AppSettings appSettings = AppSettings.loadSettings(this);
            AppCompatDelegate.setDefaultNightMode(appSettings.getColorSettings());
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
        mViewBinding.version.setText(getString(R.string.about_version, BuildConfig.VERSION_NAME));
        createMenu();
    }

    @SuppressLint("NonConstantResourceId")
    private void createMenu() {
        mViewBinding.actionBar.inflateMenu(R.menu.main);
        Menu mainMenu = mViewBinding.actionBar.getMenu();
        mainMenu.removeItem(R.id.action_about);
//        mainMenu.removeItem(R.id.action_guide);

        mViewBinding.actionBar.setOnMenuItemClickListener(item -> {
            switch (item.getItemId()) {
                case R.id.action_settings:
                    startActivity(new Intent(AboutActivity.this, SettingsActivity.class));
                    break;
                case R.id.action_bar:
                    NavUtils.navigateUpFromSameTask(AboutActivity.this);
                    return true;
            }
            return true;
        });
    }
}
