# Alligator Bytes

Alligator Bytes is an Android app for performing music, originally made for the [Alligator Gozaimasu](http://alligator-go.space/) collective.

See also the [website for the app](https://sensors2.org/alligator-bytes/).

![Screenshot](fastlane/metadata/android/en-US/images/phoneScreeshots/1.png)

[<img src="https://f-droid.org/badge/get-it-on.png" alt="Get it on F-Droid">](https://f-droid.org/packages/org.residuum.alligator/)

## Key Features

- The app has up to 6 sample groups containing up to 10 loops each, where a loop of each group can be played simultaneously.
- You can record loops on the go and play back up to 4 of those simultaneously.
- Loop playback is synchronized to beats, while playback speed can be set globally.
- Pitch and panning is controlled independantly for each loop to create rich stereo sound.
- You can control pitch and panning via tilt of the phone or tablet, if you want to.
- Use random sample from each group after a loop has finished.
- Break loops into beats and randomize the position in the loop to be played back.

## Other Features

- Record your own samples on the go and export them for later use
- Load your own samples and set their beats per minute
- Independant pitch and playback speed of samples
- Record your sessions to wav 

## Get Involved

The code comes with a permissive MIT license, so feel free to check out the code and get involved in the development of the app or use the audio logic (in [Pure Data](https://puredata.info/)) to create your own patches.

Or get involved with translating the app into different languages at [Codeberg Weblate](https://translate.codeberg.org/engage/alligator-gozaimasu/).

[<img src="https://translate.codeberg.org/widget/alligator-gozaimasu/app/multi-auto.svg" alt="Translation status">](https://translate.codeberg.org/engage/alligator-gozaimasu/)

We also try to get the app to the Play Store, but are still in need of some beta testers, so that the app is available there as well.

Feel free to email us at alligatorbytes@sensors2.org for more information.
