package org.residuum.alligator.utils;

import android.annotation.SuppressLint;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.BaseColumns;
import android.provider.MediaStore;

import java.io.File;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

public class FileUri {
    private static final String APP_EXPORT_NAME = "Alligator Bytes";
    @SuppressLint("Range")
    public static @Nullable Uri getUriForFile(final String fileName, final Context context, final String mimeType) {
        ensureExportFolder();
        return getUriForNewFile(fileName, context, mimeType);
    }

    @SuppressLint("Range")
    private static Uri getUriForNewFile(String fileName, Context context, String mimeType) {
        String directoryPath = getDirectoryPath(mimeType);
        Uri folderUri = getExternalContentUri(mimeType);
        final ContentValues newRecording = new ContentValues();
        final String[] projection = {BaseColumns._ID};
        final String query = MediaStore.MediaColumns.RELATIVE_PATH + " like ? and " +
                MediaStore.MediaColumns.DISPLAY_NAME + " like ?";

        try (final Cursor cursor = context.getContentResolver().query(folderUri, projection, query, new String[]{"%" + directoryPath + "%", "%" + fileName + "%"}, null)) {
            if (null != cursor) {
                if (0 < cursor.getCount()) {
                    cursor.moveToFirst();
                    return ContentUris.withAppendedId(folderUri,
                            cursor.getLong(cursor.getColumnIndex(projection[0])));

                }
            }
        }
        newRecording.put(MediaStore.MediaColumns.DISPLAY_NAME, fileName);
        newRecording.put(MediaStore.MediaColumns.MIME_TYPE, mimeType);
        newRecording.put(MediaStore.MediaColumns.RELATIVE_PATH, directoryPath);
        return context.getContentResolver().insert(folderUri, newRecording);
    }

    private static Uri getExternalContentUri(String mimeType) {
        if (mimeType.startsWith("audio")) {
            return MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
        }
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.Q) {
            return MediaStore.Downloads.EXTERNAL_CONTENT_URI;
        }
        return MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
    }

    private static void ensureExportFolder() {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.S) {
            final String directoryPath = Environment.DIRECTORY_RECORDINGS + File.separator + APP_EXPORT_NAME;
            File directory = new File(directoryPath);
            if (!directory.exists() && !directory.isDirectory()){
                directory.mkdirs();
            }
        }
    }

    public static Uri getExportFolder(String mimeType) {
        final String directoryPath = getDirectoryPath(mimeType);
        return MediaStore.Audio.Media.getContentUriForPath(directoryPath);
        //return Uri.parse(directoryPath);
    }

    @NonNull
    public static String getDirectoryPath(String mimeType) {
        if (mimeType.startsWith("audio")) {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.S) {
                return Environment.DIRECTORY_RECORDINGS + File.separator + APP_EXPORT_NAME;
            } else {
                return Environment.DIRECTORY_DOWNLOADS;
            }
        }
        return Environment.DIRECTORY_DOWNLOADS;
    }
}