package org.residuum.alligator.samplefiles;

import android.content.Context;
import android.media.MediaFormat;
import android.net.Uri;

import com.linkedin.android.litr.MediaTransformer;
import com.linkedin.android.litr.MimeType;
import com.linkedin.android.litr.TrackTransform;
import com.linkedin.android.litr.TransformationListener;
import com.linkedin.android.litr.codec.Encoder;
import com.linkedin.android.litr.codec.MediaCodecDecoder;
import com.linkedin.android.litr.codec.PassthroughBufferEncoder;
import com.linkedin.android.litr.exception.MediaSourceException;
import com.linkedin.android.litr.io.MediaExtractorMediaSource;
import com.linkedin.android.litr.io.MediaTarget;
import com.linkedin.android.litr.io.WavMediaTarget;
import com.linkedin.android.litr.render.AudioRenderer;

import java.io.File;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;

public class SampleTranscoder {
    private final TransformationListener listener;

    public SampleTranscoder(TransformationListener listener){
        this.listener = listener;
    }

    public void transcodeFile(Context context, Uri input, String inputFilename, File outputFile) throws MediaSourceException {
        MediaTransformer mediaTransformer = new MediaTransformer(context);
        LocalDateTime now = LocalDateTime.now();
        ZoneId zoneId = ZoneId.systemDefault();
        long epoch = now.atZone(zoneId).toEpochSecond();
        String transformationId = Long.toString(epoch, 16) +"/" + inputFilename;

        Encoder encoder = new PassthroughBufferEncoder(8192);
        MediaFormat mediaFormat = MediaFormat.createAudioFormat(MimeType.AUDIO_RAW, 48000, 1);
        MediaTarget wavTarget = new WavMediaTarget(outputFile.getPath());
        TrackTransform.Builder builder = new TrackTransform.Builder(new MediaExtractorMediaSource(context, input), 0, wavTarget);
        builder.setTargetTrack(0);
        builder.setDecoder(new MediaCodecDecoder());
        builder.setEncoder(encoder);
        builder.setRenderer(new AudioRenderer(encoder));
        builder.setTargetFormat(mediaFormat);
        TrackTransform trackTransform = builder
                .build();
        List<TrackTransform> trackTransforms = new ArrayList<>();
        trackTransforms.add(trackTransform);
        mediaTransformer.transform(
                transformationId,
                trackTransforms,
                listener,
                MediaTransformer.GRANULARITY_DEFAULT);
    }
}
