package org.residuum.alligator.samplefiles;

import java.util.List;

public class SampleContentOperationResult {
    private final String directory;
    private final String fileName;
    private final String groupName;
    private final int position;
    private final List<String> erroredFiles;

    private SampleContentOperationResult(final String directory, final String fileName,
                                        final String groupName, final int position, final List<String> erroredFiles) {
        this.directory = directory;
        this.fileName = fileName;
        this.groupName = groupName;
        this.position = position;
        this.erroredFiles = erroredFiles;
    }

    public SampleContentOperationResult(final String directory, final String fileName,
                                        final String groupName, final int position) {
        this(directory, fileName, groupName, position, null);
    }

    public SampleContentOperationResult(final List<String> erroredFiles) {
        this(null, null, null, 0, erroredFiles);
    }

    public SampleContentOperationResult() {
        this(null, null, null, 0, null);
    }

    public String getDirectory() {
        return this.directory;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public int getPosition() {
        return this.position;
    }

    public List<String> getErroredFiles() {
        return erroredFiles;
    }

    public boolean hasErrors() {
        return erroredFiles != null && !erroredFiles.isEmpty();
    }
}
