package org.residuum.alligator.utils;

import android.content.pm.ActivityInfo;
import android.widget.SeekBar;

public class PitchAndPanning {
    private float mOrientationValueForPitch = Float.MIN_VALUE;
    private float mOrientationValueForPanning = Float.MIN_VALUE;
    private boolean mUseOrientationForPitch;
    private boolean mUseOrientationForPanning;
    private SeekBar mPitchSlider;
    private SeekBar mPanSlider;

    public void setOrientation(final float[] v, final int orientation) {
        switch (orientation) {
            case ActivityInfo.SCREEN_ORIENTATION_REVERSE_LANDSCAPE:
                this.setOrientationForPitch(v[2]);
                this.setOrientationForPanning(v[1]);
                break;
            case ActivityInfo.SCREEN_ORIENTATION_LANDSCAPE:
                this.setOrientationForPitch(-v[2]);
                this.setOrientationForPanning(-v[1]);
                break;
            case ActivityInfo.SCREEN_ORIENTATION_REVERSE_PORTRAIT:
                this.setOrientationForPitch(-v[1]);
                this.setOrientationForPanning(v[2]);
                break;
            case ActivityInfo.SCREEN_ORIENTATION_PORTRAIT:
            default:
                this.setOrientationForPitch(v[1]);
                this.setOrientationForPanning(-v[2]);
                break;
        }
    }

    private void setOrientationForPitch(final float v) {
        if (!this.mUseOrientationForPitch) {
            this.mOrientationValueForPitch = Float.MIN_VALUE;
            return;
        }
        if (Float.MIN_VALUE == mOrientationValueForPitch) {
            this.mOrientationValueForPitch = v;
            return;
        }
        final float change = v - this.mOrientationValueForPitch;
        this.mOrientationValueForPitch = v;
        final double currentPitch = Math.pow(2, ((float) this.mPitchSlider.getProgress()) / 1200);
        final double pitch = Math.pow(2, change) * currentPitch;

        float pitchInCents = (float) (Math.log(pitch) / Math.log(2)) * 1200;

        if (-1200 > pitchInCents) {
            pitchInCents = -1200.0f;
        }
        if (1200 < pitchInCents) {
            pitchInCents = 1200.0f;
        }
        pitchInCents = Math.round(pitchInCents);
        this.mPitchSlider.setProgress((int) pitchInCents);
    }

    private void setOrientationForPanning(final float v) {
        if (!this.mUseOrientationForPanning) {
            this.mOrientationValueForPanning = Float.MIN_VALUE;
            return;
        }
        if (Float.MIN_VALUE == mOrientationValueForPanning) {
            this.mOrientationValueForPanning = v;
            return;
        }
        final float change = v - this.mOrientationValueForPanning;
        this.mOrientationValueForPanning = v;
        final double currentPanning = this.mPanSlider.getProgress();
        double panning = change * 50 + currentPanning;

        if (0 > panning) {
            panning = 0;
        }
        if (100 < panning) {
            panning = 100;
        }
        final int panningI = (int) Math.round(panning);
        this.mPanSlider.setProgress(panningI);
    }

    public void setUseOrientationForPitch(final boolean useOrientationForPitch) {
        mUseOrientationForPitch = useOrientationForPitch;
    }

    public void setUseOrientationForPanning(final boolean useOrientationForPanning) {
        mUseOrientationForPanning = useOrientationForPanning;
    }

    public void setPitchSlider(final SeekBar pitchSlider) {
        mPitchSlider = pitchSlider;
    }

    public void setPanSlider(final SeekBar panSlider) {
        mPanSlider = panSlider;
    }
}
