package org.residuum.alligator.utils;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.BaseColumns;
import android.provider.MediaStore;

import androidx.annotation.Nullable;
import androidx.documentfile.provider.DocumentFile;

public class FileUri {
    @SuppressLint("Range")
    public static @Nullable Uri getUriForFile(Uri folderUri, final String fileName, final Context context, final String mimeType) {
        if (folderUri == null){
            return getDownloadUriForFile(fileName, context, mimeType);
        }
        DocumentFile folder = DocumentFile.fromTreeUri(context, folderUri);
        if (folder == null){
            return null;
        }
        final DocumentFile file  = folder.createFile(mimeType, fileName);
        if (file == null){
            return null;
        }
        return file.getUri();
    }

    @SuppressLint("Range")
    private static Uri getDownloadUriForFile(String fileName, Context context, String mimeType) {
        Uri folderUri = Uri.parse(getAudioCollection());
        final ContentValues newRecording = new ContentValues();
        final String[] projection = {BaseColumns._ID};
        final String query = MediaStore.MediaColumns.RELATIVE_PATH + " like ? and " +
                MediaStore.MediaColumns.DISPLAY_NAME + " like ?";
        try (final Cursor cursor = context.getContentResolver().query(folderUri, projection, query, new String[]{"%" + Environment.DIRECTORY_DOWNLOADS + "%", "%" + fileName + "%"}, null)) {
            if (null != cursor) {
                if (0 < cursor.getCount()) {
                    cursor.moveToFirst();
                    return ContentUris.withAppendedId(MediaStore.Audio.Media.EXTERNAL_CONTENT_URI,
                            cursor.getLong(cursor.getColumnIndex(projection[0])));

                }
            }
        }
        newRecording.put(MediaStore.MediaColumns.DISPLAY_NAME, fileName);
        newRecording.put(MediaStore.MediaColumns.MIME_TYPE, mimeType);
        newRecording.put(MediaStore.MediaColumns.RELATIVE_PATH, Environment.DIRECTORY_DOWNLOADS);
        return context.getContentResolver().insert(folderUri, newRecording);
    }

    public static String getAudioCollection() {
        if (Build.VERSION_CODES.Q <= Build.VERSION.SDK_INT) {
            return MediaStore.Downloads.EXTERNAL_CONTENT_URI.toString();
        } else {
            return MediaStore.Audio.Media.EXTERNAL_CONTENT_URI.toString();
        }
    }
}