class_name Player

static var next_new_player_index: int = 1
static var current_player_index: int = 0
static var players: Array[Player]

var index: int
var score: int = 0


func _init() -> void:
	index = next_new_player_index
	next_new_player_index += 1
	players.append(self)


func get_score_str() -> String:
	return tr("Player {number}: {score}", "Show a player's score in the score table")\
			.format({number = index, score = score})


static func sort_players_by_score() -> void:
	players.sort_custom(func(a, b): return a.score > b.score)


static func format_scores() -> String:
	return "\n".join(players.duplicate().map(func(p): return p.get_score_str()))


static func reset() -> void:
	next_new_player_index = 1
	current_player_index = 0
	players.clear()


static func next_player() -> void:
	current_player_index = (current_player_index + 1) % players.size()


static func current_player() -> Player:
	return players[current_player_index]
