extends Node

func get_version_number_str() -> String:
	return "v" + ProjectSettings.get_setting("application/config/version")


func hide_nodes_group(group_name: String) -> void:
	for node in get_tree().get_nodes_in_group(group_name):
		node.hide()


func show_nodes_group(group_name: String) -> void:
	for node in get_tree().get_nodes_in_group(group_name):
		node.show()


func array_unique(array: Array) -> Array:
	var unique: Array = []

	for item in array:
		if not unique.has(item):
			unique.append(item)

	return unique
