extends Node

const config_section_name := "config"
const config_path := "user://config.cfg"


func get_param(key: String, default = null):
	var config := ConfigFile.new()

	# If the file didn't load, ignore it.
	if OK != config.load(config_path): return default

	return config.get_value(config_section_name, key, default)


func store(key: String, value) -> void:
	var config := ConfigFile.new()

	if OK == config.load(config_path):
		config.set_value(config_section_name, key, value)

	config.save(config_path)
