extends Control

signal card_flipped(card)

var front_texture: Texture:
	set(texture):
		$CardFront/TextureRect.texture = texture
var back_texture: Texture:
	set(texture):
		$CardBack/TextureRect.texture = texture
var card_name: String


func _ready() -> void:
	swap_texture()


func swap_texture() -> void:
	if $Button.button_pressed:
		$CardBack.hide()
		$CardFront.show()
	else:
		$CardFront.hide()
		$CardBack.show()


func _on_button_pressed() -> void:
	$AnimationPlayer.play("flip_card")
	$FlipCardSound.play()
	card_flipped.emit(self)


func flip_card_back() -> void:
	$Button.set_pressed_no_signal(false)
	$AnimationPlayer.play_backwards("flip_card")


func emit_particle() -> void:
	$ParticlesContainer/StarsParticles.emitting = true


func set_particles_scale(particle_scale: Vector2) -> void:
	$ParticlesContainer/StarsParticles.scale = particle_scale


func disable_card(disabled: bool) -> void:
	$Button.disabled = disabled
