[![Liberapay donations](https://img.shields.io/liberapay/patrons/quentin-bettoum?style=for-the-badge&logo=liberapay&labelColor=%23161616)](https://liberapay.com/quentin-bettoum/donate)
[![License: AGPL v3](https://img.shields.io/badge/License-AGPL_v3-663066?style=for-the-badge&labelColor=%23161616)](https://www.gnu.org/licenses/agpl-3.0)
[![F-Droid](https://img.shields.io/f-droid/v/org.quentin_bettoum.librememorygame?include_prereleases&style=for-the-badge&logo=fdroid&logoColor=%23b1ea09&labelColor=%231976D2&color=%23b1ea09)](https://f-droid.org/en/packages/org.quentin_bettoum.librememorygame/)
[![Play on ich.io](https://img.shields.io/badge/play_on_itch.io-b84341?style=for-the-badge&logo=itchdotio&color=%23161616)](https://quentin-bettoum.itch.io/libre-memory-game)

# Libre Memory Game
This is a Free/Libre and Open Source memory game made with Godot.
There are multiple card sets and difficulties to play with.
The "Very Hard" difficulty requires you to find 3 cards per image instead of 2.

The game is also fully playable with the Keyboard:
- Press S to Start or Surrender
- Use the arrow keys to navigate
- Enter to select
- Escape to open the menu

## Screenshots
![](screenshots/menu.jpg)
![](screenshots/screenshot1.jpg)
![](screenshots/screenshot2.jpg)

## credits
### Images
Illustrations for the card sets and UI icons made by Freepik from [**Flaticon**](https://www.flaticon.com)

### Sounds
- ["Magic Stars Retro Sparkle" by **smokinghotdog**](https://freesound.org/people/smokinghotdog/sounds/584244/)
- ["Flip" by **Egomassive**](https://freesound.org/people/egomassive/sounds/536782/)
- ["Card Flip" by **f4ngy**](https://freesound.org/people/f4ngy/sounds/240776/)
- ["win" by **mehraniiii**](https://freesound.org/people/mehraniiii/sounds/588234/)

## notes
### Translations
If you want to contribute to translations, you can do so by going to [https://translate.codeberg.org/projects/libre-memory-game/](https://translate.codeberg.org/projects/libre-memory-game/)

#### Update the messages.pot (retrieves the strings to be translated from the project)
Project -> Project Settings... -> Localization -> Generate POT

#### Update the translations
To update all translations, run the `update-locales.sh` bash script:
```bash
bash update-locales.sh
```

#### Add the new translation file to the project
Project -> Project Settings... -> Localization -> Translations -> Add...

Then you can update the translation strings inside the `.po` file.

#### Add translations for the F-droid metadatas and the `.desktop` file

### Release checklist
- [ ] Increment the `Version Code` and `Version Name` In `Project -> Export -> Android` or update `version/code` and `version/name` in the [export_presets.cfg](export_presets.cfg)
- [ ] (Is it useful?) Increment the `application/file_version` and `application/product_version` in [export_presets.cfg](export_presets.cfg) for the Windows export
- [ ] Increment the `Version` in `Project -> Settings -> Application -> Config` or update `config/version` in [project.godot](`project.godot`)
- [ ] Export and test the different binaries
- [ ] Create the metadata changelogs necessary for an F-Droid release in `metadata/{lang}/changelogs/{version_code}.txt`
- [ ] Update the [CHANGELOG.md](CHANGELOG.md)
- [ ] Git tag and push
- [ ] Add the [.desktop file](Libre-Memory-Game.desktop) and necessary icons in the Linux binary archive
- [ ] Create a release on Codeberg and add the binaries
- [ ] Publish the binaries to Itch.io
- [ ] Create a new release on **F-Droid Data** (don't use the master branch, create a new one) OR wait for the F-Droid bot to automatically create a new release

### TODO
Include Godot as git submodule as suggested by F-Droid :
> External repos are added as git submodules instead of srclibs. You can update git submodules without opening an MR in this repo and the submodule is covered by our scanner.
