/*
 * Copyright (C) 2023-2025 Yaroslav Pronin <proninyaroslav@mail.ru>
 *
 * This file is part of OpenComicVine.
 *
 * OpenComicVine is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * OpenComicVine is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with OpenComicVine.  If not, see <http://www.gnu.org/licenses/>.
 */

package org.proninyaroslav.opencomicvine.ui.theme

import androidx.compose.ui.graphics.Color

val primaryLight = Color(0xFF2A6A47)
val onPrimaryLight = Color(0xFFFFFFFF)
val primaryContainerLight = Color(0xFFAEF2C5)
val onPrimaryContainerLight = Color(0xFF095131)
val secondaryLight = Color(0xFF4E6354)
val onSecondaryLight = Color(0xFFFFFFFF)
val secondaryContainerLight = Color(0xFFD1E8D6)
val onSecondaryContainerLight = Color(0xFF374B3E)
val tertiaryLight = Color(0xFF3B6471)
val onTertiaryLight = Color(0xFFFFFFFF)
val tertiaryContainerLight = Color(0xFFBFE9F8)
val onTertiaryContainerLight = Color(0xFF224C58)
val errorLight = Color(0xFFBA1A1A)
val onErrorLight = Color(0xFFFFFFFF)
val errorContainerLight = Color(0xFFFFDAD6)
val onErrorContainerLight = Color(0xFF93000A)
val backgroundLight = Color(0xFFF6FBF4)
val onBackgroundLight = Color(0xFF181D19)
val surfaceLight = Color(0xFFF6FBF4)
val onSurfaceLight = Color(0xFF181D19)
val surfaceVariantLight = Color(0xFFDCE5DC)
val onSurfaceVariantLight = Color(0xFF414942)
val outlineLight = Color(0xFF717972)
val outlineVariantLight = Color(0xFFC0C9C0)
val scrimLight = Color(0xFF000000)
val inverseSurfaceLight = Color(0xFF2C322D)
val inverseOnSurfaceLight = Color(0xFFEDF2EB)
val inversePrimaryLight = Color(0xFF93D5AA)
val surfaceDimLight = Color(0xFFD6DBD5)
val surfaceBrightLight = Color(0xFFF6FBF4)
val surfaceContainerLowestLight = Color(0xFFFFFFFF)
val surfaceContainerLowLight = Color(0xFFF0F5EE)
val surfaceContainerLight = Color(0xFFEAEFE8)
val surfaceContainerHighLight = Color(0xFFE4EAE3)
val surfaceContainerHighestLight = Color(0xFFDFE4DD)

val primaryLightMediumContrast = Color(0xFF003F24)
val onPrimaryLightMediumContrast = Color(0xFFFFFFFF)
val primaryContainerLightMediumContrast = Color(0xFF3A7955)
val onPrimaryContainerLightMediumContrast = Color(0xFFFFFFFF)
val secondaryLightMediumContrast = Color(0xFF273B2D)
val onSecondaryLightMediumContrast = Color(0xFFFFFFFF)
val secondaryContainerLightMediumContrast = Color(0xFF5D7263)
val onSecondaryContainerLightMediumContrast = Color(0xFFFFFFFF)
val tertiaryLightMediumContrast = Color(0xFF0C3B47)
val onTertiaryLightMediumContrast = Color(0xFFFFFFFF)
val tertiaryContainerLightMediumContrast = Color(0xFF4A7380)
val onTertiaryContainerLightMediumContrast = Color(0xFFFFFFFF)
val errorLightMediumContrast = Color(0xFF740006)
val onErrorLightMediumContrast = Color(0xFFFFFFFF)
val errorContainerLightMediumContrast = Color(0xFFCF2C27)
val onErrorContainerLightMediumContrast = Color(0xFFFFFFFF)
val backgroundLightMediumContrast = Color(0xFFF6FBF4)
val onBackgroundLightMediumContrast = Color(0xFF181D19)
val surfaceLightMediumContrast = Color(0xFFF6FBF4)
val onSurfaceLightMediumContrast = Color(0xFF0D120F)
val surfaceVariantLightMediumContrast = Color(0xFFDCE5DC)
val onSurfaceVariantLightMediumContrast = Color(0xFF303832)
val outlineLightMediumContrast = Color(0xFF4C544E)
val outlineVariantLightMediumContrast = Color(0xFF676F68)
val scrimLightMediumContrast = Color(0xFF000000)
val inverseSurfaceLightMediumContrast = Color(0xFF2C322D)
val inverseOnSurfaceLightMediumContrast = Color(0xFFEDF2EB)
val inversePrimaryLightMediumContrast = Color(0xFF93D5AA)
val surfaceDimLightMediumContrast = Color(0xFFC3C8C1)
val surfaceBrightLightMediumContrast = Color(0xFFF6FBF4)
val surfaceContainerLowestLightMediumContrast = Color(0xFFFFFFFF)
val surfaceContainerLowLightMediumContrast = Color(0xFFF0F5EE)
val surfaceContainerLightMediumContrast = Color(0xFFE4EAE3)
val surfaceContainerHighLightMediumContrast = Color(0xFFD9DED7)
val surfaceContainerHighestLightMediumContrast = Color(0xFFCED3CC)

val primaryLightHighContrast = Color(0xFF00341C)
val onPrimaryLightHighContrast = Color(0xFFFFFFFF)
val primaryContainerLightHighContrast = Color(0xFF0E5433)
val onPrimaryContainerLightHighContrast = Color(0xFFFFFFFF)
val secondaryLightHighContrast = Color(0xFF1D3024)
val onSecondaryLightHighContrast = Color(0xFFFFFFFF)
val secondaryContainerLightHighContrast = Color(0xFF394E40)
val onSecondaryContainerLightHighContrast = Color(0xFFFFFFFF)
val tertiaryLightHighContrast = Color(0xFF00313C)
val onTertiaryLightHighContrast = Color(0xFFFFFFFF)
val tertiaryContainerLightHighContrast = Color(0xFF244F5B)
val onTertiaryContainerLightHighContrast = Color(0xFFFFFFFF)
val errorLightHighContrast = Color(0xFF600004)
val onErrorLightHighContrast = Color(0xFFFFFFFF)
val errorContainerLightHighContrast = Color(0xFF98000A)
val onErrorContainerLightHighContrast = Color(0xFFFFFFFF)
val backgroundLightHighContrast = Color(0xFFF6FBF4)
val onBackgroundLightHighContrast = Color(0xFF181D19)
val surfaceLightHighContrast = Color(0xFFF6FBF4)
val onSurfaceLightHighContrast = Color(0xFF000000)
val surfaceVariantLightHighContrast = Color(0xFFDCE5DC)
val onSurfaceVariantLightHighContrast = Color(0xFF000000)
val outlineLightHighContrast = Color(0xFF262E28)
val outlineVariantLightHighContrast = Color(0xFF434B44)
val scrimLightHighContrast = Color(0xFF000000)
val inverseSurfaceLightHighContrast = Color(0xFF2C322D)
val inverseOnSurfaceLightHighContrast = Color(0xFFFFFFFF)
val inversePrimaryLightHighContrast = Color(0xFF93D5AA)
val surfaceDimLightHighContrast = Color(0xFFB5BAB4)
val surfaceBrightLightHighContrast = Color(0xFFF6FBF4)
val surfaceContainerLowestLightHighContrast = Color(0xFFFFFFFF)
val surfaceContainerLowLightHighContrast = Color(0xFFEDF2EB)
val surfaceContainerLightHighContrast = Color(0xFFDFE4DD)
val surfaceContainerHighLightHighContrast = Color(0xFFD1D6CF)
val surfaceContainerHighestLightHighContrast = Color(0xFFC3C8C1)

val primaryDark = Color(0xFF93D5AA)
val onPrimaryDark = Color(0xFF003920)
val primaryContainerDark = Color(0xFF095131)
val onPrimaryContainerDark = Color(0xFFAEF2C5)
val secondaryDark = Color(0xFFB5CCBA)
val onSecondaryDark = Color(0xFF213528)
val secondaryContainerDark = Color(0xFF374B3E)
val onSecondaryContainerDark = Color(0xFFD1E8D6)
val tertiaryDark = Color(0xFFA3CDDB)
val onTertiaryDark = Color(0xFF033541)
val tertiaryContainerDark = Color(0xFF224C58)
val onTertiaryContainerDark = Color(0xFFBFE9F8)
val errorDark = Color(0xFFFFB4AB)
val onErrorDark = Color(0xFF690005)
val errorContainerDark = Color(0xFF93000A)
val onErrorContainerDark = Color(0xFFFFDAD6)
val backgroundDark = Color(0xFF0F1511)
val onBackgroundDark = Color(0xFFDFE4DD)
val surfaceDark = Color(0xFF0F1511)
val onSurfaceDark = Color(0xFFDFE4DD)
val surfaceVariantDark = Color(0xFF414942)
val onSurfaceVariantDark = Color(0xFFC0C9C0)
val outlineDark = Color(0xFF8A938B)
val outlineVariantDark = Color(0xFF414942)
val scrimDark = Color(0xFF000000)
val inverseSurfaceDark = Color(0xFFDFE4DD)
val inverseOnSurfaceDark = Color(0xFF2C322D)
val inversePrimaryDark = Color(0xFF2A6A47)
val surfaceDimDark = Color(0xFF0F1511)
val surfaceBrightDark = Color(0xFF353B36)
val surfaceContainerLowestDark = Color(0xFF0A0F0C)
val surfaceContainerLowDark = Color(0xFF181D19)
val surfaceContainerDark = Color(0xFF1B211D)
val surfaceContainerHighDark = Color(0xFF262B27)
val surfaceContainerHighestDark = Color(0xFF313632)

val primaryDarkMediumContrast = Color(0xFFA8EBBF)
val onPrimaryDarkMediumContrast = Color(0xFF002C18)
val primaryContainerDarkMediumContrast = Color(0xFF5E9E77)
val onPrimaryContainerDarkMediumContrast = Color(0xFF000000)
val secondaryDarkMediumContrast = Color(0xFFCBE2CF)
val onSecondaryDarkMediumContrast = Color(0xFF162A1E)
val secondaryContainerDarkMediumContrast = Color(0xFF809685)
val onSecondaryContainerDarkMediumContrast = Color(0xFF000000)
val tertiaryDarkMediumContrast = Color(0xFFB9E3F2)
val onTertiaryDarkMediumContrast = Color(0xFF002A34)
val tertiaryContainerDarkMediumContrast = Color(0xFF6E97A4)
val onTertiaryContainerDarkMediumContrast = Color(0xFF000000)
val errorDarkMediumContrast = Color(0xFFFFD2CC)
val onErrorDarkMediumContrast = Color(0xFF540003)
val errorContainerDarkMediumContrast = Color(0xFFFF5449)
val onErrorContainerDarkMediumContrast = Color(0xFF000000)
val backgroundDarkMediumContrast = Color(0xFF0F1511)
val onBackgroundDarkMediumContrast = Color(0xFFDFE4DD)
val surfaceDarkMediumContrast = Color(0xFF0F1511)
val onSurfaceDarkMediumContrast = Color(0xFFFFFFFF)
val surfaceVariantDarkMediumContrast = Color(0xFF414942)
val onSurfaceVariantDarkMediumContrast = Color(0xFFD6DFD5)
val outlineDarkMediumContrast = Color(0xFFABB4AC)
val outlineVariantDarkMediumContrast = Color(0xFF8A928A)
val scrimDarkMediumContrast = Color(0xFF000000)
val inverseSurfaceDarkMediumContrast = Color(0xFFDFE4DD)
val inverseOnSurfaceDarkMediumContrast = Color(0xFF262B27)
val inversePrimaryDarkMediumContrast = Color(0xFF0C5332)
val surfaceDimDarkMediumContrast = Color(0xFF0F1511)
val surfaceBrightDarkMediumContrast = Color(0xFF404641)
val surfaceContainerLowestDarkMediumContrast = Color(0xFF040806)
val surfaceContainerLowDarkMediumContrast = Color(0xFF1A1F1B)
val surfaceContainerDarkMediumContrast = Color(0xFF242925)
val surfaceContainerHighDarkMediumContrast = Color(0xFF2E342F)
val surfaceContainerHighestDarkMediumContrast = Color(0xFF393F3A)

val primaryDarkHighContrast = Color(0xFFBDFFD3)
val onPrimaryDarkHighContrast = Color(0xFF000000)
val primaryContainerDarkHighContrast = Color(0xFF8FD1A6)
val onPrimaryContainerDarkHighContrast = Color(0xFF000F05)
val secondaryDarkHighContrast = Color(0xFFDEF6E3)
val onSecondaryDarkHighContrast = Color(0xFF000000)
val secondaryContainerDarkHighContrast = Color(0xFFB1C8B6)
val onSecondaryContainerDarkHighContrast = Color(0xFF000F05)
val tertiaryDarkHighContrast = Color(0xFFD8F5FF)
val onTertiaryDarkHighContrast = Color(0xFF000000)
val tertiaryContainerDarkHighContrast = Color(0xFF9FC9D7)
val onTertiaryContainerDarkHighContrast = Color(0xFF000D12)
val errorDarkHighContrast = Color(0xFFFFECE9)
val onErrorDarkHighContrast = Color(0xFF000000)
val errorContainerDarkHighContrast = Color(0xFFFFAEA4)
val onErrorContainerDarkHighContrast = Color(0xFF220001)
val backgroundDarkHighContrast = Color(0xFF0F1511)
val onBackgroundDarkHighContrast = Color(0xFFDFE4DD)
val surfaceDarkHighContrast = Color(0xFF0F1511)
val onSurfaceDarkHighContrast = Color(0xFFFFFFFF)
val surfaceVariantDarkHighContrast = Color(0xFF414942)
val onSurfaceVariantDarkHighContrast = Color(0xFFFFFFFF)
val outlineDarkHighContrast = Color(0xFFEAF2E9)
val outlineVariantDarkHighContrast = Color(0xFFBCC5BC)
val scrimDarkHighContrast = Color(0xFF000000)
val inverseSurfaceDarkHighContrast = Color(0xFFDFE4DD)
val inverseOnSurfaceDarkHighContrast = Color(0xFF000000)
val inversePrimaryDarkHighContrast = Color(0xFF0C5332)
val surfaceDimDarkHighContrast = Color(0xFF0F1511)
val surfaceBrightDarkHighContrast = Color(0xFF4C514C)
val surfaceContainerLowestDarkHighContrast = Color(0xFF000000)
val surfaceContainerLowDarkHighContrast = Color(0xFF1B211D)
val surfaceContainerDarkHighContrast = Color(0xFF2C322D)
val surfaceContainerHighDarkHighContrast = Color(0xFF373D38)
val surfaceContainerHighestDarkHighContrast = Color(0xFF434843)

@Suppress("unused")
val seed = Color(0xFF29CC82)
