<div align="center">

<p><img src="fastlane/metadata/android/en-US/images/icon.png" width="150"></p>
<h2><b>LibreTrack</b></h2>
<h4>Private, cross-platform package tracking app.</h4>

[![Get it from the Snap Store](https://snapcraft.io/static/images/badges/en/snap-store-black.svg)](https://snapcraft.io/libretrack)
[<img alt="Get it on Flathub" height="60" src="https://flathub.org/assets/badges/flathub-badge-en.svg">](https://flathub.org/apps/details/ru.proninyaroslav.libretrack)

[<img alt="Get it on F-Droid" height="80" src="https://tachibanagenerallaboratories.github.io/images/badges/F-Droid/get-it-on.png">](https://f-droid.org/packages/org.proninyaroslav.libretrack)
[<img alt="Get it on Google Play" height="80" src="https://tachibanagenerallaboratories.github.io/images/badges/Google%20Play/google-play-badge.png">](https://play.google.com/store/apps/details?id=org.proninyaroslav.libretrack)
[<img alt="Get it on OpenAPK" height="80" src="https://www.openapk.net/images/openapk-badge.png">](https://www.openapk.net/libretrack/org.proninyaroslav.libretrack/)
[<img alt="Get it on GitHub" height="80" src="https://tachibanagenerallaboratories.github.io/images/badges/GitHub/get-it-on-github.png">](https://github.com/proninyaroslav/libretrack/releases)
[<img alt="Direct APK Download" height="80" src="https://tachibanagenerallaboratories.github.io/images/badges/Direct%20Download/direct-apk-download.png">](https://proninyaroslav.ru/ftp/libretrack)

![Current version](https://img.shields.io/github/release/proninyaroslav/libretrack.svg?logo=github)
![Made with Flutter](https://img.shields.io/badge/Made%20with-Flutter-blue.svg)
[![Releases](https://img.shields.io/github/downloads/proninyaroslav/libretrack/total.svg)](https://github.com/proninyaroslav/libretrack/releases)
[![Matrix Room](https://img.shields.io/matrix/libretrack:matrix.org?label=Matrix%20Room)](https://matrix.to/#libretrack:matrix.org)
[![Chat - Telegram](https://img.shields.io/badge/chat-Telegram-blue.svg)](https://t.me/LibreTrack)

</div>

---

## Screenshots

<div align="center">

[<img src="art/screenshots/phone.png" width=160>](art/screenshots/phone.png)
[<img src="art/screenshots/phone_dark.png" width=160>](art/screenshots/phone_dark.png)
[<img src="art/screenshots/tablet.png" width=480>](art/screenshots/tablet.png)
[<img src="art/linux_screenshots/s1.png" width=480>](art/linux_screenshots/s1.png)

</div>

## Description

Track postal items directly on your device using accounts of postal services. The app respects your privacy and freedom: you don't use third-party online services.

[Use, see, change and share](https://en.wikipedia.org/wiki/Free_software); [with all](https://en.wikipedia.org/wiki/Copyleft).

## 📋 Features

- Free and Open Source software (FOSS)
- Support for various platfroms and devices
- Support accounts of different carriers
- Detailed information about the postal items, carriers, tracking history
- Local push notifications
- Automatic tracking in the background, and also manual refreshing
- Ability to add a list of track numbers
- Filter and sort numbers by activity date, package status, carrier, etc
- Barcode and QR code scanner for tracking numbers
- Barcode generator
- Archiving tracking numbers
- Material Design 2.0
- Night theme
- Responsive UI for different devices form factors
- [Linux]: System tray support. Note: for support in GNOME, please install [gnome-shell-extension-appindicator](https://extensions.gnome.org/extension/615/appindicator-support/) or similar extension.

## 🖥️💻📱 Available platforms

- Android
- Linux
- ~~iOS~~ (planned)
- ~~macOS~~ (planned)
- ~~Web~~ (planned)
- ~~Windows~~ (planned)

## 📦 Supported postal services

[![UPS](assets/service_logo/ups.png)](https://www.ups.com)
[![Russian Post](assets/service_logo/russian_post.png)](https://www.pochta.ru/)
[![USPS](assets/service_logo/usps.png)](https://www.usps.com/)
[![PostNord](art/postnord.png)](https://www.postnord.se/en/)

## 🌍 Translations

- **English**
- **Itialian** _(thanks albanobattistella)_
- **Russian**
- **Spanish** _(thanks sguinetti)_
- **French** _(thanks BNouailhac)_

## 💰 Donation

If you like LibreTrack you can support developer with these methods. If you have problems with payment or you want to donate in another way, contact me: `proninyaroslav@mail.ru`. Thank you!

 - **Bitcoin**: `12isaLkH8nZ4DkFguVFeYrGHqQi7EEgUrM `
 - **USDT TRC20**: `TK79fzUYwRtmANuLjk1Zzhz3hjTaFQbxfg`
 - **Monero**: `48j4Mo7J7t51EeBf35Lpdmehmi9chUwzSXxHrnjpRJ6fPQafPWvSCdFafw3rA5ZRWievfYEDToNso8VppbJf2RVH9cdZmHa`
 - **PayPal**: [paypal.me/YaroslavPronin](https://paypal.me/YaroslavPronin)
 - **YooMoney (ЮMoney)**: `410011738561939`
 - **Patreon**: [patreon.com/YaroslavPronin](https://patreon.com/YaroslavPronin)
 - **Boosty**: [boosty.to/yaroslavpronin/donate](https://boosty.to/yaroslavpronin/donate)
 - **Amazon.com eGift Cards**: just choose your amount and type e-mail `proninyaroslav@mail.ru`
in the gift card details [smile.amazon.com/gp/product/B004LLIKVU](https://smile.amazon.com/gp/product/B004LLIKVU)
 - **Liberapay**: [![liberapay](https://liberapay.com/assets/widgets/donate.svg)](https://liberapay.com/proninyaroslav/donate)

## ⚙️ Building

Please see [BUILD.md](BUILD.md)

## 🎉 Contributing

Please see [CONTRIBUTING.md](CONTRIBUTING.md)

#### Developers

- [Yaroslav Pronin](https://github.com/proninyaroslav)

#### Logo

- [Ramy (@rshirwan)](https://t.me/rshirwan)

## 🔒 Privacy Policy

Please see our [Privacy Policy](PRIVACY.md).

## 📄 License

[![Large GPLv3 logo with “Free as in Freedom”](https://www.gnu.org/graphics/gplv3-with-text-136x68.png)](http://www.gnu.org/licenses/gpl-3.0.en.html)

    Copyright (C) 2021 Yaroslav Pronin <proninyaroslav@mail.ru>
    Copyright (C) 2021 Insurgo Inc. <insurgo@riseup.net>
    This file is part of LibreTrack.
    LibreTrack is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
