import 'package:flutter/material.dart';

/// An icon for a [TargetPlatform].
class TargetPlatformIcon extends StatelessWidget {
  /// Creates an icon for the given [platform].
  ///
  /// A [color] can be given to customize the icon color.
  const TargetPlatformIcon({
    Key? key,
    required this.platform,
    this.color,
  }) : super(key: key);

  final Color? color;
  final TargetPlatform platform;

  @override
  Widget build(BuildContext context) {
    final color = this.color ?? IconTheme.of(context).color ?? Colors.black;
    return FittedBox(
      child: SizedBox(
        width: 24,
        height: 24,
        child: CustomPaint(
          size: const Size(24, 24),
          painter: _PathPainter(
            platform,
            color,
          ),
        ),
      ),
    );
  }
}

class _PathPainter extends CustomPainter {
  const _PathPainter(this.target, this.color);

  final TargetPlatform target;
  final Color color;

  @override
  void paint(Canvas canvas, Size size) {
    final paint = Paint()..color = color;
    final path = _paths[target];
    canvas.drawPath(path!, paint);
  }

  @override
  bool shouldRepaint(_PathPainter oldDelegate) =>
      target != oldDelegate.target || color != oldDelegate.color;
}

/// All paths are genereted from https://simpleicons.org/ with https://fluttershapemaker.com/
final _paths = <TargetPlatform, Path>{
  TargetPlatform.iOS: Path()
    ..moveTo(
      12.152,
      6.896,
    )
    ..cubicTo(
      11.203999999999999,
      6.896,
      9.736999999999998,
      5.818,
      8.192,
      5.856,
    )
    ..cubicTo(
      6.152,
      5.883,
      4.282,
      7.039,
      3.231,
      8.87,
    )
    ..cubicTo(
      1.1139999999999999,
      12.544999999999998,
      2.6849999999999996,
      17.973,
      4.75,
      20.96,
    )
    ..cubicTo(
      5.763,
      22.414,
      6.958,
      24.05,
      8.542,
      23.999000000000002,
    )
    ..cubicTo(
      10.062,
      23.934,
      10.632,
      23.012000000000004,
      12.477,
      23.012000000000004,
    )
    ..cubicTo(
      14.308,
      23.012000000000004,
      14.827,
      23.999000000000002,
      16.437,
      23.960000000000004,
    )
    ..cubicTo(
      18.074,
      23.934000000000005,
      19.113,
      22.480000000000004,
      20.113,
      21.012000000000004,
    )
    ..cubicTo(
      21.269,
      19.324000000000005,
      21.749,
      17.687000000000005,
      21.775,
      17.597000000000005,
    )
    ..cubicTo(
      21.735999999999997,
      17.584000000000003,
      18.593,
      16.376000000000005,
      18.555,
      12.740000000000006,
    )
    ..cubicTo(
      18.529,
      9.700000000000006,
      21.035,
      8.246000000000006,
      21.152,
      8.181000000000004,
    )
    ..cubicTo(
      19.723000000000003,
      6.091000000000005,
      17.529,
      5.857000000000005,
      16.762,
      5.805000000000005,
    )
    ..cubicTo(
      14.762,
      5.649000000000005,
      13.087,
      6.895000000000005,
      12.152000000000001,
      6.895000000000005,
    )
    ..close()
    ..moveTo(
      15.53,
      3.83,
    )
    ..cubicTo(
      16.372999999999998,
      2.818,
      16.93,
      1.403,
      16.775,
      0,
    )
    ..cubicTo(
      15.567999999999998,
      0.052,
      14.113,
      0.805,
      13.242999999999999,
      1.818,
    )
    ..cubicTo(
      12.463,
      2.714,
      11.788999999999998,
      4.156000000000001,
      11.969999999999999,
      5.532,
    )
    ..cubicTo(
      13.308,
      5.636,
      14.684999999999999,
      4.844,
      15.529,
      3.831,
    ),
  TargetPlatform.macOS: Path()
    ..moveTo(0, 14.727)
    ..lineTo(0.941, 14.727)
    ..lineTo(0.941, 12.274000000000001)
    ..cubicTo(0.941, 11.790000000000001, 1.259, 11.439, 1.712, 11.439)
    ..cubicTo(
      2.151,
      11.439,
      2.4219999999999997,
      11.715,
      2.4219999999999997,
      12.161,
    )
    ..lineTo(2.4219999999999997, 14.727)
    ..lineTo(3.3369999999999997, 14.727)
    ..lineTo(3.3369999999999997, 12.25)
    ..cubicTo(3.3369999999999997, 11.77, 3.647, 11.438, 4.101, 11.438)
    ..cubicTo(4.561, 11.438, 4.819, 11.718, 4.819, 12.208)
    ..lineTo(4.819, 14.725999999999999)
    ..lineTo(5.759, 14.725999999999999)
    ..lineTo(5.759, 11.977999999999998)
    ..cubicTo(
      5.759,
      11.176999999999998,
      5.242,
      10.643999999999998,
      4.452,
      10.643999999999998,
    )
    ..cubicTo(
      3.874,
      10.643999999999998,
      3.3979999999999997,
      10.953999999999999,
      3.205,
      11.448999999999998,
    )
    ..lineTo(3.182, 11.448999999999998)
    ..cubicTo(
      3.035,
      10.934999999999999,
      2.63,
      10.643999999999998,
      2.064,
      10.643999999999998,
    )
    ..cubicTo(
      1.5190000000000001,
      10.643999999999998,
      1.096,
      10.949999999999998,
      0.9220000000000002,
      11.415,
    )
    ..lineTo(0.903, 11.415)
    ..lineTo(0.903, 10.719999999999999)
    ..lineTo(0, 10.719999999999999)
    ..lineTo(0, 14.725999999999999)
    ..close()
    ..moveTo(7.82, 14.081)
    ..cubicTo(
      7.412,
      14.081,
      7.140000000000001,
      13.873,
      7.140000000000001,
      13.543999999999999,
    )
    ..cubicTo(
      7.140000000000001,
      13.225999999999999,
      7.4,
      13.021999999999998,
      7.854000000000001,
      12.991999999999999,
    )
    ..lineTo(8.780000000000001, 12.934999999999999)
    ..lineTo(8.780000000000001, 13.241999999999999)
    ..cubicTo(
      8.780000000000001,
      13.725,
      8.353000000000002,
      14.081,
      7.820000000000001,
      14.081,
    )
    ..close()
    ..moveTo(7.5360000000000005, 14.791)
    ..cubicTo(8.05, 14.791, 8.553, 14.523, 8.784, 14.088000000000001)
    ..lineTo(8.802000000000001, 14.088000000000001)
    ..lineTo(8.802000000000001, 14.727)
    ..lineTo(9.71, 14.727)
    ..lineTo(9.71, 11.967)
    ..cubicTo(9.71, 11.163, 9.063, 10.637, 8.07, 10.637)
    ..cubicTo(7.049, 10.637, 6.41, 11.174000000000001, 6.369, 11.922)
    ..lineTo(7.242, 11.922)
    ..cubicTo(7.302, 11.59, 7.586, 11.374, 8.032, 11.374)
    ..cubicTo(8.496, 11.374, 8.78, 11.616, 8.78, 12.036000000000001)
    ..lineTo(8.78, 12.323000000000002)
    ..lineTo(7.7219999999999995, 12.383000000000003)
    ..cubicTo(
      6.7459999999999996,
      12.444000000000003,
      6.1979999999999995,
      12.871000000000002,
      6.1979999999999995,
      13.582000000000003,
    )
    ..cubicTo(
      6.1979999999999995,
      14.303000000000003,
      6.762,
      14.791000000000002,
      7.536,
      14.791000000000002,
    )
    ..close()
    ..moveTo(13.841000000000001, 12.149000000000001)
    ..cubicTo(
      13.776000000000002,
      11.306000000000001,
      13.122000000000002,
      10.637,
      12.064000000000002,
      10.637,
    )
    ..cubicTo(
      10.900000000000002,
      10.637,
      10.144000000000002,
      11.442,
      10.144000000000002,
      12.724,
    )
    ..cubicTo(
      10.144000000000002,
      14.024000000000001,
      10.900000000000002,
      14.806000000000001,
      12.072000000000003,
      14.806000000000001,
    )
    ..cubicTo(
      13.077000000000002,
      14.806000000000001,
      13.769000000000002,
      14.216000000000001,
      13.844000000000003,
      13.321000000000002,
    )
    ..lineTo(12.956000000000003, 13.321000000000002)
    ..cubicTo(
      12.869000000000003,
      13.774000000000001,
      12.559000000000003,
      14.046000000000001,
      12.083000000000004,
      14.046000000000001,
    )
    ..cubicTo(
      11.486000000000004,
      14.046000000000001,
      11.101000000000004,
      13.563,
      11.101000000000004,
      12.724,
    )
    ..cubicTo(
      11.101000000000004,
      11.9,
      11.482000000000005,
      11.401,
      12.076000000000004,
      11.401,
    )
    ..cubicTo(
      12.578000000000005,
      11.401,
      12.876000000000005,
      11.722,
      12.952000000000004,
      12.149,
    )
    ..lineTo(13.841000000000003, 12.149)
    ..close()
    ..moveTo(16.747, 9.182)
    ..cubicTo(15.156, 9.182, 14.158, 10.267, 14.158, 12.002)
    ..cubicTo(
      14.158,
      13.737,
      15.155999999999999,
      14.818000000000001,
      16.747999999999998,
      14.818000000000001,
    )
    ..cubicTo(
      18.333999999999996,
      14.818000000000001,
      19.331999999999997,
      13.737000000000002,
      19.331999999999997,
      12.002000000000002,
    )
    ..cubicTo(
      19.331999999999997,
      10.267000000000003,
      18.334999999999997,
      9.182000000000002,
      16.746999999999996,
      9.182000000000002,
    )
    ..close()
    ..moveTo(16.747, 10.014000000000001)
    ..cubicTo(17.718, 10.014000000000001, 18.338, 10.784, 18.338, 12.002)
    ..cubicTo(18.338, 13.215, 17.718, 13.986, 16.748, 13.986)
    ..cubicTo(
      15.772000000000002,
      13.986,
      15.156,
      13.216000000000001,
      15.156,
      12.002,
    )
    ..cubicTo(
      15.156,
      10.785,
      15.772,
      10.014000000000001,
      16.747,
      10.014000000000001,
    )
    ..close()
    ..moveTo(19.729, 13.192)
    ..cubicTo(19.771, 14.198, 20.595, 14.818, 21.849, 14.818)
    ..cubicTo(23.169, 14.818, 24, 14.168, 24, 13.132)
    ..cubicTo(24, 12.318999999999999, 23.531, 11.862, 22.424, 11.609)
    ..lineTo(21.797, 11.465)
    ..cubicTo(21.127, 11.307, 20.852, 11.095, 20.852, 10.732)
    ..cubicTo(
      20.852,
      10.279,
      21.267,
      9.975999999999999,
      21.884,
      9.975999999999999,
    )
    ..cubicTo(
      22.507,
      9.975999999999999,
      22.934,
      10.281999999999998,
      22.98,
      10.793,
    )
    ..lineTo(23.91, 10.793)
    ..cubicTo(23.887, 9.832999999999998, 23.093, 9.183, 21.891, 9.183)
    ..cubicTo(
      20.703999999999997,
      9.183,
      19.860999999999997,
      9.836,
      19.860999999999997,
      10.803,
    )
    ..cubicTo(
      19.860999999999997,
      11.583,
      20.337999999999997,
      12.066,
      21.342999999999996,
      12.297,
    )
    ..lineTo(22.049999999999997, 12.463000000000001)
    ..cubicTo(
      22.737999999999996,
      12.626000000000001,
      23.016999999999996,
      12.853000000000002,
      23.016999999999996,
      13.245000000000001,
    )
    ..cubicTo(
      23.016999999999996,
      13.699000000000002,
      22.559999999999995,
      14.024000000000001,
      21.901999999999997,
      14.024000000000001,
    )
    ..cubicTo(
      21.237,
      14.024000000000001,
      20.734999999999996,
      13.695,
      20.673999999999996,
      13.192,
    )
    ..lineTo(19.728999999999996, 13.192)
    ..close(),
  TargetPlatform.android: Path()
    ..moveTo(17.523, 15.3413)
    ..cubicTo(16.9719, 15.3413, 16.5237, 14.8927, 16.5237, 14.3416)
    ..cubicTo(16.5237, 13.7905, 16.972, 13.3423, 17.523, 13.3423)
    ..cubicTo(18.0741, 13.3423, 18.5223, 13.7906, 18.5223, 14.3416)
    ..cubicTo(18.5224, 14.8927, 18.0741, 15.3413, 17.523, 15.3413)
    ..close()
    ..moveTo(6.477, 15.3413)
    ..cubicTo(5.9259, 15.3413, 5.4777, 14.8927, 5.4777, 14.3416)
    ..cubicTo(5.4777, 13.7905, 5.9259, 13.3423, 6.477, 13.3423)
    ..cubicTo(7.0281, 13.3423, 7.4763, 13.7906, 7.4763, 14.3416)
    ..cubicTo(7.4763, 14.8927, 7.028, 15.3413, 6.477, 15.3413)
    ..close()
    ..moveTo(17.8815, 9.32131)
    ..lineTo(19.8788, 5.86211)
    ..cubicTo(19.9338, 5.76664, 19.9486, 5.65327, 19.9201, 5.54686)
    ..cubicTo(19.8916, 5.44045, 19.822, 5.3497, 19.7267, 5.29451)
    ..cubicTo(19.6312, 5.23954, 19.5179, 5.22468, 19.4115, 5.2532)
    ..cubicTo(19.305, 5.28171, 19.2143, 5.35127, 19.1591, 5.44661)
    ..lineTo(17.1368, 8.94961)
    ..cubicTo(15.5902, 8.24381, 13.8533, 7.85071, 12, 7.85071)
    ..cubicTo(10.1467, 7.85071, 8.4098, 8.24381, 6.8633, 8.94961)
    ..lineTo(4.841, 5.44661)
    ..cubicTo(4.78579, 5.35126, 4.69502, 5.2817, 4.5886, 5.25319)
    ..cubicTo(4.48217, 5.22468, 4.36878, 5.23954, 4.2733, 5.29451)
    ..cubicTo(4.1779, 5.34964, 4.10829, 5.4404, 4.07977, 5.54683)
    ..cubicTo(4.05125, 5.65326, 4.06615, 5.76666, 4.1212, 5.86211)
    ..lineTo(6.1185, 9.32131)
    ..cubicTo(2.6889, 11.1866, 0.3432, 14.6588, 0, 18.7609)
    ..lineTo(24, 18.7609)
    ..cubicTo(23.6565, 14.6588, 21.3108, 11.1866, 17.8815, 9.32131),
  TargetPlatform.windows: Path()
    ..moveTo(0, 3.449)
    ..lineTo(9.75, 2.1)
    ..lineTo(9.75, 11.551)
    ..lineTo(0, 11.551)
    ..moveTo(10.949, 1.9489999999999998)
    ..lineTo(24, 0)
    ..lineTo(24, 11.4)
    ..lineTo(10.949, 11.4)
    ..moveTo(0, 12.6)
    ..lineTo(9.75, 12.6)
    ..lineTo(9.75, 22.051000000000002)
    ..lineTo(0, 20.699)
    ..moveTo(10.949, 12.6)
    ..lineTo(24, 12.6)
    ..lineTo(24, 24)
    ..lineTo(11.1, 22.199),
  TargetPlatform.fuchsia: Path()
    ..moveTo(10.9836, 1.29598)
    ..cubicTo(5.07959, 1.72798, 0.615591, 6.81598, 0.999591, 12.72)
    ..cubicTo(1.38359, 18.624, 6.51959, 23.088, 12.4236, 22.656)
    ..cubicTo(13.5276, 22.56, 14.6316, 22.32, 15.6876, 21.888)
    ..cubicTo(15.8316, 21.84, 15.8796, 21.696, 15.8316, 21.552)
    ..cubicTo(15.7836, 21.456, 15.6876, 21.36, 15.5436, 21.408)
    ..cubicTo(15.4956, 21.408, 15.4956, 21.408, 15.4476, 21.408)
    ..cubicTo(14.4396, 21.792, 13.4316, 22.032, 12.3276, 22.128)
    ..cubicTo(6.80759, 22.512, 1.95959, 18.288, 1.57559, 12.672)
    ..cubicTo(1.19159, 7.05598, 5.41559, 2.20798, 11.0316, 1.82398)
    ..cubicTo(16.6476, 1.43998, 21.4956, 5.66398, 21.8796, 11.28)
    ..cubicTo(21.9276, 11.664, 21.9276, 12.096, 21.8796, 12.48)
    ..cubicTo(21.8796, 12.528, 21.8796, 12.624, 21.9276, 12.672)
    ..cubicTo(21.9756, 12.72, 22.0236, 12.768, 22.1196, 12.768)
    ..cubicTo(22.1196, 12.768, 22.1196, 12.768, 22.1676, 12.768)
    ..cubicTo(22.3116, 12.768, 22.4076, 12.672, 22.4076, 12.528)
    ..cubicTo(22.4076, 12.096, 22.4076, 11.664, 22.4076, 11.232)
    ..cubicTo(21.9756, 5.37598, 16.8876, 0.91198, 10.9836, 1.29598)
    ..close()
    ..moveTo(23.2236, 14.4)
    ..cubicTo(22.4556, 13.776, 21.4956, 13.392, 20.4876, 13.392)
    ..cubicTo(20.3436, 14.256, 20.1036, 15.024, 19.7676, 15.792)
    ..cubicTo(19.9596, 15.744, 20.1516, 15.744, 20.3436, 15.744)
    ..cubicTo(20.9196, 15.744, 21.3996, 15.936, 21.7836, 16.272)
    ..cubicTo(22.3116, 16.704, 22.6476, 17.376, 22.6476, 18.096)
    ..cubicTo(22.6476, 19.392, 21.5916, 20.448, 20.2956, 20.448)
    ..cubicTo(18.9996, 20.448, 17.9436, 19.392, 17.9436, 18.096)
    ..cubicTo(17.9436, 17.616, 18.0876, 17.136, 18.3756, 16.752)
    ..cubicTo(20.9676, 13.056, 20.1036, 7.96798, 16.3596, 5.32798)
    ..cubicTo(12.6636, 2.73598, 7.57559, 3.59998, 4.93559, 7.34398)
    ..cubicTo(2.34359, 11.04, 3.20759, 16.128, 6.95159, 18.768)
    ..cubicTo(9.44759, 20.544, 12.6156, 20.688, 15.1596, 19.44)
    ..cubicTo(14.9196, 18.576, 14.9196, 17.616, 15.1596, 16.704)
    ..cubicTo(13.1916, 18.192, 10.4076, 18.336, 8.24759, 16.848)
    ..cubicTo(5.60759, 14.976, 4.98359, 11.328, 6.80759, 8.68798)
    ..cubicTo(8.67959, 6.04798, 12.3276, 5.42398, 14.9676, 7.24798)
    ..cubicTo(17.6076, 9.11998, 18.2316, 12.768, 16.4076, 15.408)
    ..cubicTo(15.8796, 16.176, 15.5436, 17.088, 15.5436, 18.096)
    ..cubicTo(15.5436, 20.688, 17.6556, 22.752, 20.1996, 22.752)
    ..cubicTo(22.7436, 22.752, 24.9996, 20.64, 24.9996, 18.048)
    ..cubicTo(24.9996, 16.56, 24.3276, 15.264, 23.2236, 14.4)
    ..close(),
  TargetPlatform.linux: Path()
    ..moveTo(12.504, 0)
    ..cubicTo(12.349, 0, 12.189, 0.008, 12.024, 0.021)
    ..cubicTo(7.79805, 0.354, 8.91905, 4.828, 8.85405, 6.319)
    ..cubicTo(8.77805, 7.411, 8.55405, 8.272, 7.80405, 9.339)
    ..cubicTo(6.91905, 10.39, 5.67705, 12.089, 5.08805, 13.86)
    ..cubicTo(4.81005, 14.692, 4.67805, 15.544, 4.80105, 16.349)
    ..cubicTo(4.75544, 16.3859, 4.71798, 16.4319, 4.69105, 16.484)
    ..cubicTo(4.43105, 16.752, 4.24105, 17.084, 4.02805, 17.323)
    ..cubicTo(3.82905, 17.522, 3.54305, 17.59, 3.23105, 17.723)
    ..cubicTo(2.91805, 17.859, 2.57305, 17.992, 2.36705, 18.403)
    ..cubicTo(2.27705, 18.592, 2.23105, 18.797, 2.23505, 19.005)
    ..cubicTo(2.23505, 19.204, 2.26205, 19.405, 2.29005, 19.541)
    ..cubicTo(2.34805, 19.94, 2.40605, 20.269, 2.33005, 20.511)
    ..cubicTo(2.08105, 21.191, 2.05005, 21.656, 2.22405, 21.995)
    ..cubicTo(2.39805, 22.329, 2.75905, 22.465, 3.16405, 22.596)
    ..cubicTo(3.97405, 22.796, 5.07405, 22.731, 5.93805, 23.196)
    ..cubicTo(6.86405, 23.662, 7.80405, 23.866, 8.55405, 23.666)
    ..cubicTo(9.08005, 23.55, 9.52405, 23.202, 9.76205, 22.72)
    ..cubicTo(10.349, 22.717, 10.992, 22.451, 12.022, 22.386)
    ..cubicTo(12.721, 22.328, 13.596, 22.653, 14.599, 22.586)
    ..cubicTo(14.624, 22.72, 14.662, 22.784, 14.713, 22.919)
    ..lineTo(14.716, 22.922)
    ..cubicTo(15.107, 23.7, 15.829, 24.054, 16.6, 23.993)
    ..cubicTo(17.3711, 23.933, 18.192, 23.457, 18.857, 22.687)
    ..cubicTo(19.488, 21.922, 20.5401, 21.603, 21.2351, 21.184)
    ..cubicTo(21.5831, 20.985, 21.8641, 20.715, 21.8841, 20.331)
    ..cubicTo(21.9071, 19.931, 21.684, 19.52, 21.17, 18.955)
    ..lineTo(21.17, 18.858)
    ..lineTo(21.167, 18.855)
    ..cubicTo(20.997, 18.655, 20.9171, 18.32, 20.8291, 17.929)
    ..cubicTo(20.7441, 17.528, 20.647, 17.143, 20.337, 16.883)
    ..lineTo(20.334, 16.883)
    ..cubicTo(20.275, 16.829, 20.211, 16.816, 20.146, 16.748)
    ..cubicTo(20.0901, 16.709, 20.0242, 16.6867, 19.956, 16.684)
    ..cubicTo(20.387, 15.406, 20.2201, 14.134, 19.7831, 12.99)
    ..cubicTo(19.2501, 11.58, 18.318, 10.352, 17.608, 9.507)
    ..cubicTo(16.812, 8.502, 16.032, 7.55, 16.048, 6.139)
    ..cubicTo(16.074, 3.987, 16.284, 0.006, 12.504, 0)
    ..lineTo(12.504, 0)
    ..close()
    ..moveTo(13.033, 3.405)
    ..lineTo(13.046, 3.405)
    ..cubicTo(13.259, 3.405, 13.442, 3.467, 13.63, 3.603)
    ..cubicTo(13.82, 3.738, 13.96, 3.935, 14.068, 4.136)
    ..cubicTo(14.173, 4.395, 14.226, 4.595, 14.234, 4.86)
    ..cubicTo(14.234, 4.84, 14.24, 4.82, 14.24, 4.8)
    ..lineTo(14.24, 4.905)
    ..cubicTo(14.2378, 4.89819, 14.2365, 4.89114, 14.236, 4.884)
    ..lineTo(14.232, 4.86)
    ..cubicTo(14.23, 5.10303, 14.179, 5.34315, 14.082, 5.566)
    ..cubicTo(14.0354, 5.69138, 13.9628, 5.80552, 13.8691, 5.901)
    ..cubicTo(13.8407, 5.885, 13.8113, 5.87097, 13.781, 5.859)
    ..cubicTo(13.677, 5.814, 13.583, 5.795, 13.497, 5.726)
    ..cubicTo(13.4258, 5.69761, 13.3522, 5.67553, 13.2771, 5.66)
    ..cubicTo(13.3271, 5.6, 13.423, 5.527, 13.46, 5.462)
    ..cubicTo(13.513, 5.334, 13.542, 5.198, 13.548, 5.06)
    ..lineTo(13.548, 5.04)
    ..cubicTo(13.5503, 4.90419, 13.5297, 4.76896, 13.4871, 4.64)
    ..cubicTo(13.4421, 4.506, 13.386, 4.44, 13.304, 4.307)
    ..cubicTo(13.22, 4.241, 13.137, 4.175, 13.037, 4.175)
    ..lineTo(13.021, 4.175)
    ..cubicTo(12.928, 4.175, 12.845, 4.205, 12.759, 4.307)
    ..cubicTo(12.6641, 4.39962, 12.5936, 4.51439, 12.554, 4.641)
    ..cubicTo(12.5009, 4.76806, 12.4705, 4.90344, 12.464, 5.041)
    ..lineTo(12.464, 5.06)
    ..cubicTo(12.466, 5.149, 12.472, 5.239, 12.484, 5.327)
    ..cubicTo(12.291, 5.26, 12.046, 5.192, 11.877, 5.125)
    ..cubicTo(11.867, 5.05877, 11.8609, 4.99197, 11.859, 4.925)
    ..lineTo(11.859, 4.905)
    ..cubicTo(11.8512, 4.64102, 11.9024, 4.37862, 12.009, 4.137)
    ..cubicTo(12.091, 3.917, 12.241, 3.731, 12.439, 3.604)
    ..cubicTo(12.61, 3.47444, 12.8186, 3.40421, 13.033, 3.404)
    ..lineTo(13.033, 3.405)
    ..close()
    ..moveTo(10.071, 3.464)
    ..lineTo(10.107, 3.464)
    ..cubicTo(10.249, 3.464, 10.377, 3.512, 10.506, 3.599)
    ..cubicTo(10.652, 3.728, 10.77, 3.887, 10.85, 4.064)
    ..cubicTo(10.94, 4.263, 10.99, 4.464, 11.003, 4.731)
    ..lineTo(11.003, 4.735)
    ..cubicTo(11.01, 4.869, 11.009, 4.935, 11.001, 5.001)
    ..lineTo(11.001, 5.081)
    ..cubicTo(10.971, 5.088, 10.945, 5.099, 10.918, 5.105)
    ..cubicTo(10.766, 5.16, 10.644, 5.24, 10.525, 5.305)
    ..cubicTo(10.537, 5.215, 10.538, 5.125, 10.528, 5.038)
    ..lineTo(10.528, 5.023)
    ..cubicTo(10.516, 4.89, 10.488, 4.823, 10.446, 4.69)
    ..cubicTo(10.4149, 4.58808, 10.3577, 4.49606, 10.28, 4.423)
    ..cubicTo(10.2554, 4.40059, 10.2265, 4.38337, 10.1951, 4.37238)
    ..cubicTo(10.1636, 4.36138, 10.1303, 4.35683, 10.097, 4.359)
    ..lineTo(10.076, 4.359)
    ..cubicTo(10.005, 4.365, 9.94605, 4.399, 9.89005, 4.491)
    ..cubicTo(9.82626, 4.56842, 9.78477, 4.66177, 9.77005, 4.761)
    ..cubicTo(9.74302, 4.86879, 9.73523, 4.9805, 9.74705, 5.091)
    ..lineTo(9.74705, 5.106)
    ..cubicTo(9.75905, 5.241, 9.78405, 5.306, 9.82705, 5.44)
    ..cubicTo(9.87305, 5.574, 9.92505, 5.64, 9.99305, 5.708)
    ..cubicTo(10.003, 5.717, 10.0131, 5.726, 10.0271, 5.732)
    ..cubicTo(9.95705, 5.789, 9.91005, 5.802, 9.85105, 5.868)
    ..cubicTo(9.81363, 5.90108, 9.76864, 5.92444, 9.72005, 5.936)
    ..cubicTo(9.6161, 5.81083, 9.52403, 5.67625, 9.44505, 5.534)
    ..cubicTo(9.35051, 5.32386, 9.29786, 5.0973, 9.29005, 4.867)
    ..cubicTo(9.27349, 4.64126, 9.30065, 4.41445, 9.37005, 4.199)
    ..cubicTo(9.42513, 4.00252, 9.52163, 3.8201, 9.65305, 3.664)
    ..cubicTo(9.78105, 3.531, 9.91305, 3.464, 10.071, 3.464)
    ..lineTo(10.071, 3.464)
    ..close()
    ..moveTo(11.441, 5.17)
    ..cubicTo(11.773, 5.17, 12.174, 5.235, 12.657, 5.569)
    ..cubicTo(12.95, 5.769, 13.18, 5.838, 13.709, 6.037)
    ..lineTo(13.712, 6.037)
    ..cubicTo(13.967, 6.173, 14.117, 6.303, 14.19, 6.436)
    ..lineTo(14.19, 6.305)
    ..cubicTo(14.2259, 6.37771, 14.2459, 6.45724, 14.2487, 6.53828)
    ..cubicTo(14.2514, 6.61932, 14.2369, 6.70001, 14.206, 6.775)
    ..cubicTo(14.083, 7.085, 13.69, 7.418, 13.143, 7.617)
    ..lineTo(13.143, 7.619)
    ..cubicTo(12.875, 7.754, 12.642, 7.952, 12.368, 8.084)
    ..cubicTo(12.092, 8.219, 11.78, 8.376, 11.356, 8.351)
    ..cubicTo(11.2037, 8.35889, 11.0514, 8.3361, 10.908, 8.284)
    ..cubicTo(10.7973, 8.22374, 10.6898, 8.15765, 10.5861, 8.086)
    ..cubicTo(10.3911, 7.951, 10.223, 7.754, 9.97405, 7.621)
    ..lineTo(9.97405, 7.616)
    ..lineTo(9.96905, 7.616)
    ..cubicTo(9.56905, 7.37, 9.35305, 7.104, 9.28305, 6.906)
    ..cubicTo(9.21305, 6.638, 9.27805, 6.436, 9.47605, 6.306)
    ..cubicTo(9.70005, 6.171, 9.85605, 6.035, 9.95905, 5.97)
    ..cubicTo(10.063, 5.896, 10.102, 5.868, 10.135, 5.839)
    ..lineTo(10.137, 5.839)
    ..lineTo(10.137, 5.836)
    ..cubicTo(10.306, 5.634, 10.573, 5.366, 10.976, 5.235)
    ..cubicTo(11.115, 5.199, 11.27, 5.17, 11.442, 5.17)
    ..lineTo(11.441, 5.17)
    ..close()
    ..moveTo(14.241, 7.312)
    ..cubicTo(14.599, 8.729, 15.437, 10.787, 15.976, 11.785)
    ..cubicTo(16.262, 12.319, 16.831, 13.444, 17.078, 14.809)
    ..cubicTo(17.234, 14.804, 17.408, 14.827, 17.591, 14.873)
    ..cubicTo(18.237, 13.202, 17.0451, 11.406, 16.5021, 10.907)
    ..cubicTo(16.2821, 10.707, 16.27, 10.572, 16.379, 10.572)
    ..cubicTo(16.969, 11.106, 17.744, 12.144, 18.025, 13.329)
    ..cubicTo(18.155, 13.864, 18.185, 14.433, 18.046, 14.999)
    ..cubicTo(18.113, 15.027, 18.181, 15.059, 18.251, 15.066)
    ..cubicTo(19.283, 15.6, 19.6641, 16.004, 19.4811, 16.603)
    ..lineTo(19.4811, 16.56)
    ..cubicTo(19.4211, 16.557, 19.3611, 16.56, 19.3011, 16.56)
    ..lineTo(19.285, 16.56)
    ..cubicTo(19.436, 16.093, 19.103, 15.735, 18.22, 15.336)
    ..cubicTo(17.305, 14.936, 16.5741, 15, 16.4501, 15.801)
    ..cubicTo(16.4421, 15.844, 16.437, 15.867, 16.432, 15.936)
    ..cubicTo(16.364, 15.959, 16.293, 15.989, 16.223, 16)
    ..cubicTo(15.793, 16.268, 15.561, 16.669, 15.43, 17.187)
    ..cubicTo(15.3, 17.72, 15.26, 18.343, 15.225, 19.056)
    ..lineTo(15.225, 19.059)
    ..cubicTo(15.205, 19.393, 15.055, 19.897, 14.906, 20.409)
    ..cubicTo(13.406, 21.481, 11.326, 21.947, 9.55805, 20.743)
    ..cubicTo(9.4471, 20.5491, 9.31202, 20.37, 9.15605, 20.21)
    ..cubicTo(9.08152, 20.0859, 8.98882, 19.9737, 8.88105, 19.877)
    ..cubicTo(9.06305, 19.877, 9.21905, 19.847, 9.34605, 19.81)
    ..cubicTo(9.48985, 19.7433, 9.60234, 19.6236, 9.66005, 19.476)
    ..cubicTo(9.76805, 19.209, 9.66005, 18.779, 9.31505, 18.313)
    ..cubicTo(8.97005, 17.846, 8.38405, 17.318, 7.52705, 16.792)
    ..cubicTo(6.89705, 16.392, 6.54105, 15.922, 6.37705, 15.396)
    ..cubicTo(6.21205, 14.862, 6.23405, 14.311, 6.36205, 13.751)
    ..cubicTo(6.60705, 12.681, 7.23505, 11.641, 7.63605, 10.988)
    ..cubicTo(7.74305, 10.923, 7.67305, 11.123, 7.22805, 11.962)
    ..cubicTo(6.83205, 12.713, 6.08805, 14.459, 7.10605, 15.816)
    ..cubicTo(7.1445, 14.8259, 7.36378, 13.8512, 7.75305, 12.94)
    ..cubicTo(8.31705, 11.662, 9.49605, 9.436, 9.58905, 7.672)
    ..cubicTo(9.63705, 7.708, 9.80605, 7.807, 9.87805, 7.874)
    ..cubicTo(10.096, 8.007, 10.2581, 8.207, 10.4681, 8.339)
    ..cubicTo(10.678, 8.54, 10.945, 8.674, 11.344, 8.674)
    ..cubicTo(11.383, 8.677, 11.4191, 8.68, 11.4541, 8.68)
    ..cubicTo(11.8661, 8.68, 12.184, 8.546, 12.451, 8.412)
    ..cubicTo(12.741, 8.278, 12.971, 8.078, 13.191, 8.012)
    ..lineTo(13.196, 8.012)
    ..cubicTo(13.663, 7.877, 14.031, 7.61, 14.24, 7.312)
    ..lineTo(14.241, 7.312)
    ..close()
    ..moveTo(16.4261, 16.27)
    ..cubicTo(16.4631, 16.87, 16.7691, 17.515, 17.3081, 17.647)
    ..cubicTo(17.8961, 17.781, 18.7421, 17.314, 19.0991, 16.882)
    ..lineTo(19.31, 16.872)
    ..cubicTo(19.625, 16.865, 19.887, 16.882, 20.157, 17.14)
    ..lineTo(20.16, 17.143)
    ..cubicTo(20.368, 17.342, 20.4651, 17.673, 20.5511, 18.019)
    ..cubicTo(20.6361, 18.419, 20.705, 18.799, 20.96, 19.085)
    ..cubicTo(21.446, 19.612, 21.6051, 19.991, 21.5961, 20.225)
    ..lineTo(21.5991, 20.218)
    ..lineTo(21.5991, 20.236)
    ..lineTo(21.5961, 20.224)
    ..cubicTo(21.5811, 20.486, 21.411, 20.62, 21.098, 20.819)
    ..cubicTo(20.468, 21.22, 19.3521, 21.531, 18.6411, 22.389)
    ..cubicTo(18.0231, 23.126, 17.271, 23.529, 16.605, 23.58)
    ..cubicTo(15.941, 23.633, 15.368, 23.38, 15.031, 22.682)
    ..lineTo(15.026, 22.679)
    ..cubicTo(14.816, 22.279, 14.906, 21.654, 15.082, 20.989)
    ..cubicTo(15.258, 20.321, 15.51, 19.645, 15.545, 19.092)
    ..cubicTo(15.582, 18.378, 15.621, 17.757, 15.74, 17.278)
    ..cubicTo(15.86, 16.813, 16.0481, 16.481, 16.3811, 16.294)
    ..lineTo(16.4261, 16.272)
    ..lineTo(16.4261, 16.27)
    ..close()
    ..moveTo(5.61205, 16.319)
    ..lineTo(5.62205, 16.319)
    ..cubicTo(5.67505, 16.319, 5.72705, 16.324, 5.77905, 16.333)
    ..cubicTo(6.15505, 16.388, 6.48505, 16.666, 6.80205, 17.085)
    ..lineTo(7.71205, 18.749)
    ..lineTo(7.71505, 18.752)
    ..cubicTo(7.95805, 19.285, 8.46905, 19.816, 8.90405, 20.389)
    ..cubicTo(9.33805, 20.987, 9.67405, 21.52, 9.63305, 21.959)
    ..lineTo(9.63305, 21.965)
    ..cubicTo(9.57605, 22.709, 9.15305, 23.113, 8.50805, 23.259)
    ..cubicTo(7.86305, 23.394, 6.98805, 23.261, 6.11305, 22.795)
    ..cubicTo(5.14505, 22.259, 3.99505, 22.326, 3.25605, 22.193)
    ..cubicTo(2.88705, 22.127, 2.64605, 21.993, 2.53305, 21.793)
    ..cubicTo(2.42305, 21.593, 2.42005, 21.191, 2.65605, 20.563)
    ..lineTo(2.65605, 20.559)
    ..lineTo(2.65805, 20.556)
    ..cubicTo(2.77505, 20.222, 2.68805, 19.804, 2.63105, 19.438)
    ..cubicTo(2.57605, 19.037, 2.54805, 18.728, 2.67405, 18.498)
    ..cubicTo(2.83405, 18.164, 3.07005, 18.098, 3.36405, 17.965)
    ..cubicTo(3.65805, 17.83, 4.00405, 17.763, 4.27905, 17.495)
    ..lineTo(4.28105, 17.495)
    ..lineTo(4.28105, 17.493)
    ..cubicTo(4.53705, 17.225, 4.72605, 16.892, 4.94905, 16.655)
    ..cubicTo(5.13905, 16.454, 5.32905, 16.319, 5.61205, 16.319)
    ..lineTo(5.61205, 16.319)
    ..close()
    ..moveTo(12.771, 7.245)
    ..cubicTo(12.336, 7.446, 11.826, 7.78, 11.283, 7.78)
    ..cubicTo(10.741, 7.78, 10.313, 7.513, 10.003, 7.314)
    ..cubicTo(9.84905, 7.18, 9.72305, 7.046, 9.63005, 6.979)
    ..cubicTo(9.46605, 6.845, 9.48605, 6.646, 9.55605, 6.646)
    ..cubicTo(9.66505, 6.662, 9.68505, 6.78, 9.75505, 6.846)
    ..cubicTo(9.85105, 6.912, 9.97005, 7.046, 10.115, 7.179)
    ..cubicTo(10.407, 7.379, 10.795, 7.646, 11.282, 7.646)
    ..cubicTo(11.767, 7.646, 12.335, 7.379, 12.68, 7.18)
    ..cubicTo(12.875, 7.045, 13.125, 6.846, 13.328, 6.713)
    ..cubicTo(13.484, 6.577, 13.477, 6.446, 13.607, 6.446)
    ..cubicTo(13.735, 6.462, 13.641, 6.58, 13.46, 6.778)
    ..cubicTo(13.2382, 6.94575, 13.0079, 7.10195, 12.7701, 7.246)
    ..lineTo(12.771, 7.245)
    ..close()
    ..moveTo(11.689, 5.662)
    ..lineTo(11.689, 5.64)
    ..cubicTo(11.683, 5.62, 11.7021, 5.598, 11.7181, 5.59)
    ..cubicTo(11.7921, 5.547, 11.898, 5.563, 11.978, 5.594)
    ..cubicTo(12.041, 5.594, 12.138, 5.661, 12.128, 5.729)
    ..cubicTo(12.122, 5.778, 12.043, 5.795, 11.993, 5.795)
    ..cubicTo(11.938, 5.795, 11.901, 5.752, 11.852, 5.727)
    ..cubicTo(11.8, 5.709, 11.706, 5.719, 11.689, 5.662)
    ..close()
    ..moveTo(11.138, 5.662)
    ..cubicTo(11.118, 5.72, 11.025, 5.711, 10.972, 5.728)
    ..cubicTo(10.925, 5.753, 10.886, 5.796, 10.832, 5.796)
    ..cubicTo(10.782, 5.796, 10.702, 5.776, 10.696, 5.728)
    ..cubicTo(10.686, 5.662, 10.784, 5.595, 10.846, 5.595)
    ..cubicTo(10.926, 5.564, 11.03, 5.548, 11.105, 5.59)
    ..cubicTo(11.124, 5.599, 11.141, 5.62, 11.135, 5.64)
    ..lineTo(11.135, 5.66)
    ..lineTo(11.138, 5.66)
    ..lineTo(11.138, 5.662)
    ..close(),
};
