# Safe Space

<img alt="alt_text" height="200px" src="https://github.com/aashishksahu/SafeSpace/blob/8431affcc3a5c5a5ac65f072638aef6f390a79b3/fastlane/metadata/android/en-US/images/featureGraphic.png" />

![Release](https://img.shields.io/github/v/release/aashishksahu/SafeSpace.svg?logo=github)
![License](https://img.shields.io/github/license/aashishksahu/SafeSpace.svg)
![Downloads](https://img.shields.io/github/downloads/aashishksahu/SafeSpace/total?labelColor=%23102C57&color=%23F8F0E5)

<p float="left">
  <img width="200px" src="https://github.com/aashishksahu/SafeSpace/blob/master/fastlane/metadata/android/en-US/images/phoneScreenshots/1.png" alt="phoneScreenshots/1.png" />
  <img width="200px" src="https://github.com/aashishksahu/SafeSpace/blob/master/fastlane/metadata/android/en-US/images/phoneScreenshots/2.png" alt="phoneScreenshots/2.png" />
  <img width="200px" src="https://github.com/aashishksahu/SafeSpace/blob/master/fastlane/metadata/android/en-US/images/phoneScreenshots/3.png" alt="phoneScreenshots/3.png" />
  <img width="200px" src="https://github.com/aashishksahu/SafeSpace/blob/master/fastlane/metadata/android/en-US/images/phoneScreenshots/4.png" alt="phoneScreenshots/4.png" />
  <img width="200px" src="https://github.com/aashishksahu/SafeSpace/blob/master/fastlane/metadata/android/en-US/images/phoneScreenshots/5.png" alt="phoneScreenshots/5.png" />
</p>

## Installation

Download the APK from [here](https://github.com/aashishksahu/SafeSpace/releases)

[<img alt="F-Droid" width="200px" src="https://user-content.gitlab-static.net/0cdd89e5cc347206465251782615ab91f99a542d/68747470733a2f2f6664726f69642e6769746c61622e696f2f617274776f726b2f62616467652f6765742d69742d6f6e2e706e67" />](https://f-droid.org/en/packages/org.privacymatters.safespace/)
[<img alt="OpenAPK" width="200px" src="https://www.openapk.net/images/openapk-badge.png" />](https://www.openapk.net/safe-space/org.privacymatters.safespace/)
[<img alt="Android Freeware" width="200px" src="https://www.androidfreeware.net/images/androidfreeware-badge.png" />](https://www.androidfreeware.net/download-safe-space-apk.html)

## Disclaimer

This app uses the app-specific internal storage to store files, this location is already encrypted
by the android system and isn't available to other apps. Safe space app is provided "as is", without
any warranty of any kind. It shouldn't be considered as an absolute safe way to store files. The
purpose of this app is to create a separate space for valuable and important files for an average
user and must not be considered safe if you are a high-profile target for hackers, crime syndicates,
government agencies and other such organizations. I recommend investing in a lightweight laptop with
more reliable methods of information protection such as Tails OS and VeraCrypt (This is not an
endorsement, just a suggestion). It is your sole responsibility what you store in this app.

## Contributions and New Features

SafeSpace has seen a good amount of growth in the last two years, I am truly grateful for that, however, due to time constraints and responsibilites in life and work, I am pausing development of new features. This means that the app will not be getting any new features by me, however, if you wish to contribute new features, you're most welcome, I'd be very happy to merge your PR. Also, This does **NOT** mean that the app is out of support. I will provide bug fixes as soon as possible and will be active in discussions.

## Privacy Policy

This app doesn't collect or send any telemetry data to any server, the documents and text files you
store stay on your device and cannot be recovered by me in case the device is reset, or the app is
uninstalled.
Whatever happens on your phone stays on your phone (for Safe space app).

## Donations and matters of the green paper 🤑🤑🤑

I've been getting emails from Paypal sending me money, since I have never used Paypal (not very
popular in my country), I thought it was a scam. It is only recently (Dec 2023) that I realised that
users of my app were sending me money (Thank you for that btw!!).
Currently I am not accepting any monetary contributions as this app is not incurring any expenses
apart from a weekend or two of coding. Also, this app is my tiny contribution towards combating the
reign of big tech and their malicious ways of business and I want everyone to use the full version
of it without any paywalls.

If you'd like to show some love then please contribute by sharing it with your people and also with
your friends who code so that the app can be maintained for long term and improvements and features
keep coming. Thank you very much for using my app :)

## FAQ

#### What is Safe Space?

Safe space is an app that creates a separate place on your android device to store valuable files.
This storage location is not visible to other apps and is encrypted by the system by default.

Features:

* Store files in a secure storage location that is not visible to other apps and is secured by
  device encryption and Biometric + app PIN authentication (Uses Android KeyStore and Encrypted
  Shared
  Preferences). [More info here](https://developer.android.com/training/data-storage/app-specific)
* Click Pictures and shoot videos within the app
* Open Images, Audio, Video, PDF documents and plain text documents
* Create simple text notes without leaving the app
* Dark and light mode
* ability to copy and move files
* Import from and export files to external storage without storage permissions
* Completely offline with no telemetry and data collection

#### Who is this app for?

This app is for anyone who wants to store important files on their android phone and are not an
active target of high-profile adversaries such as the government or organized crime syndicates and
similar adversaries.

#### Why should I use this app, isn't android pretty "secure" these days?

Storing files on android is a mess, you can see everything in a file manager app (which makes sense)
but so can the apps installed on your phone. A lot of apps still require "All files access"
permission just to function (which is dangerous in my opinion), and most people don't think twice
before allowing this permission. Even if you haven't allowed this permission, most apps require
audio, video and media permissions which again can access most files if they are not honest about
the MIME types in their app's design.

In simple terms, most apps have file access permissions that are often not required for that app to
function (e.g. - MS Office apps) and can actually read sensitive information from your files (e.g. -
Aadhaar number, PAN number etc.). These apps may not necessarily access information beyond what is
required but they have the possibility to do so, which means, that you and your privacy are at the
mercy of such app developers.

#### Has there ever been a security audit?

There hasn't been a security audit yet but the app doesn't use any non-standard ways of security,
this app uses device encryption and uses system biometric authentication along with app pin as
security measures.
If you are a security researcher, it would be great if you can provide insights on my app.

#### Why should I use this app, XYZ app is better?

I respect your choice.

Still... maybe take a look at [this.](https://github.com/aashishksahu/SafeSpace/issues/8)

#### Who am I and why should you trust me?

I am a full-time SAP technical consultant from India and developing this app was a hobby project
which came into existence mostly because there's no good and reliable way of storing files on
android devices. Also, you don't have to trust me, the code is open source, so you can take a look
and I would be very happy if you choose to contribute. Besides that this app doesn't have internet
permissions and does not use any google play services or firebase or 3rd-party analytics and
telemetry services. Again don't trust me, just check the code :)

## Contact Me

frm.backtrack881@passinbox.com

## License

[GNU General Public License v3.0](https://github.com/aashishksahu/SafeSpace/blob/master/LICENSE.md)
