# Messages

Messages is an open source replacement to the [stock messaging app](https://github.com/android/platform_packages_apps_mms) on Android. It is a continuation of [QKSMS](https://github.com/moezbhatti/qksms).

## Features
- Intuitive UI
- Scheduled Messages
- Message Backup
- Message Blocking and Archiving
- Voice Messages
- Attachments of any type of file
- Message Sorting
- Delayed Sending
- Automatic OTP Detection

## Download

Messages is available to download from the official [github releases page](https://github.com/danascape/Messages/releases).

<a href="https://f-droid.org/repository/browse/?fdid=org.prauga.messages"><img src="https://f-droid.org/badge/get-it-on.png" alt="Get it on F-Droid" height="100"></a>
<a href="https://apps.obtainium.imranr.dev/redirect?r=obtainium://app/{%22id%22:%22org.prauga.messages%22,%22url%22:%22https://github.com/danascape/Messages%22,%22author%22:%22danascape%22,%22name%22:%22Messages%22,%22additionalSettings%22:%22{\%22apkFilterRegEx\%22:\%22release\%22,\%22invertAPKFilter\%22:false,\%22about\%22:\%22Messages%20is%20an%20open%20source%20replacement%20for%20the%20stock%20messaging%20app%20on%20Android.%20It%20is%20a%20continuation%20of%20QUIK.\%22}%22}"><img src="https://raw.githubusercontent.com/ImranR98/Obtainium/b1c8ac6f2ab08497189721a788a5763e28ff64cd/assets/graphics/badge_obtainium.png" alt="Get it on Obtainium" height="100"></a>
<a href="https://github.com/danascape/Messages/releases">
<img src="https://user-images.githubusercontent.com/69304392/148696068-0cfea65d-b18f-4685-82b5-329a330b1c0d.png"
alt="Download from GitHub releases" height="100" /></a>

## Chat
You can chat with the community over at [@Pvot_OS:telegram](https://t.me/pvot_os)

## How This App Differs from QKSMS and QUIK

This project is built on original fork from QKSMS and QUIK, but it takes a different directions in several areas.

- **Opinionated UX choices:** Instead of offering a large set of themes or layouts, the app prioritizes a single, consistent visual style to keep navigation predictable and distraction-free.
- **Reduced dependency footprint:** Compared to QKSMS’s extensive use of libraries for animations and theming, this project aims to keep external dependencies to a minimum for better control and easier maintenance.
- **Selective feature set:** Rather than replicating the full feature set of QKSMS (e.g., extensive theme packs) or QUIK's rapid-action gestures, this app includes only the features necessary for a streamlined workflow.

### Project Goals
- Provide a messaging experience that stays fast over time.
- Keep the codebase easy to understand and updated with latest Android trends.
- Offer a consistent UI focused on clarity rather than personalization or speed tricks.

This project is not intended as a clone or competitor to QKSMS or QUIK. Instead, it explores a different path for designing an SMS app with minimalism and maintainability at its core.

## Reporting bugs

A great bug report contains a description of the problem and steps to reproduce the problem. We need to know what we're looking for and where to look for it.

When reporting a bug, please make sure to provide the following information:
- Steps to reproduce the issue
- Messages version
- Device / OS information

## Contributing
Contributions welcome! Please see the [contributing guidelines](/CONTRIBUTING.md) for details.

## Translations
If you'd like to add translations to QUIK, please join the project on [Weblate](https://hosted.weblate.org/engage/pvot-messages/)! Translations that are committed directly to source files will not be accepted. For more information see the [translation guidelines](/CONTRIBUTING.md#translate).

<a href="https://hosted.weblate.org/engage/pvot-messages/">
<img src="https://hosted.weblate.org/widget/pvot-messages/app-strings/multi-auto.svg" alt="Translation status" />
</a>

## Thank you

A special thank you to Jake ([@klinker41](https://github.com/klinker41)) and Luke Klinker ([@klinker24](https://github.com/klinker24)) for their work on [android-smsmms](https://github.com/klinker41/android-smsmms), which has been an unspeakably large help in implementing MMS into QUIK.

A giant thank you to Moez [moezbhatti](https://github.com/moezbhatti) for creating and maintaining QKSMS, of which QUIK would not exist without.

Continued thank you to [octoshrimpy](https://github.com/octoshrimpy) for developing QUIK.

## Contact

Messages is developed and maintained by [Saalim Quadri](https://github.com/danascape).

---

## Star History

[![Star History Chart](https://api.star-history.com/svg?repos=danascape/Messages&type=date&legend=top-left)](https://www.star-history.com/#danascape/Messages&type=date&legend=top-left)

---

## License

Messages is released under the **The GNU General Public License v3.0 (GPLv3)**, which can be found in the [LICENSE](LICENSE) file in the root of this project.
