package org.pixeldroid.common

import android.os.Bundle
import android.view.MenuItem
import com.mikepenz.aboutlibraries.Libs
import org.pixeldroid.common.databinding.OpenSourceLicenseBinding

/**
 * Displays licenses for all app dependencies. JSON is
 * generated by the plugin https://github.com/cookpad/LicenseToolsPlugin.
 */
class LicenseActivity: ThemedActivity() {

    private lateinit var binding: OpenSourceLicenseBinding

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = OpenSourceLicenseBinding.inflate(layoutInflater)

        setContentView(binding.root)
        setSupportActionBar(binding.topBar)

        supportActionBar?.setDisplayHomeAsUpEnabled(true)

        setupRecyclerView()
    }

    private fun setupRecyclerView() {
        val aboutLibsJson: String = applicationContext.resources.openRawResource(R.raw.aboutlibraries)
            .bufferedReader().use { it.readText() }

        val libs = Libs.Builder()
            .withJson(aboutLibsJson)
            .build()

        val adapter = OpenSourceLicenseAdapter(libs)
        binding.openSourceLicenseRecyclerView.adapter = adapter
    }

    override fun onOptionsItemSelected(item: MenuItem): Boolean {
        return when (item.itemId) {
            android.R.id.home -> {
                // Handle up arrow manually,
                // since "up" doesn't seem to mean much within library activity
                onBackPressedDispatcher.onBackPressed()
                true
            }
            else -> {
                super.onOptionsItemSelected(item)
            }
        }
    }
}