/*
 * Decompiled with CFR 0.152.
 */
package com.tasermonkeys.google.json;

import com.tasermonkeys.google.json.BaseMapTypeAdapter;
import com.tasermonkeys.google.json.JsonDeserializationContext;
import com.tasermonkeys.google.json.JsonElement;
import com.tasermonkeys.google.json.JsonNull;
import com.tasermonkeys.google.json.JsonObject;
import com.tasermonkeys.google.json.JsonParseException;
import com.tasermonkeys.google.json.JsonPrimitive;
import com.tasermonkeys.google.json.JsonSerializationContext;
import com.tasermonkeys.google.json.internal.$Gson$Types;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;

final class MapTypeAdapter
extends BaseMapTypeAdapter {
    MapTypeAdapter() {
    }

    public JsonElement serialize(Map src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject map = new JsonObject();
        Class<?> childGenericType = null;
        if (typeOfSrc instanceof ParameterizedType) {
            Class<?> rawTypeOfSrc = $Gson$Types.getRawType(typeOfSrc);
            childGenericType = $Gson$Types.getMapKeyAndValueTypes(typeOfSrc, rawTypeOfSrc)[1];
        }
        for (Map.Entry entry : src.entrySet()) {
            JsonElement valueElement;
            Object value = entry.getValue();
            if (value == null) {
                valueElement = JsonNull.createJsonNull();
            } else {
                Class<?> childType = childGenericType == null ? value.getClass() : childGenericType;
                valueElement = MapTypeAdapter.serialize(context, value, childType);
            }
            map.add(String.valueOf(entry.getKey()), valueElement);
        }
        return map;
    }

    public Map deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        Map<Object, Object> map = MapTypeAdapter.constructMapType(typeOfT, context);
        Type[] keyAndValueTypes = $Gson$Types.getMapKeyAndValueTypes(typeOfT, $Gson$Types.getRawType(typeOfT));
        for (Map.Entry<String, JsonElement> entry : json.getAsJsonObject().entrySet()) {
            Object key = context.deserialize(new JsonPrimitive(entry.getKey()), keyAndValueTypes[0]);
            Object value = context.deserialize(entry.getValue(), keyAndValueTypes[1]);
            map.put(key, value);
        }
        return map;
    }

    public String toString() {
        return MapTypeAdapter.class.getSimpleName();
    }
}

