# Local testing

This folder contains some useful files and configurations to use for testing the OwnTracks client against an endpoint stack running on docker.

## Services

There's a few different configurations here, and running `docker compose up` will try and bring everything up. Specifically:

1. [mosquitto](https://mosquitto.org/), which is listening on ports:
    - 1883 plain-text MQTT
    - 8883 TLS MQTT
    - 8080 plain-text MQTT over WS
    - 8081 TLS MQTT over WS
2. [nginx](https://www.nginx.com/) listening on:
    - 8900 TLS MQTT over WS forwarding to mosquitto on port 8080
    - 8901 TLS HTTPS forwarding to recorder with client certs
3. [caddy](https://caddyserver.com/) listening on:
    - 8910 TLS MQTT over WS forwarding to mosquitto on port 8080
    - 8911 TLS HTTP forwarding to recorder
    - 8912 TLS HTTP with client certs forwarding to recorder
4. [OwnTracks Recorder](https://github.com/owntracks/recorder) listening on:
    - 8083 HTTP Port of the Web UI
5. [OwnTracks Frontend](https://github.com/owntracks/frontend) listening on:
    - 8000 HTTP port of the frontend UI

The credentials for the MQTT server are `test/test`.

## TLS Certs

The TLS certs here are all generated by [mkcert](https://github.com/FiloSottile/mkcert) and the CA keypair is also included. To add more certs signed by this CA, simply set `$CAROOT` to be the pwd, and then `mkcert` will use the `rootCA` keypair here.

- `_wildcard.docker.local.pem` - a certificate for `*.docker.local`, handy for use when running the Android emulator and wanting to connect to TLS services running inside docker. You'll need to DNS map these hostnames to `10.0.2.2`, which is the address of the local machine accessible from the Android emulator.
- `test-client.p12` - a client certificate in `pkcs12` format. The password is `changeit`.
