import { ResolveOptions } from 'enhanced-resolve';
export declare const globSync: (patterns: string | readonly string[], options?: import("globby").Options | undefined) => string[];
export declare const defaultConditionNames: string[];
/**
 * `.mts`, `.cts`, `.d.mts`, `.d.cts`, `.mjs`, `.cjs` are not included because `.cjs` and `.mjs` must be used explicitly
 */
export declare const defaultExtensions: string[];
export declare const defaultExtensionAlias: {
    '.js': string[];
    '.jsx': string[];
    '.cjs': string[];
    '.mjs': string[];
};
export declare const defaultMainFields: string[];
export declare const interfaceVersion = 2;
export interface TsResolverOptions extends Omit<ResolveOptions, 'fileSystem' | 'useSyncFileSystemCalls'> {
    alwaysTryTypes?: boolean;
    project?: string[] | string;
    extensions?: string[];
}
/**
 * @param source the module to resolve; i.e './some-module'
 * @param file the importing file's full path; i.e. '/usr/local/bin/file.js'
 * @param options
 */
export declare function resolve(source: string, file: string, options?: TsResolverOptions | null): {
    found: boolean;
    path?: string | null;
};
