"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MessageStream = void 0;
const utils_1 = require("./utils");
const events_1 = require("events");
class MessageStream extends events_1.EventEmitter {
    constructor(referer, __socket, __context) {
        super();
        this.referer = referer;
        this.__socket = __socket;
        this.__context = __context;
        this.__stream = new utils_1.SSEStream();
        this.close = () => {
            this.__context.req.removeListener('error', this.close);
            this.__context.req.removeListener('close', this.close);
            this.__context.req.removeListener('finish', this.close);
            this.__stream.end();
            this.__socket.end();
            this.emit('closed');
        };
    }
    open() {
        this.__socket.setTimeout(0);
        this.__socket.setNoDelay(true);
        this.__socket.setKeepAlive(true);
        this.__context.type = 'text/event-stream; charset=utf-8';
        this.__context.set('Cache-Control', 'no-cache, no-transform');
        if (this.__context.protocol === 'http') {
            // Connection cannot/does not need to be set when on HTTP2
            this.__context.set('Connection', 'keep-alive');
        }
        this.__context.body = this.__stream;
        this.__context.req.setMaxListeners(100);
        this.__context.req.addListener('error', this.close);
        this.__context.req.addListener('close', this.close);
        this.__context.req.addListener('finish', this.close);
        this.__stream.sendMessage('channel-opened');
    }
    sendMessage(name, data) {
        this.__stream.sendMessage(name, data);
    }
}
exports.MessageStream = MessageStream;
//# sourceMappingURL=MessageStream.js.map