import { FSWatcher } from 'chokidar';
import { Context } from 'koa';
import LRUCache from 'lru-cache';
import { PluginServeMiddlewareConfig } from './middleware/plugin-transform';
interface ResponseBodyCache {
    rootDir: string;
    fileExtensions: string[];
}
interface CacheEntry {
    body: string;
    headers: Record<string, string>;
    filePath: string;
    lastModified: number;
}
interface CacheConfig {
    cache: LRUCache<string, CacheEntry>;
    cacheKey: string;
    cacheKeysForFilePaths: Map<String, String>;
    context: Context;
    cfg: PluginServeMiddlewareConfig;
}
export declare function createResponseBodyCache(cfg: ResponseBodyCache, fileWatcher: FSWatcher): {
    cache: LRUCache<string, CacheEntry>;
    cacheKeysForFilePaths: Map<any, any>;
};
export declare function tryServeFromCache(cache: LRUCache<string, CacheEntry>, context: Context): Promise<{
    cacheKey: string;
    context: Context;
    cached: boolean;
    cachedBody: string;
}>;
export declare function addToCache(config: CacheConfig): Promise<void>;
export {};
