import { Middleware } from 'koa';
interface ResponseTransformerArgs {
    url: string;
    headers: Record<string, string>;
    status: number;
    contentType: string;
    body: string;
}
interface ResponseTransformerReturnValue {
    body?: string;
    contentType?: string;
}
export declare type ResponseTransformer = (args: ResponseTransformerArgs) => ResponseTransformerReturnValue | null | Promise<ResponseTransformerReturnValue | null>;
interface ResponseTransformMiddlewareConfig {
    responseTransformers: ResponseTransformer[];
}
export declare function createResponseTransformMiddleware(config: ResponseTransformMiddlewareConfig): Middleware;
export {};
