"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createMessageChannelMiddleware = void 0;
const tslib_1 = require("tslib");
const utils_1 = require("../utils/utils");
const constants_1 = require("../constants");
const message_channel_1 = tslib_1.__importDefault(require("../browser-scripts/message-channel"));
/**
 * Injects message channel script to index.html
 */
async function injectMessageChannelScript(ctx) {
    try {
        const bodyString = await utils_1.getBodyAsString(ctx);
        const reloadInjected = bodyString.replace('</body>', message_channel_1.default);
        ctx.body = reloadInjected;
    }
    catch (error) {
        if (error instanceof utils_1.RequestCancelledError) {
            return;
        }
        throw error;
    }
}
/**
 * Creates a message channel middleware, which injects a scripts which sets up a
 * server-sent-event connection with the server. This connection can trigger browser
 * reloads or log error messages.
 *
 * @param {MessageChannelMiddlewareConfig} cfg
 */
function createMessageChannelMiddleware(cfg) {
    return async function messageChannelMiddleware(ctx, next) {
        if (ctx.url === constants_1.messageChannelEndpoint) {
            cfg.messageChannel.registerListener(ctx);
            return;
        }
        await next();
        if (!ctx.response.is('html')) {
            return;
        }
        await injectMessageChannelScript(ctx);
    };
}
exports.createMessageChannelMiddleware = createMessageChannelMiddleware;
//# sourceMappingURL=message-channel.js.map