/// <reference types="emscripten" />
import type { LibzipEmscriptenModule } from './emscripten';
export type Libzip = ReturnType<typeof makeInterface>;
export declare enum Errors {
    ZIP_ER_OK = 0,
    ZIP_ER_MULTIDISK = 1,
    ZIP_ER_RENAME = 2,
    ZIP_ER_CLOSE = 3,
    ZIP_ER_SEEK = 4,
    ZIP_ER_READ = 5,
    ZIP_ER_WRITE = 6,
    ZIP_ER_CRC = 7,
    ZIP_ER_ZIPCLOSED = 8,
    ZIP_ER_NOENT = 9,
    ZIP_ER_EXISTS = 10,
    ZIP_ER_OPEN = 11,
    ZIP_ER_TMPOPEN = 12,
    ZIP_ER_ZLIB = 13,
    ZIP_ER_MEMORY = 14,
    ZIP_ER_CHANGED = 15,
    ZIP_ER_COMPNOTSUPP = 16,
    ZIP_ER_EOF = 17,
    ZIP_ER_INVAL = 18,
    ZIP_ER_NOZIP = 19,
    ZIP_ER_INTERNAL = 20,
    ZIP_ER_INCONS = 21,
    ZIP_ER_REMOVE = 22,
    ZIP_ER_DELETED = 23,
    ZIP_ER_ENCRNOTSUPP = 24,
    ZIP_ER_RDONLY = 25,
    ZIP_ER_NOPASSWD = 26,
    ZIP_ER_WRONGPASSWD = 27,
    ZIP_ER_OPNOTSUPP = 28,
    ZIP_ER_INUSE = 29,
    ZIP_ER_TELL = 30,
    ZIP_ER_COMPRESSED_DATA = 31
}
export declare const makeInterface: (libzip: LibzipEmscriptenModule) => {
    readonly HEAP8: Int8Array;
    readonly HEAPU8: Uint8Array;
    readonly errors: typeof Errors;
    readonly SEEK_SET: 0;
    readonly SEEK_CUR: 1;
    readonly SEEK_END: 2;
    readonly ZIP_CHECKCONS: 4;
    readonly ZIP_CREATE: 1;
    readonly ZIP_EXCL: 2;
    readonly ZIP_TRUNCATE: 8;
    readonly ZIP_RDONLY: 16;
    readonly ZIP_FL_OVERWRITE: 8192;
    readonly ZIP_FL_COMPRESSED: 4;
    readonly ZIP_OPSYS_DOS: 0;
    readonly ZIP_OPSYS_AMIGA: 1;
    readonly ZIP_OPSYS_OPENVMS: 2;
    readonly ZIP_OPSYS_UNIX: 3;
    readonly ZIP_OPSYS_VM_CMS: 4;
    readonly ZIP_OPSYS_ATARI_ST: 5;
    readonly ZIP_OPSYS_OS_2: 6;
    readonly ZIP_OPSYS_MACINTOSH: 7;
    readonly ZIP_OPSYS_Z_SYSTEM: 8;
    readonly ZIP_OPSYS_CPM: 9;
    readonly ZIP_OPSYS_WINDOWS_NTFS: 10;
    readonly ZIP_OPSYS_MVS: 11;
    readonly ZIP_OPSYS_VSE: 12;
    readonly ZIP_OPSYS_ACORN_RISC: 13;
    readonly ZIP_OPSYS_VFAT: 14;
    readonly ZIP_OPSYS_ALTERNATE_MVS: 15;
    readonly ZIP_OPSYS_BEOS: 16;
    readonly ZIP_OPSYS_TANDEM: 17;
    readonly ZIP_OPSYS_OS_400: 18;
    readonly ZIP_OPSYS_OS_X: 19;
    readonly ZIP_CM_DEFAULT: -1;
    readonly ZIP_CM_STORE: 0;
    readonly ZIP_CM_DEFLATE: 8;
    readonly uint08S: number;
    readonly uint16S: number;
    readonly uint32S: number;
    readonly uint64S: number;
    readonly malloc: (size: number) => number;
    readonly free: (ptr: number) => void;
    readonly getValue: typeof getValue;
    readonly open: (arg_0: string, arg_1: number, arg_2: number) => number;
    readonly openFromSource: (arg_0: number, arg_1: number, arg_2: number) => number;
    readonly close: (arg_0: number) => number;
    readonly discard: (arg_0: number) => null;
    readonly getError: (arg_0: number) => number;
    readonly getName: (arg_0: number, arg_1: number, arg_2: number) => string;
    readonly getNumEntries: (arg_0: number, arg_1: number) => number;
    readonly delete: (arg_0: number, arg_1: number) => number;
    readonly stat: (arg_0: number, arg_1: string, arg_2: number, arg_3: number) => number;
    readonly statIndex: (arg_0: number, arg_1: number, arg_2: number, arg_3: number, arg_4: number) => number;
    readonly fopen: (arg_0: number, arg_1: string, arg_2: number) => number;
    readonly fopenIndex: (arg_0: number, arg_1: number, arg_2: number, arg_3: number) => number;
    readonly fread: (arg_0: number, arg_1: number, arg_2: number, arg_3: number) => number;
    readonly fclose: (arg_0: number) => number;
    readonly dir: {
        readonly add: (arg_0: number, arg_1: string) => number;
    };
    readonly file: {
        readonly add: (arg_0: number, arg_1: string, arg_2: number, arg_3: number) => number;
        readonly getError: (arg_0: number) => number;
        readonly getExternalAttributes: (arg_0: number, arg_1: number, arg_2: number, arg_3: number, arg_4: number, arg_5: number) => number;
        readonly setExternalAttributes: (arg_0: number, arg_1: number, arg_2: number, arg_3: number, arg_4: number, arg_5: number) => number;
        readonly setMtime: (arg_0: number, arg_1: number, arg_2: number, arg_3: number, arg_4: number) => number;
        readonly setCompression: (arg_0: number, arg_1: number, arg_2: number, arg_3: number, arg_4: number) => number;
    };
    readonly ext: {
        readonly countSymlinks: (arg_0: number) => number;
    };
    readonly error: {
        readonly initWithCode: (arg_0: number, arg_1: number) => null;
        readonly strerror: (arg_0: number) => string;
    };
    readonly name: {
        readonly locate: (arg_0: number, arg_1: string, arg_2: number) => number;
    };
    readonly source: {
        readonly fromUnattachedBuffer: (arg_0: number, arg_1: number, arg_2: number, arg_3: number, arg_4: number) => number;
        readonly fromBuffer: (arg_0: number, arg_1: number, arg_2: number, arg_3: number, arg_4: number) => number;
        readonly free: (arg_0: number) => null;
        readonly keep: (arg_0: number) => null;
        readonly open: (arg_0: number) => number;
        readonly close: (arg_0: number) => number;
        readonly seek: (arg_0: number, arg_1: number, arg_2: number, arg_3: number) => number;
        readonly tell: (arg_0: number) => number;
        readonly read: (arg_0: number, arg_1: number, arg_2: number) => number;
        readonly error: (arg_0: number) => number;
        readonly setMtime: (arg_0: number, arg_1: number) => number;
    };
    readonly struct: {
        readonly stat: () => number;
        readonly statS: () => number;
        readonly statName: (arg_0: number) => string;
        readonly statIndex: (arg_0: number) => number;
        readonly statSize: (arg_0: number) => number;
        readonly statCompSize: (arg_0: number) => number;
        readonly statCompMethod: (arg_0: number) => number;
        readonly statMtime: (arg_0: number) => number;
        readonly statCrc: (arg_0: number) => number;
        readonly error: () => number;
        readonly errorS: () => number;
        readonly errorCodeZip: (arg_0: number) => number;
    };
};
