import { Context, ServerStartParams } from '@web/dev-server-core';
import { TestRunnerCoreConfig } from '../../../config/TestRunnerCoreConfig.js';
import { TestSessionManager } from '../../../test-session/TestSessionManager.js';
import { TestRunnerPlugin } from '../../TestRunnerPlugin.js';
import { TestSession } from '../../../test-session/TestSession.js';
import { TestRunner } from '../../../runner/TestRunner.js';
import { DebugTestSession } from '../../../test-session/DebugTestSession.js';
interface SessionMessage extends Record<string, unknown> {
    sessionId: string;
    testFile: string;
}
declare class TestRunnerApiPlugin implements TestRunnerPlugin {
    name: string;
    injectWebSocket: boolean;
    private config;
    private plugins;
    private testRunner;
    private sessions;
    private sourceMapFunction;
    private mapBrowserUrl;
    /** key: session id, value: browser url */
    private testSessionUrls;
    constructor(config: TestRunnerCoreConfig, testRunner: TestRunner, sessions: TestSessionManager, plugins: TestRunnerPlugin[]);
    getSession(sessionId: string): TestSession | DebugTestSession;
    parseSessionMessage(data: Record<string, unknown>): {
        message: SessionMessage;
        session: TestSession | DebugTestSession;
    };
    transform(context: Context): Promise<void>;
    serverStart({ webSockets }: ServerStartParams): void;
    serve(context: Context): Promise<{
        body: string;
        type: string;
        status?: undefined;
    } | {
        body: string;
        type: string;
        status: number;
    } | undefined>;
    private _onSessionStarted;
    private _onSessionFinished;
    private _onCommand;
    /**
     * Waits for web socket to become disconnected, and checks after disconnect if it was expected
     * or if some error occurred.
     */
    private _waitForDisconnect;
    private _onMultiInitialized;
    private _setSessionFailed;
}
export declare function testRunnerApiPlugin(config: TestRunnerCoreConfig, testRunner: TestRunner, sessions: TestSessionManager, plugins: TestRunnerPlugin[]): TestRunnerApiPlugin;
export {};
//# sourceMappingURL=testRunnerApiPlugin.d.ts.map