import { EventEmitter } from '../../utils/EventEmitter.js';
interface EventMap {
    input: string;
}
export declare class DynamicTerminal extends EventEmitter<EventMap> {
    private originalFunctions;
    private previousDynamic;
    private started;
    private bufferedConsole;
    private pendingConsoleFlush;
    isInteractive: boolean;
    start(): void;
    private onStdInData;
    observeDirectInput(): void;
    observeConfirmedInput(): void;
    stop(): void;
    clear(): void;
    logStatic(entriesOrEntry: string | string[]): void;
    logPendingUserInput(string: string): void;
    logDynamic(entriesOrEntry: string | string[]): void;
    /**
     * Intercepts console output, piping all output to a buffered console instead.
     * Console messages are piped to the regular console at intervals. This is necessary
     * because when logging regular console messages the progress bar needs to be removes
     * and added back at the bottom. The time between this must be as minimal as possible.
     * Regular console logging can take a noticeable amount of time to compute object highlighting
     * and formatting. This causes the progress bar to flicker. Pre-computing the formatting
     * prevents this.
     */
    private interceptConsoleOutput;
    private flushConsoleOutput;
    private relogDynamic;
}
export {};
//# sourceMappingURL=DynamicTerminal.d.ts.map