# Installation
> `npm install --save @types/koa-static`

# Summary
This package contains type definitions for koa-static (https://github.com/koajs/static).

# Details
Files were exported from https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/koa-static.
## [index.d.ts](https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/koa-static/index.d.ts)
````ts
// Type definitions for koa-static 4.0
// Project: https://github.com/koajs/static
// Definitions by: Jerry Chin <https://github.com/hellopao>
//                 Tomek Łaziuk <https://github.com/tlaziuk>
// Definitions: https://github.com/DefinitelyTyped/DefinitelyTyped
// TypeScript Version: 2.3

/* =================== USAGE ===================

    import serve = require("koa-static");
    var Koa = require('koa');

    var app = new Koa();
    app.use(serve("."));

 =============================================== */

import { Middleware } from "koa";

import { SendOptions } from "koa-send";

declare function serve(root: string, opts?: serve.Options): Middleware<{}>;

declare namespace serve {
    interface Options extends SendOptions {
        /** If true, serves after return next(), allowing any downstream middleware to respond first. */
        defer?: boolean | undefined;
    }
}

export = serve;

````

### Additional Details
 * Last updated: Tue, 06 Jul 2021 22:02:38 GMT
 * Dependencies: [@types/koa](https://npmjs.com/package/@types/koa), [@types/koa-send](https://npmjs.com/package/@types/koa-send)
 * Global values: none

# Credits
These definitions were written by [Jerry Chin](https://github.com/hellopao), and [Tomek Łaziuk](https://github.com/tlaziuk).
