import { getCustomElements, isValidComponent, isValidMetaData } from './chunk-GKNNPQCW.mjs';
import { SourceType, enhanceArgTypes, SNIPPET_RENDERED } from 'storybook/internal/docs-tools';
import invariant from 'tiny-invariant';
import { logger } from 'storybook/internal/client-logger';
import { render } from 'lit';
import { useEffect, addons } from 'storybook/internal/preview-api';

function mapItem(item,category){let type;switch(category){case"attributes":case"properties":type={name:item.type?.text||item.type};break;case"slots":type={name:"string"};break;default:type={name:"void"};break}return {name:item.name,required:!1,description:item.description,type,table:{category,type:{summary:item.type?.text||item.type},defaultValue:{summary:item.default!==void 0?item.default:item.defaultValue}}}}function mapEvent(item){let name=item.name.replace(/(-|_|:|\.|\s)+(.)?/g,(_match,_separator,chr)=>chr?chr.toUpperCase():"").replace(/^([A-Z])/,match=>match.toLowerCase());return name=`on${name.charAt(0).toUpperCase()+name.substr(1)}`,[{name,action:{name:item.name},table:{disable:!0}},mapItem(item,"events")]}function mapData(data,category){return data&&data.filter(item=>item&&item.name).reduce((acc,item)=>{if(item.kind==="method")return acc;switch(category){case"events":mapEvent(item).forEach(argType=>{invariant(argType.name,`${argType} should have a name property.`),acc[argType.name]=argType;});break;default:acc[item.name]=mapItem(item,category);break}return acc},{})}var getMetaDataExperimental=(tagName,customElements)=>{if(!isValidComponent(tagName)||!isValidMetaData(customElements))return null;let metaData=customElements.tags.find(tag=>tag.name.toUpperCase()===tagName.toUpperCase());return metaData||logger.warn(`Component not found in custom-elements.json: ${tagName}`),metaData},getMetaDataV1=(tagName,customElements)=>{if(!isValidComponent(tagName)||!isValidMetaData(customElements))return null;let metadata;return customElements?.modules?.forEach(_module=>{_module?.declarations?.forEach(declaration=>{declaration.tagName===tagName&&(metadata=declaration);});}),metadata||logger.warn(`Component not found in custom-elements.json: ${tagName}`),metadata},getMetaData=(tagName,manifest)=>manifest?.version==="experimental"?getMetaDataExperimental(tagName,manifest):getMetaDataV1(tagName,manifest),extractArgTypesFromElements=(tagName,customElements)=>{let metaData=getMetaData(tagName,customElements);return metaData&&{...mapData(metaData.members??[],"properties"),...mapData(metaData.properties??[],"properties"),...mapData(metaData.attributes??[],"attributes"),...mapData(metaData.events??[],"events"),...mapData(metaData.slots??[],"slots"),...mapData(metaData.cssProperties??[],"css custom properties"),...mapData(metaData.cssParts??[],"css shadow parts")}},extractArgTypes=tagName=>{let cem=getCustomElements();return extractArgTypesFromElements(tagName,cem)},extractComponentDescription=tagName=>{let metaData=getMetaData(tagName,getCustomElements());return metaData&&metaData.description};var LIT_EXPRESSION_COMMENTS=/<!--\?lit\$[0-9]+\$-->|<!--\??-->/g;function skipSourceRender(context){let sourceParams=context?.parameters.docs?.source,isArgsStory=context?.parameters.__isArgsStory;return sourceParams?.type===SourceType.DYNAMIC?!1:!isArgsStory||sourceParams?.code||sourceParams?.type===SourceType.CODE}function sourceDecorator(storyFn,context){let story=storyFn(),renderedForSource=context?.parameters.docs?.source?.excludeDecorators?context.originalStoryFn(context.args,context):story,source;if(useEffect(()=>{let{id,unmappedArgs}=context;source&&addons.getChannel().emit(SNIPPET_RENDERED,{id,source,args:unmappedArgs});}),!skipSourceRender(context)){let container=window.document.createElement("div");renderedForSource instanceof DocumentFragment?render(renderedForSource.cloneNode(!0),container):render(renderedForSource,container),source=container.innerHTML.replace(LIT_EXPRESSION_COMMENTS,"");}return story}var decorators=[sourceDecorator],parameters={docs:{extractArgTypes,extractComponentDescription,story:{inline:!0},source:{type:SourceType.DYNAMIC,language:"html"}}},argTypesEnhancers=[enhanceArgTypes];

export { argTypesEnhancers, decorators, parameters };
