import * as fs2 from 'fs-extra';
import { ensureFile, writeFile } from 'fs-extra';
import express from 'express';
import * as path2 from 'path';
import path2__default, { win32, posix, join, parse, isAbsolute, relative, resolve } from 'path';
import { NoStatsForViteDevError } from 'storybook/internal/server-errors';
import { corePath } from 'storybook/core-path';
import { normalizeStories, getBuilderOptions, resolvePathInStorybookCache, isPreservingSymlinks, getFrameworkName, commonGlobOptions, stringifyEnvs, loadPreviewOrConfigFile, stripAbsNodeModulesPath } from 'storybook/internal/common';
import { globalsNameReferenceMap } from 'storybook/internal/preview/globals';
import { parse as parse$1, init } from 'es-module-lexer';
import MagicString from 'magic-string';
import * as actualFS from 'fs';
import { realpathSync as realpathSync$1, lstatSync, readdir, readdirSync, readlinkSync } from 'fs';
import { fileURLToPath } from 'url';
import { lstat, readdir as readdir$1, readlink, realpath } from 'fs/promises';
import { EventEmitter } from 'events';
import Stream from 'stream';
import { StringDecoder } from 'string_decoder';
import { vite } from '@storybook/csf-plugin';
import { join as join$1 } from 'node:path';
import findCacheDirectory from 'find-cache-dir';
import { logger } from 'storybook/internal/node-logger';
import { dedent } from 'ts-dedent';

var __create=Object.create;var __defProp=Object.defineProperty;var __getOwnPropDesc=Object.getOwnPropertyDescriptor;var __getOwnPropNames=Object.getOwnPropertyNames;var __getProtoOf=Object.getPrototypeOf,__hasOwnProp=Object.prototype.hasOwnProperty;var __require=(x=>typeof require<"u"?require:typeof Proxy<"u"?new Proxy(x,{get:(a,b)=>(typeof require<"u"?require:a)[b]}):x)(function(x){if(typeof require<"u")return require.apply(this,arguments);throw Error('Dynamic require of "'+x+'" is not supported')});var __commonJS=(cb,mod)=>function(){return mod||(0, cb[__getOwnPropNames(cb)[0]])((mod={exports:{}}).exports,mod),mod.exports};var __copyProps=(to,from,except,desc)=>{if(from&&typeof from=="object"||typeof from=="function")for(let key of __getOwnPropNames(from))!__hasOwnProp.call(to,key)&&key!==except&&__defProp(to,key,{get:()=>from[key],enumerable:!(desc=__getOwnPropDesc(from,key))||desc.enumerable});return to};var __toESM=(mod,isNodeMode,target)=>(target=mod!=null?__create(__getProtoOf(mod)):{},__copyProps(isNodeMode||!mod||!mod.__esModule?__defProp(target,"default",{value:mod,enumerable:!0}):target,mod));var require_balanced_match=__commonJS({"../../node_modules/balanced-match/index.js"(exports,module){module.exports=balanced;function balanced(a,b,str){a instanceof RegExp&&(a=maybeMatch(a,str)),b instanceof RegExp&&(b=maybeMatch(b,str));var r=range(a,b,str);return r&&{start:r[0],end:r[1],pre:str.slice(0,r[0]),body:str.slice(r[0]+a.length,r[1]),post:str.slice(r[1]+b.length)}}function maybeMatch(reg,str){var m=str.match(reg);return m?m[0]:null}balanced.range=range;function range(a,b,str){var begs,beg,left,right,result,ai=str.indexOf(a),bi=str.indexOf(b,ai+1),i=ai;if(ai>=0&&bi>0){if(a===b)return [ai,bi];for(begs=[],left=str.length;i>=0&&!result;)i==ai?(begs.push(i),ai=str.indexOf(a,i+1)):begs.length==1?result=[begs.pop(),bi]:(beg=begs.pop(),beg<left&&(left=beg,right=bi),bi=str.indexOf(b,i+1)),i=ai<bi&&ai>=0?ai:bi;begs.length&&(result=[left,right]);}return result}}});var require_brace_expansion=__commonJS({"../../node_modules/brace-expansion/index.js"(exports,module){var balanced=require_balanced_match();module.exports=expandTop;var escSlash="\0SLASH"+Math.random()+"\0",escOpen="\0OPEN"+Math.random()+"\0",escClose="\0CLOSE"+Math.random()+"\0",escComma="\0COMMA"+Math.random()+"\0",escPeriod="\0PERIOD"+Math.random()+"\0";function numeric(str){return parseInt(str,10)==str?parseInt(str,10):str.charCodeAt(0)}function escapeBraces(str){return str.split("\\\\").join(escSlash).split("\\{").join(escOpen).split("\\}").join(escClose).split("\\,").join(escComma).split("\\.").join(escPeriod)}function unescapeBraces(str){return str.split(escSlash).join("\\").split(escOpen).join("{").split(escClose).join("}").split(escComma).join(",").split(escPeriod).join(".")}function parseCommaParts(str){if(!str)return [""];var parts=[],m=balanced("{","}",str);if(!m)return str.split(",");var pre=m.pre,body=m.body,post=m.post,p=pre.split(",");p[p.length-1]+="{"+body+"}";var postParts=parseCommaParts(post);return post.length&&(p[p.length-1]+=postParts.shift(),p.push.apply(p,postParts)),parts.push.apply(parts,p),parts}function expandTop(str){return str?(str.substr(0,2)==="{}"&&(str="\\{\\}"+str.substr(2)),expand2(escapeBraces(str),!0).map(unescapeBraces)):[]}function embrace(str){return "{"+str+"}"}function isPadded(el){return /^-?0\d/.test(el)}function lte(i,y){return i<=y}function gte(i,y){return i>=y}function expand2(str,isTop){var expansions=[],m=balanced("{","}",str);if(!m)return [str];var pre=m.pre,post=m.post.length?expand2(m.post,!1):[""];if(/\$$/.test(m.pre))for(var k=0;k<post.length;k++){var expansion=pre+"{"+m.body+"}"+post[k];expansions.push(expansion);}else {var isNumericSequence=/^-?\d+\.\.-?\d+(?:\.\.-?\d+)?$/.test(m.body),isAlphaSequence=/^[a-zA-Z]\.\.[a-zA-Z](?:\.\.-?\d+)?$/.test(m.body),isSequence=isNumericSequence||isAlphaSequence,isOptions=m.body.indexOf(",")>=0;if(!isSequence&&!isOptions)return m.post.match(/,.*\}/)?(str=m.pre+"{"+m.body+escClose+m.post,expand2(str)):[str];var n;if(isSequence)n=m.body.split(/\.\./);else if(n=parseCommaParts(m.body),n.length===1&&(n=expand2(n[0],!1).map(embrace),n.length===1))return post.map(function(p){return m.pre+n[0]+p});var N;if(isSequence){var x=numeric(n[0]),y=numeric(n[1]),width=Math.max(n[0].length,n[1].length),incr=n.length==3?Math.abs(numeric(n[2])):1,test=lte,reverse=y<x;reverse&&(incr*=-1,test=gte);var pad=n.some(isPadded);N=[];for(var i=x;test(i,y);i+=incr){var c;if(isAlphaSequence)c=String.fromCharCode(i),c==="\\"&&(c="");else if(c=String(i),pad){var need=width-c.length;if(need>0){var z=new Array(need+1).join("0");i<0?c="-"+z+c.slice(1):c=z+c;}}N.push(c);}}else {N=[];for(var j=0;j<n.length;j++)N.push.apply(N,expand2(n[j],!1));}for(var j=0;j<N.length;j++)for(var k=0;k<post.length;k++){var expansion=pre+N[j]+post[k];(!isTop||isSequence||expansion)&&expansions.push(expansion);}}return expansions}}});async function transformIframeHtml(html,options){let{configType,features,presets}=options,build3=await presets.apply("build"),frameworkOptions=await presets.apply("frameworkOptions"),headHtmlSnippet=await presets.apply("previewHead"),bodyHtmlSnippet=await presets.apply("previewBody"),logLevel=await presets.apply("logLevel",void 0),docsOptions=await presets.apply("docs"),tagsOptions=await presets.apply("tags"),coreOptions=await presets.apply("core"),stories=normalizeStories(await options.presets.apply("stories",[],options),{configDir:options.configDir,workingDir:process.cwd()}).map(specifier=>({...specifier,importPathMatcher:specifier.importPathMatcher.source})),otherGlobals={...build3?.test?.disableBlocks?{__STORYBOOK_BLOCKS_EMPTY_MODULE__:{}}:{}};return html.replace("[CONFIG_TYPE HERE]",configType||"").replace("[LOGLEVEL HERE]",logLevel||"").replace("'[FRAMEWORK_OPTIONS HERE]'",JSON.stringify(frameworkOptions)).replace("('OTHER_GLOBLALS HERE');",Object.entries(otherGlobals).map(([k,v])=>`window["${k}"] = ${JSON.stringify(v)};`).join("")).replace("'[CHANNEL_OPTIONS HERE]'",JSON.stringify(coreOptions&&coreOptions.channelOptions?coreOptions.channelOptions:{})).replace("'[FEATURES HERE]'",JSON.stringify(features||{})).replace("'[STORIES HERE]'",JSON.stringify(stories||{})).replace("'[DOCS_OPTIONS HERE]'",JSON.stringify(docsOptions||{})).replace("'[TAGS_OPTIONS HERE]'",JSON.stringify(tagsOptions||{})).replace("<!-- [HEAD HTML SNIPPET HERE] -->",headHtmlSnippet||"").replace("<!-- [BODY HTML SNIPPET HERE] -->",bodyHtmlSnippet||"")}async function injectExportOrderPlugin(){let{createFilter}=await import('vite'),filter2=createFilter([/\.stories\.([tj])sx?$/,/(stories|story).mdx$/]);return {name:"storybook:inject-export-order-plugin",enforce:"post",async transform(code,id){if(!filter2(id))return;let[,exports]=await parse$1(code),exportNames=exports.map(e=>code.substring(e.s,e.e));if(exportNames.includes("__namedExportsOrder"))return;let s=new MagicString(code),orderedExports=exportNames.filter(e=>e!=="default");return s.append(`;export const __namedExportsOrder = ${JSON.stringify(orderedExports)};`),{code:s.toString(),map:s.generateMap({hires:!0,source:id})}}}}async function stripStoryHMRBoundary(){let{createFilter}=await import('vite'),filter2=createFilter(/\.stories\.([tj])sx?$/);return {name:"storybook:strip-hmr-boundary-plugin",enforce:"post",async transform(src,id){if(!filter2(id))return;let s=new MagicString(src);return s.replace(/import\.meta\.hot\.accept\(\);/,""),{code:s.toString(),map:s.generateMap({hires:!0,source:id})}}}}var virtualFileId="/virtual:/@storybook/builder-vite/vite-app.js",virtualStoriesFile="/virtual:/@storybook/builder-vite/storybook-stories.js",virtualPreviewFile="/virtual:/@storybook/builder-vite/preview-entry.js",virtualAddonSetupFile="/virtual:/@storybook/builder-vite/setup-addons.js";function slash(path7){return path7.startsWith("\\\\?\\")?path7:path7.replace(/\\/g,"/")}function processPreviewAnnotation(path7,projectRoot){if(typeof path7=="object")return path7.bare;if(!path7)throw new Error("Could not determine path for previewAnnotation");if(path7.includes("node_modules"))return stripAbsNodeModulesPath(path7);let relativePath=isAbsolute(path7)?slash(relative(projectRoot,path7)):path7;return relativePath.startsWith("./")?slash(relativePath.replace(/^\.\//,"/")):relativePath.startsWith("../")?slash(resolve(projectRoot,relativePath)):slash(`/${relativePath}`)}async function generateModernIframeScriptCode(options,projectRoot){let{presets,configDir}=options,frameworkName=await getFrameworkName(options),previewOrConfigFile=loadPreviewOrConfigFile({configDir}),previewAnnotationURLs=[...await presets.apply("previewAnnotations",[],options),previewOrConfigFile].filter(Boolean).map(path7=>processPreviewAnnotation(path7,projectRoot)),getPreviewAnnotationsFunction=`
  const getProjectAnnotations = async (hmrPreviewAnnotationModules = []) => {
    const configs = await Promise.all([${previewAnnotationURLs.map((previewAnnotation,index)=>`hmrPreviewAnnotationModules.at(${index}) ?? import('${previewAnnotation}')`).join(`,
`)}])
    return composeConfigs(configs);
  }`;return `
  import { composeConfigs, PreviewWeb, ClientApi } from 'storybook/internal/preview-api';
  import '${virtualAddonSetupFile}';
  import { importFn } from '${virtualStoriesFile}';
  
    ${getPreviewAnnotationsFunction}

    window.__STORYBOOK_PREVIEW__ = window.__STORYBOOK_PREVIEW__ || new PreviewWeb(importFn, getProjectAnnotations);
    
    window.__STORYBOOK_STORY_STORE__ = window.__STORYBOOK_STORY_STORE__ || window.__STORYBOOK_PREVIEW__.storyStore;
    
    ${(frameworkName2=>frameworkName2==="@storybook/web-components-vite"?`
      if (import.meta.hot) {
        import.meta.hot.decline();
      }`.trim():`
    if (import.meta.hot) {
      import.meta.hot.accept('${virtualStoriesFile}', (newModule) => {
      // importFn has changed so we need to patch the new one in
      window.__STORYBOOK_PREVIEW__.onStoriesChanged({ importFn: newModule.importFn });
      });

    import.meta.hot.accept(${JSON.stringify(previewAnnotationURLs)}, (previewAnnotationModules) => {
      ${getPreviewAnnotationsFunction}
      // getProjectAnnotations has changed so we need to patch the new one in
      window.__STORYBOOK_PREVIEW__.onGetProjectAnnotationsChanged({ getProjectAnnotations: () => getProjectAnnotations(previewAnnotationModules) });
    });
  }`.trim())(frameworkName)};
    `.trim()}var import_brace_expansion=__toESM(require_brace_expansion(),1);var assertValidPattern=pattern=>{if(typeof pattern!="string")throw new TypeError("invalid pattern");if(pattern.length>65536)throw new TypeError("pattern is too long")};var posixClasses={"[:alnum:]":["\\p{L}\\p{Nl}\\p{Nd}",!0],"[:alpha:]":["\\p{L}\\p{Nl}",!0],"[:ascii:]":["\\x00-\\x7f",!1],"[:blank:]":["\\p{Zs}\\t",!0],"[:cntrl:]":["\\p{Cc}",!0],"[:digit:]":["\\p{Nd}",!0],"[:graph:]":["\\p{Z}\\p{C}",!0,!0],"[:lower:]":["\\p{Ll}",!0],"[:print:]":["\\p{C}",!0],"[:punct:]":["\\p{P}",!0],"[:space:]":["\\p{Z}\\t\\r\\n\\v\\f",!0],"[:upper:]":["\\p{Lu}",!0],"[:word:]":["\\p{L}\\p{Nl}\\p{Nd}\\p{Pc}",!0],"[:xdigit:]":["A-Fa-f0-9",!1]},braceEscape=s=>s.replace(/[[\]\\-]/g,"\\$&"),regexpEscape=s=>s.replace(/[-[\]{}()*+?.,\\^$|#\s]/g,"\\$&"),rangesToString=ranges=>ranges.join(""),parseClass=(glob2,position)=>{let pos=position;if(glob2.charAt(pos)!=="[")throw new Error("not in a brace expression");let ranges=[],negs=[],i=pos+1,sawStart=!1,uflag=!1,escaping=!1,negate=!1,endPos=pos,rangeStart="";WHILE:for(;i<glob2.length;){let c=glob2.charAt(i);if((c==="!"||c==="^")&&i===pos+1){negate=!0,i++;continue}if(c==="]"&&sawStart&&!escaping){endPos=i+1;break}if(sawStart=!0,c==="\\"&&!escaping){escaping=!0,i++;continue}if(c==="["&&!escaping){for(let[cls,[unip,u,neg]]of Object.entries(posixClasses))if(glob2.startsWith(cls,i)){if(rangeStart)return ["$.",!1,glob2.length-pos,!0];i+=cls.length,neg?negs.push(unip):ranges.push(unip),uflag=uflag||u;continue WHILE}}if(escaping=!1,rangeStart){c>rangeStart?ranges.push(braceEscape(rangeStart)+"-"+braceEscape(c)):c===rangeStart&&ranges.push(braceEscape(c)),rangeStart="",i++;continue}if(glob2.startsWith("-]",i+1)){ranges.push(braceEscape(c+"-")),i+=2;continue}if(glob2.startsWith("-",i+1)){rangeStart=c,i+=2;continue}ranges.push(braceEscape(c)),i++;}if(endPos<i)return ["",!1,0,!1];if(!ranges.length&&!negs.length)return ["$.",!1,glob2.length-pos,!0];if(negs.length===0&&ranges.length===1&&/^\\?.$/.test(ranges[0])&&!negate){let r=ranges[0].length===2?ranges[0].slice(-1):ranges[0];return [regexpEscape(r),!1,endPos-pos,!1]}let sranges="["+(negate?"^":"")+rangesToString(ranges)+"]",snegs="["+(negate?"":"^")+rangesToString(negs)+"]";return [ranges.length&&negs.length?"("+sranges+"|"+snegs+")":ranges.length?sranges:snegs,uflag,endPos-pos,!0]};var unescape=(s,{windowsPathsNoEscape=!1}={})=>windowsPathsNoEscape?s.replace(/\[([^\/\\])\]/g,"$1"):s.replace(/((?!\\).|^)\[([^\/\\])\]/g,"$1$2").replace(/\\([^\/])/g,"$1");var types=new Set(["!","?","+","*","@"]),isExtglobType=c=>types.has(c),startNoTraversal="(?!(?:^|/)\\.\\.?(?:$|/))",startNoDot="(?!\\.)",addPatternStart=new Set(["[","."]),justDots=new Set(["..","."]),reSpecials=new Set("().*{}+?[]^$\\!"),regExpEscape=s=>s.replace(/[-[\]{}()*+?.,\\^$|#\s]/g,"\\$&"),qmark="[^/]",star=qmark+"*?",starNoEmpty=qmark+"+?",AST=class _AST{type;#root;#hasMagic;#uflag=!1;#parts=[];#parent;#parentIndex;#negs;#filledNegs=!1;#options;#toString;#emptyExt=!1;constructor(type,parent,options={}){this.type=type,type&&(this.#hasMagic=!0),this.#parent=parent,this.#root=this.#parent?this.#parent.#root:this,this.#options=this.#root===this?options:this.#root.#options,this.#negs=this.#root===this?[]:this.#root.#negs,type==="!"&&!this.#root.#filledNegs&&this.#negs.push(this),this.#parentIndex=this.#parent?this.#parent.#parts.length:0;}get hasMagic(){if(this.#hasMagic!==void 0)return this.#hasMagic;for(let p of this.#parts)if(typeof p!="string"&&(p.type||p.hasMagic))return this.#hasMagic=!0;return this.#hasMagic}toString(){return this.#toString!==void 0?this.#toString:this.type?this.#toString=this.type+"("+this.#parts.map(p=>String(p)).join("|")+")":this.#toString=this.#parts.map(p=>String(p)).join("")}#fillNegs(){if(this!==this.#root)throw new Error("should only call on root");if(this.#filledNegs)return this;this.toString(),this.#filledNegs=!0;let n;for(;n=this.#negs.pop();){if(n.type!=="!")continue;let p=n,pp=p.#parent;for(;pp;){for(let i=p.#parentIndex+1;!pp.type&&i<pp.#parts.length;i++)for(let part of n.#parts){if(typeof part=="string")throw new Error("string part in extglob AST??");part.copyIn(pp.#parts[i]);}p=pp,pp=p.#parent;}}return this}push(...parts){for(let p of parts)if(p!==""){if(typeof p!="string"&&!(p instanceof _AST&&p.#parent===this))throw new Error("invalid part: "+p);this.#parts.push(p);}}toJSON(){let ret=this.type===null?this.#parts.slice().map(p=>typeof p=="string"?p:p.toJSON()):[this.type,...this.#parts.map(p=>p.toJSON())];return this.isStart()&&!this.type&&ret.unshift([]),this.isEnd()&&(this===this.#root||this.#root.#filledNegs&&this.#parent?.type==="!")&&ret.push({}),ret}isStart(){if(this.#root===this)return !0;if(!this.#parent?.isStart())return !1;if(this.#parentIndex===0)return !0;let p=this.#parent;for(let i=0;i<this.#parentIndex;i++){let pp=p.#parts[i];if(!(pp instanceof _AST&&pp.type==="!"))return !1}return !0}isEnd(){if(this.#root===this||this.#parent?.type==="!")return !0;if(!this.#parent?.isEnd())return !1;if(!this.type)return this.#parent?.isEnd();let pl=this.#parent?this.#parent.#parts.length:0;return this.#parentIndex===pl-1}copyIn(part){typeof part=="string"?this.push(part):this.push(part.clone(this));}clone(parent){let c=new _AST(this.type,parent);for(let p of this.#parts)c.copyIn(p);return c}static#parseAST(str,ast,pos,opt){let escaping=!1,inBrace=!1,braceStart=-1,braceNeg=!1;if(ast.type===null){let i2=pos,acc2="";for(;i2<str.length;){let c=str.charAt(i2++);if(escaping||c==="\\"){escaping=!escaping,acc2+=c;continue}if(inBrace){i2===braceStart+1?(c==="^"||c==="!")&&(braceNeg=!0):c==="]"&&!(i2===braceStart+2&&braceNeg)&&(inBrace=!1),acc2+=c;continue}else if(c==="["){inBrace=!0,braceStart=i2,braceNeg=!1,acc2+=c;continue}if(!opt.noext&&isExtglobType(c)&&str.charAt(i2)==="("){ast.push(acc2),acc2="";let ext2=new _AST(c,ast);i2=_AST.#parseAST(str,ext2,i2,opt),ast.push(ext2);continue}acc2+=c;}return ast.push(acc2),i2}let i=pos+1,part=new _AST(null,ast),parts=[],acc="";for(;i<str.length;){let c=str.charAt(i++);if(escaping||c==="\\"){escaping=!escaping,acc+=c;continue}if(inBrace){i===braceStart+1?(c==="^"||c==="!")&&(braceNeg=!0):c==="]"&&!(i===braceStart+2&&braceNeg)&&(inBrace=!1),acc+=c;continue}else if(c==="["){inBrace=!0,braceStart=i,braceNeg=!1,acc+=c;continue}if(isExtglobType(c)&&str.charAt(i)==="("){part.push(acc),acc="";let ext2=new _AST(c,part);part.push(ext2),i=_AST.#parseAST(str,ext2,i,opt);continue}if(c==="|"){part.push(acc),acc="",parts.push(part),part=new _AST(null,ast);continue}if(c===")")return acc===""&&ast.#parts.length===0&&(ast.#emptyExt=!0),part.push(acc),acc="",ast.push(...parts,part),i;acc+=c;}return ast.type=null,ast.#hasMagic=void 0,ast.#parts=[str.substring(pos-1)],i}static fromGlob(pattern,options={}){let ast=new _AST(null,void 0,options);return _AST.#parseAST(pattern,ast,0,options),ast}toMMPattern(){if(this!==this.#root)return this.#root.toMMPattern();let glob2=this.toString(),[re,body,hasMagic2,uflag]=this.toRegExpSource();if(!(hasMagic2||this.#hasMagic||this.#options.nocase&&!this.#options.nocaseMagicOnly&&glob2.toUpperCase()!==glob2.toLowerCase()))return body;let flags=(this.#options.nocase?"i":"")+(uflag?"u":"");return Object.assign(new RegExp(`^${re}$`,flags),{_src:re,_glob:glob2})}toRegExpSource(allowDot){let dot=allowDot??!!this.#options.dot;if(this.#root===this&&this.#fillNegs(),!this.type){let noEmpty=this.isStart()&&this.isEnd(),src=this.#parts.map(p=>{let[re,_,hasMagic2,uflag]=typeof p=="string"?_AST.#parseGlob(p,this.#hasMagic,noEmpty):p.toRegExpSource(allowDot);return this.#hasMagic=this.#hasMagic||hasMagic2,this.#uflag=this.#uflag||uflag,re}).join(""),start3="";if(this.isStart()&&typeof this.#parts[0]=="string"&&!(this.#parts.length===1&&justDots.has(this.#parts[0]))){let aps=addPatternStart,needNoTrav=dot&&aps.has(src.charAt(0))||src.startsWith("\\.")&&aps.has(src.charAt(2))||src.startsWith("\\.\\.")&&aps.has(src.charAt(4)),needNoDot=!dot&&!allowDot&&aps.has(src.charAt(0));start3=needNoTrav?startNoTraversal:needNoDot?startNoDot:"";}let end="";return this.isEnd()&&this.#root.#filledNegs&&this.#parent?.type==="!"&&(end="(?:$|\\/)"),[start3+src+end,unescape(src),this.#hasMagic=!!this.#hasMagic,this.#uflag]}let repeated=this.type==="*"||this.type==="+",start2=this.type==="!"?"(?:(?!(?:":"(?:",body=this.#partsToRegExp(dot);if(this.isStart()&&this.isEnd()&&!body&&this.type!=="!"){let s=this.toString();return this.#parts=[s],this.type=null,this.#hasMagic=void 0,[s,unescape(this.toString()),!1,!1]}let bodyDotAllowed=!repeated||allowDot||dot||!startNoDot?"":this.#partsToRegExp(!0);bodyDotAllowed===body&&(bodyDotAllowed=""),bodyDotAllowed&&(body=`(?:${body})(?:${bodyDotAllowed})*?`);let final="";if(this.type==="!"&&this.#emptyExt)final=(this.isStart()&&!dot?startNoDot:"")+starNoEmpty;else {let close=this.type==="!"?"))"+(this.isStart()&&!dot&&!allowDot?startNoDot:"")+star+")":this.type==="@"?")":this.type==="?"?")?":this.type==="+"&&bodyDotAllowed?")":this.type==="*"&&bodyDotAllowed?")?":`)${this.type}`;final=start2+body+close;}return [final,unescape(body),this.#hasMagic=!!this.#hasMagic,this.#uflag]}#partsToRegExp(dot){return this.#parts.map(p=>{if(typeof p=="string")throw new Error("string type in extglob ast??");let[re,_,_hasMagic,uflag]=p.toRegExpSource(dot);return this.#uflag=this.#uflag||uflag,re}).filter(p=>!(this.isStart()&&this.isEnd())||!!p).join("|")}static#parseGlob(glob2,hasMagic2,noEmpty=!1){let escaping=!1,re="",uflag=!1;for(let i=0;i<glob2.length;i++){let c=glob2.charAt(i);if(escaping){escaping=!1,re+=(reSpecials.has(c)?"\\":"")+c;continue}if(c==="\\"){i===glob2.length-1?re+="\\\\":escaping=!0;continue}if(c==="["){let[src,needUflag,consumed,magic]=parseClass(glob2,i);if(consumed){re+=src,uflag=uflag||needUflag,i+=consumed-1,hasMagic2=hasMagic2||magic;continue}}if(c==="*"){noEmpty&&glob2==="*"?re+=starNoEmpty:re+=star,hasMagic2=!0;continue}if(c==="?"){re+=qmark,hasMagic2=!0;continue}re+=regExpEscape(c);}return [re,unescape(glob2),!!hasMagic2,uflag]}};var escape=(s,{windowsPathsNoEscape=!1}={})=>windowsPathsNoEscape?s.replace(/[?*()[\]]/g,"[$&]"):s.replace(/[?*()[\]\\]/g,"\\$&");var minimatch=(p,pattern,options={})=>(assertValidPattern(pattern),!options.nocomment&&pattern.charAt(0)==="#"?!1:new Minimatch(pattern,options).match(p)),starDotExtRE=/^\*+([^+@!?\*\[\(]*)$/,starDotExtTest=ext2=>f=>!f.startsWith(".")&&f.endsWith(ext2),starDotExtTestDot=ext2=>f=>f.endsWith(ext2),starDotExtTestNocase=ext2=>(ext2=ext2.toLowerCase(),f=>!f.startsWith(".")&&f.toLowerCase().endsWith(ext2)),starDotExtTestNocaseDot=ext2=>(ext2=ext2.toLowerCase(),f=>f.toLowerCase().endsWith(ext2)),starDotStarRE=/^\*+\.\*+$/,starDotStarTest=f=>!f.startsWith(".")&&f.includes("."),starDotStarTestDot=f=>f!=="."&&f!==".."&&f.includes("."),dotStarRE=/^\.\*+$/,dotStarTest=f=>f!=="."&&f!==".."&&f.startsWith("."),starRE=/^\*+$/,starTest=f=>f.length!==0&&!f.startsWith("."),starTestDot=f=>f.length!==0&&f!=="."&&f!=="..",qmarksRE=/^\?+([^+@!?\*\[\(]*)?$/,qmarksTestNocase=([$0,ext2=""])=>{let noext=qmarksTestNoExt([$0]);return ext2?(ext2=ext2.toLowerCase(),f=>noext(f)&&f.toLowerCase().endsWith(ext2)):noext},qmarksTestNocaseDot=([$0,ext2=""])=>{let noext=qmarksTestNoExtDot([$0]);return ext2?(ext2=ext2.toLowerCase(),f=>noext(f)&&f.toLowerCase().endsWith(ext2)):noext},qmarksTestDot=([$0,ext2=""])=>{let noext=qmarksTestNoExtDot([$0]);return ext2?f=>noext(f)&&f.endsWith(ext2):noext},qmarksTest=([$0,ext2=""])=>{let noext=qmarksTestNoExt([$0]);return ext2?f=>noext(f)&&f.endsWith(ext2):noext},qmarksTestNoExt=([$0])=>{let len=$0.length;return f=>f.length===len&&!f.startsWith(".")},qmarksTestNoExtDot=([$0])=>{let len=$0.length;return f=>f.length===len&&f!=="."&&f!==".."},defaultPlatform=typeof process=="object"&&process?typeof process.env=="object"&&process.env&&process.env.__MINIMATCH_TESTING_PLATFORM__||process.platform:"posix",path={win32:{sep:"\\"},posix:{sep:"/"}},sep=defaultPlatform==="win32"?path.win32.sep:path.posix.sep;minimatch.sep=sep;var GLOBSTAR=Symbol("globstar **");minimatch.GLOBSTAR=GLOBSTAR;var qmark2="[^/]",star2=qmark2+"*?",twoStarDot="(?:(?!(?:\\/|^)(?:\\.{1,2})($|\\/)).)*?",twoStarNoDot="(?:(?!(?:\\/|^)\\.).)*?",filter=(pattern,options={})=>p=>minimatch(p,pattern,options);minimatch.filter=filter;var ext=(a,b={})=>Object.assign({},a,b),defaults=def=>{if(!def||typeof def!="object"||!Object.keys(def).length)return minimatch;let orig=minimatch;return Object.assign((p,pattern,options={})=>orig(p,pattern,ext(def,options)),{Minimatch:class extends orig.Minimatch{constructor(pattern,options={}){super(pattern,ext(def,options));}static defaults(options){return orig.defaults(ext(def,options)).Minimatch}},AST:class extends orig.AST{constructor(type,parent,options={}){super(type,parent,ext(def,options));}static fromGlob(pattern,options={}){return orig.AST.fromGlob(pattern,ext(def,options))}},unescape:(s,options={})=>orig.unescape(s,ext(def,options)),escape:(s,options={})=>orig.escape(s,ext(def,options)),filter:(pattern,options={})=>orig.filter(pattern,ext(def,options)),defaults:options=>orig.defaults(ext(def,options)),makeRe:(pattern,options={})=>orig.makeRe(pattern,ext(def,options)),braceExpand:(pattern,options={})=>orig.braceExpand(pattern,ext(def,options)),match:(list,pattern,options={})=>orig.match(list,pattern,ext(def,options)),sep:orig.sep,GLOBSTAR})};minimatch.defaults=defaults;var braceExpand=(pattern,options={})=>(assertValidPattern(pattern),options.nobrace||!/\{(?:(?!\{).)*\}/.test(pattern)?[pattern]:(0, import_brace_expansion.default)(pattern));minimatch.braceExpand=braceExpand;var makeRe=(pattern,options={})=>new Minimatch(pattern,options).makeRe();minimatch.makeRe=makeRe;var match=(list,pattern,options={})=>{let mm=new Minimatch(pattern,options);return list=list.filter(f=>mm.match(f)),mm.options.nonull&&!list.length&&list.push(pattern),list};minimatch.match=match;var globMagic=/[?*]|[+@!]\(.*?\)|\[|\]/,regExpEscape2=s=>s.replace(/[-[\]{}()*+?.,\\^$|#\s]/g,"\\$&"),Minimatch=class{options;set;pattern;windowsPathsNoEscape;nonegate;negate;comment;empty;preserveMultipleSlashes;partial;globSet;globParts;nocase;isWindows;platform;windowsNoMagicRoot;regexp;constructor(pattern,options={}){assertValidPattern(pattern),options=options||{},this.options=options,this.pattern=pattern,this.platform=options.platform||defaultPlatform,this.isWindows=this.platform==="win32",this.windowsPathsNoEscape=!!options.windowsPathsNoEscape||options.allowWindowsEscape===!1,this.windowsPathsNoEscape&&(this.pattern=this.pattern.replace(/\\/g,"/")),this.preserveMultipleSlashes=!!options.preserveMultipleSlashes,this.regexp=null,this.negate=!1,this.nonegate=!!options.nonegate,this.comment=!1,this.empty=!1,this.partial=!!options.partial,this.nocase=!!this.options.nocase,this.windowsNoMagicRoot=options.windowsNoMagicRoot!==void 0?options.windowsNoMagicRoot:!!(this.isWindows&&this.nocase),this.globSet=[],this.globParts=[],this.set=[],this.make();}hasMagic(){if(this.options.magicalBraces&&this.set.length>1)return !0;for(let pattern of this.set)for(let part of pattern)if(typeof part!="string")return !0;return !1}debug(..._){}make(){let pattern=this.pattern,options=this.options;if(!options.nocomment&&pattern.charAt(0)==="#"){this.comment=!0;return}if(!pattern){this.empty=!0;return}this.parseNegate(),this.globSet=[...new Set(this.braceExpand())],options.debug&&(this.debug=(...args)=>console.error(...args)),this.debug(this.pattern,this.globSet);let rawGlobParts=this.globSet.map(s=>this.slashSplit(s));this.globParts=this.preprocess(rawGlobParts),this.debug(this.pattern,this.globParts);let set=this.globParts.map((s,_,__)=>{if(this.isWindows&&this.windowsNoMagicRoot){let isUNC=s[0]===""&&s[1]===""&&(s[2]==="?"||!globMagic.test(s[2]))&&!globMagic.test(s[3]),isDrive=/^[a-z]:/i.test(s[0]);if(isUNC)return [...s.slice(0,4),...s.slice(4).map(ss=>this.parse(ss))];if(isDrive)return [s[0],...s.slice(1).map(ss=>this.parse(ss))]}return s.map(ss=>this.parse(ss))});if(this.debug(this.pattern,set),this.set=set.filter(s=>s.indexOf(!1)===-1),this.isWindows)for(let i=0;i<this.set.length;i++){let p=this.set[i];p[0]===""&&p[1]===""&&this.globParts[i][2]==="?"&&typeof p[3]=="string"&&/^[a-z]:$/i.test(p[3])&&(p[2]="?");}this.debug(this.pattern,this.set);}preprocess(globParts){if(this.options.noglobstar)for(let i=0;i<globParts.length;i++)for(let j=0;j<globParts[i].length;j++)globParts[i][j]==="**"&&(globParts[i][j]="*");let{optimizationLevel=1}=this.options;return optimizationLevel>=2?(globParts=this.firstPhasePreProcess(globParts),globParts=this.secondPhasePreProcess(globParts)):optimizationLevel>=1?globParts=this.levelOneOptimize(globParts):globParts=this.adjascentGlobstarOptimize(globParts),globParts}adjascentGlobstarOptimize(globParts){return globParts.map(parts=>{let gs=-1;for(;(gs=parts.indexOf("**",gs+1))!==-1;){let i=gs;for(;parts[i+1]==="**";)i++;i!==gs&&parts.splice(gs,i-gs);}return parts})}levelOneOptimize(globParts){return globParts.map(parts=>(parts=parts.reduce((set,part)=>{let prev=set[set.length-1];return part==="**"&&prev==="**"?set:part===".."&&prev&&prev!==".."&&prev!=="."&&prev!=="**"?(set.pop(),set):(set.push(part),set)},[]),parts.length===0?[""]:parts))}levelTwoFileOptimize(parts){Array.isArray(parts)||(parts=this.slashSplit(parts));let didSomething=!1;do{if(didSomething=!1,!this.preserveMultipleSlashes){for(let i=1;i<parts.length-1;i++){let p=parts[i];i===1&&p===""&&parts[0]===""||(p==="."||p==="")&&(didSomething=!0,parts.splice(i,1),i--);}parts[0]==="."&&parts.length===2&&(parts[1]==="."||parts[1]==="")&&(didSomething=!0,parts.pop());}let dd=0;for(;(dd=parts.indexOf("..",dd+1))!==-1;){let p=parts[dd-1];p&&p!=="."&&p!==".."&&p!=="**"&&(didSomething=!0,parts.splice(dd-1,2),dd-=2);}}while(didSomething);return parts.length===0?[""]:parts}firstPhasePreProcess(globParts){let didSomething=!1;do{didSomething=!1;for(let parts of globParts){let gs=-1;for(;(gs=parts.indexOf("**",gs+1))!==-1;){let gss=gs;for(;parts[gss+1]==="**";)gss++;gss>gs&&parts.splice(gs+1,gss-gs);let next=parts[gs+1],p=parts[gs+2],p2=parts[gs+3];if(next!==".."||!p||p==="."||p===".."||!p2||p2==="."||p2==="..")continue;didSomething=!0,parts.splice(gs,1);let other=parts.slice(0);other[gs]="**",globParts.push(other),gs--;}if(!this.preserveMultipleSlashes){for(let i=1;i<parts.length-1;i++){let p=parts[i];i===1&&p===""&&parts[0]===""||(p==="."||p==="")&&(didSomething=!0,parts.splice(i,1),i--);}parts[0]==="."&&parts.length===2&&(parts[1]==="."||parts[1]==="")&&(didSomething=!0,parts.pop());}let dd=0;for(;(dd=parts.indexOf("..",dd+1))!==-1;){let p=parts[dd-1];if(p&&p!=="."&&p!==".."&&p!=="**"){didSomething=!0;let splin=dd===1&&parts[dd+1]==="**"?["."]:[];parts.splice(dd-1,2,...splin),parts.length===0&&parts.push(""),dd-=2;}}}}while(didSomething);return globParts}secondPhasePreProcess(globParts){for(let i=0;i<globParts.length-1;i++)for(let j=i+1;j<globParts.length;j++){let matched=this.partsMatch(globParts[i],globParts[j],!this.preserveMultipleSlashes);matched&&(globParts[i]=matched,globParts[j]=[]);}return globParts.filter(gs=>gs.length)}partsMatch(a,b,emptyGSMatch=!1){let ai=0,bi=0,result=[],which="";for(;ai<a.length&&bi<b.length;)if(a[ai]===b[bi])result.push(which==="b"?b[bi]:a[ai]),ai++,bi++;else if(emptyGSMatch&&a[ai]==="**"&&b[bi]===a[ai+1])result.push(a[ai]),ai++;else if(emptyGSMatch&&b[bi]==="**"&&a[ai]===b[bi+1])result.push(b[bi]),bi++;else if(a[ai]==="*"&&b[bi]&&(this.options.dot||!b[bi].startsWith("."))&&b[bi]!=="**"){if(which==="b")return !1;which="a",result.push(a[ai]),ai++,bi++;}else if(b[bi]==="*"&&a[ai]&&(this.options.dot||!a[ai].startsWith("."))&&a[ai]!=="**"){if(which==="a")return !1;which="b",result.push(b[bi]),ai++,bi++;}else return !1;return a.length===b.length&&result}parseNegate(){if(this.nonegate)return;let pattern=this.pattern,negate=!1,negateOffset=0;for(let i=0;i<pattern.length&&pattern.charAt(i)==="!";i++)negate=!negate,negateOffset++;negateOffset&&(this.pattern=pattern.slice(negateOffset)),this.negate=negate;}matchOne(file,pattern,partial=!1){let options=this.options;if(this.isWindows){let fileDrive=typeof file[0]=="string"&&/^[a-z]:$/i.test(file[0]),fileUNC=!fileDrive&&file[0]===""&&file[1]===""&&file[2]==="?"&&/^[a-z]:$/i.test(file[3]),patternDrive=typeof pattern[0]=="string"&&/^[a-z]:$/i.test(pattern[0]),patternUNC=!patternDrive&&pattern[0]===""&&pattern[1]===""&&pattern[2]==="?"&&typeof pattern[3]=="string"&&/^[a-z]:$/i.test(pattern[3]),fdi=fileUNC?3:fileDrive?0:void 0,pdi=patternUNC?3:patternDrive?0:void 0;if(typeof fdi=="number"&&typeof pdi=="number"){let[fd,pd]=[file[fdi],pattern[pdi]];fd.toLowerCase()===pd.toLowerCase()&&(pattern[pdi]=fd,pdi>fdi?pattern=pattern.slice(pdi):fdi>pdi&&(file=file.slice(fdi)));}}let{optimizationLevel=1}=this.options;optimizationLevel>=2&&(file=this.levelTwoFileOptimize(file)),this.debug("matchOne",this,{file,pattern}),this.debug("matchOne",file.length,pattern.length);for(var fi=0,pi=0,fl=file.length,pl=pattern.length;fi<fl&&pi<pl;fi++,pi++){this.debug("matchOne loop");var p=pattern[pi],f=file[fi];if(this.debug(pattern,p,f),p===!1)return !1;if(p===GLOBSTAR){this.debug("GLOBSTAR",[pattern,p,f]);var fr=fi,pr=pi+1;if(pr===pl){for(this.debug("** at the end");fi<fl;fi++)if(file[fi]==="."||file[fi]===".."||!options.dot&&file[fi].charAt(0)===".")return !1;return !0}for(;fr<fl;){var swallowee=file[fr];if(this.debug(`
globstar while`,file,fr,pattern,pr,swallowee),this.matchOne(file.slice(fr),pattern.slice(pr),partial))return this.debug("globstar found match!",fr,fl,swallowee),!0;if(swallowee==="."||swallowee===".."||!options.dot&&swallowee.charAt(0)==="."){this.debug("dot detected!",file,fr,pattern,pr);break}this.debug("globstar swallow a segment, and continue"),fr++;}return !!(partial&&(this.debug(`
>>> no match, partial?`,file,fr,pattern,pr),fr===fl))}let hit;if(typeof p=="string"?(hit=f===p,this.debug("string match",p,f,hit)):(hit=p.test(f),this.debug("pattern match",p,f,hit)),!hit)return !1}if(fi===fl&&pi===pl)return !0;if(fi===fl)return partial;if(pi===pl)return fi===fl-1&&file[fi]==="";throw new Error("wtf?")}braceExpand(){return braceExpand(this.pattern,this.options)}parse(pattern){assertValidPattern(pattern);let options=this.options;if(pattern==="**")return GLOBSTAR;if(pattern==="")return "";let m,fastTest=null;(m=pattern.match(starRE))?fastTest=options.dot?starTestDot:starTest:(m=pattern.match(starDotExtRE))?fastTest=(options.nocase?options.dot?starDotExtTestNocaseDot:starDotExtTestNocase:options.dot?starDotExtTestDot:starDotExtTest)(m[1]):(m=pattern.match(qmarksRE))?fastTest=(options.nocase?options.dot?qmarksTestNocaseDot:qmarksTestNocase:options.dot?qmarksTestDot:qmarksTest)(m):(m=pattern.match(starDotStarRE))?fastTest=options.dot?starDotStarTestDot:starDotStarTest:(m=pattern.match(dotStarRE))&&(fastTest=dotStarTest);let re=AST.fromGlob(pattern,this.options).toMMPattern();return fastTest?Object.assign(re,{test:fastTest}):re}makeRe(){if(this.regexp||this.regexp===!1)return this.regexp;let set=this.set;if(!set.length)return this.regexp=!1,this.regexp;let options=this.options,twoStar=options.noglobstar?star2:options.dot?twoStarDot:twoStarNoDot,flags=new Set(options.nocase?["i"]:[]),re=set.map(pattern=>{let pp=pattern.map(p=>{if(p instanceof RegExp)for(let f of p.flags.split(""))flags.add(f);return typeof p=="string"?regExpEscape2(p):p===GLOBSTAR?GLOBSTAR:p._src});return pp.forEach((p,i)=>{let next=pp[i+1],prev=pp[i-1];p!==GLOBSTAR||prev===GLOBSTAR||(prev===void 0?next!==void 0&&next!==GLOBSTAR?pp[i+1]="(?:\\/|"+twoStar+"\\/)?"+next:pp[i]=twoStar:next===void 0?pp[i-1]=prev+"(?:\\/|"+twoStar+")?":next!==GLOBSTAR&&(pp[i-1]=prev+"(?:\\/|\\/"+twoStar+"\\/)"+next,pp[i+1]=GLOBSTAR));}),pp.filter(p=>p!==GLOBSTAR).join("/")}).join("|"),[open,close]=set.length>1?["(?:",")"]:["",""];re="^"+open+re+close+"$",this.negate&&(re="^(?!"+re+").+$");try{this.regexp=new RegExp(re,[...flags].join(""));}catch{this.regexp=!1;}return this.regexp}slashSplit(p){return this.preserveMultipleSlashes?p.split("/"):this.isWindows&&/^\/\/[^\/]+/.test(p)?["",...p.split(/\/+/)]:p.split(/\/+/)}match(f,partial=this.partial){if(this.debug("match",f,this.pattern),this.comment)return !1;if(this.empty)return f==="";if(f==="/"&&partial)return !0;let options=this.options;this.isWindows&&(f=f.split("\\").join("/"));let ff=this.slashSplit(f);this.debug(this.pattern,"split",ff);let set=this.set;this.debug(this.pattern,"set",set);let filename=ff[ff.length-1];if(!filename)for(let i=ff.length-2;!filename&&i>=0;i--)filename=ff[i];for(let i=0;i<set.length;i++){let pattern=set[i],file=ff;if(options.matchBase&&pattern.length===1&&(file=[filename]),this.matchOne(file,pattern,partial))return options.flipNegate?!0:!this.negate}return options.flipNegate?!1:this.negate}static defaults(def){return minimatch.defaults(def).Minimatch}};minimatch.AST=AST;minimatch.Minimatch=Minimatch;minimatch.escape=escape;minimatch.unescape=unescape;var perf=typeof performance=="object"&&performance&&typeof performance.now=="function"?performance:Date,warned=new Set,PROCESS=typeof process=="object"&&process?process:{},emitWarning=(msg,type,code,fn)=>{typeof PROCESS.emitWarning=="function"?PROCESS.emitWarning(msg,type,code,fn):console.error(`[${code}] ${type}: ${msg}`);},AC=globalThis.AbortController,AS=globalThis.AbortSignal;if(typeof AC>"u"){AS=class{onabort;_onabort=[];reason;aborted=!1;addEventListener(_,fn){this._onabort.push(fn);}},AC=class{constructor(){warnACPolyfill();}signal=new AS;abort(reason){if(!this.signal.aborted){this.signal.reason=reason,this.signal.aborted=!0;for(let fn of this.signal._onabort)fn(reason);this.signal.onabort?.(reason);}}};let printACPolyfillWarning=PROCESS.env?.LRU_CACHE_IGNORE_AC_WARNING!=="1",warnACPolyfill=()=>{printACPolyfillWarning&&(printACPolyfillWarning=!1,emitWarning("AbortController is not defined. If using lru-cache in node 14, load an AbortController polyfill from the `node-abort-controller` package. A minimal polyfill is provided for use by LRUCache.fetch(), but it should not be relied upon in other contexts (eg, passing it to other APIs that use AbortController/AbortSignal might have undesirable effects). You may disable this with LRU_CACHE_IGNORE_AC_WARNING=1 in the env.","NO_ABORT_CONTROLLER","ENOTSUP",warnACPolyfill));};}var shouldWarn=code=>!warned.has(code),isPosInt=n=>n&&n===Math.floor(n)&&n>0&&isFinite(n),getUintArray=max=>isPosInt(max)?max<=Math.pow(2,8)?Uint8Array:max<=Math.pow(2,16)?Uint16Array:max<=Math.pow(2,32)?Uint32Array:max<=Number.MAX_SAFE_INTEGER?ZeroArray:null:null,ZeroArray=class extends Array{constructor(size){super(size),this.fill(0);}},Stack=class _Stack{heap;length;static#constructing=!1;static create(max){let HeapCls=getUintArray(max);if(!HeapCls)return [];_Stack.#constructing=!0;let s=new _Stack(max,HeapCls);return _Stack.#constructing=!1,s}constructor(max,HeapCls){if(!_Stack.#constructing)throw new TypeError("instantiate Stack using Stack.create(n)");this.heap=new HeapCls(max),this.length=0;}push(n){this.heap[this.length++]=n;}pop(){return this.heap[--this.length]}},LRUCache=class _LRUCache{#max;#maxSize;#dispose;#disposeAfter;#fetchMethod;ttl;ttlResolution;ttlAutopurge;updateAgeOnGet;updateAgeOnHas;allowStale;noDisposeOnSet;noUpdateTTL;maxEntrySize;sizeCalculation;noDeleteOnFetchRejection;noDeleteOnStaleGet;allowStaleOnFetchAbort;allowStaleOnFetchRejection;ignoreFetchAbort;#size;#calculatedSize;#keyMap;#keyList;#valList;#next;#prev;#head;#tail;#free;#disposed;#sizes;#starts;#ttls;#hasDispose;#hasFetchMethod;#hasDisposeAfter;static unsafeExposeInternals(c){return {starts:c.#starts,ttls:c.#ttls,sizes:c.#sizes,keyMap:c.#keyMap,keyList:c.#keyList,valList:c.#valList,next:c.#next,prev:c.#prev,get head(){return c.#head},get tail(){return c.#tail},free:c.#free,isBackgroundFetch:p=>c.#isBackgroundFetch(p),backgroundFetch:(k,index,options,context)=>c.#backgroundFetch(k,index,options,context),moveToTail:index=>c.#moveToTail(index),indexes:options=>c.#indexes(options),rindexes:options=>c.#rindexes(options),isStale:index=>c.#isStale(index)}}get max(){return this.#max}get maxSize(){return this.#maxSize}get calculatedSize(){return this.#calculatedSize}get size(){return this.#size}get fetchMethod(){return this.#fetchMethod}get dispose(){return this.#dispose}get disposeAfter(){return this.#disposeAfter}constructor(options){let{max=0,ttl,ttlResolution=1,ttlAutopurge,updateAgeOnGet,updateAgeOnHas,allowStale,dispose,disposeAfter,noDisposeOnSet,noUpdateTTL,maxSize=0,maxEntrySize=0,sizeCalculation,fetchMethod,noDeleteOnFetchRejection,noDeleteOnStaleGet,allowStaleOnFetchRejection,allowStaleOnFetchAbort,ignoreFetchAbort}=options;if(max!==0&&!isPosInt(max))throw new TypeError("max option must be a nonnegative integer");let UintArray=max?getUintArray(max):Array;if(!UintArray)throw new Error("invalid max value: "+max);if(this.#max=max,this.#maxSize=maxSize,this.maxEntrySize=maxEntrySize||this.#maxSize,this.sizeCalculation=sizeCalculation,this.sizeCalculation){if(!this.#maxSize&&!this.maxEntrySize)throw new TypeError("cannot set sizeCalculation without setting maxSize or maxEntrySize");if(typeof this.sizeCalculation!="function")throw new TypeError("sizeCalculation set to non-function")}if(fetchMethod!==void 0&&typeof fetchMethod!="function")throw new TypeError("fetchMethod must be a function if specified");if(this.#fetchMethod=fetchMethod,this.#hasFetchMethod=!!fetchMethod,this.#keyMap=new Map,this.#keyList=new Array(max).fill(void 0),this.#valList=new Array(max).fill(void 0),this.#next=new UintArray(max),this.#prev=new UintArray(max),this.#head=0,this.#tail=0,this.#free=Stack.create(max),this.#size=0,this.#calculatedSize=0,typeof dispose=="function"&&(this.#dispose=dispose),typeof disposeAfter=="function"?(this.#disposeAfter=disposeAfter,this.#disposed=[]):(this.#disposeAfter=void 0,this.#disposed=void 0),this.#hasDispose=!!this.#dispose,this.#hasDisposeAfter=!!this.#disposeAfter,this.noDisposeOnSet=!!noDisposeOnSet,this.noUpdateTTL=!!noUpdateTTL,this.noDeleteOnFetchRejection=!!noDeleteOnFetchRejection,this.allowStaleOnFetchRejection=!!allowStaleOnFetchRejection,this.allowStaleOnFetchAbort=!!allowStaleOnFetchAbort,this.ignoreFetchAbort=!!ignoreFetchAbort,this.maxEntrySize!==0){if(this.#maxSize!==0&&!isPosInt(this.#maxSize))throw new TypeError("maxSize must be a positive integer if specified");if(!isPosInt(this.maxEntrySize))throw new TypeError("maxEntrySize must be a positive integer if specified");this.#initializeSizeTracking();}if(this.allowStale=!!allowStale,this.noDeleteOnStaleGet=!!noDeleteOnStaleGet,this.updateAgeOnGet=!!updateAgeOnGet,this.updateAgeOnHas=!!updateAgeOnHas,this.ttlResolution=isPosInt(ttlResolution)||ttlResolution===0?ttlResolution:1,this.ttlAutopurge=!!ttlAutopurge,this.ttl=ttl||0,this.ttl){if(!isPosInt(this.ttl))throw new TypeError("ttl must be a positive integer if specified");this.#initializeTTLTracking();}if(this.#max===0&&this.ttl===0&&this.#maxSize===0)throw new TypeError("At least one of max, maxSize, or ttl is required");if(!this.ttlAutopurge&&!this.#max&&!this.#maxSize){let code="LRU_CACHE_UNBOUNDED";shouldWarn(code)&&(warned.add(code),emitWarning("TTL caching without ttlAutopurge, max, or maxSize can result in unbounded memory consumption.","UnboundedCacheWarning",code,_LRUCache));}}getRemainingTTL(key){return this.#keyMap.has(key)?1/0:0}#initializeTTLTracking(){let ttls=new ZeroArray(this.#max),starts=new ZeroArray(this.#max);this.#ttls=ttls,this.#starts=starts,this.#setItemTTL=(index,ttl,start2=perf.now())=>{if(starts[index]=ttl!==0?start2:0,ttls[index]=ttl,ttl!==0&&this.ttlAutopurge){let t=setTimeout(()=>{this.#isStale(index)&&this.delete(this.#keyList[index]);},ttl+1);t.unref&&t.unref();}},this.#updateItemAge=index=>{starts[index]=ttls[index]!==0?perf.now():0;},this.#statusTTL=(status,index)=>{if(ttls[index]){let ttl=ttls[index],start2=starts[index];if(!ttl||!start2)return;status.ttl=ttl,status.start=start2,status.now=cachedNow||getNow();let age=status.now-start2;status.remainingTTL=ttl-age;}};let cachedNow=0,getNow=()=>{let n=perf.now();if(this.ttlResolution>0){cachedNow=n;let t=setTimeout(()=>cachedNow=0,this.ttlResolution);t.unref&&t.unref();}return n};this.getRemainingTTL=key=>{let index=this.#keyMap.get(key);if(index===void 0)return 0;let ttl=ttls[index],start2=starts[index];if(!ttl||!start2)return 1/0;let age=(cachedNow||getNow())-start2;return ttl-age},this.#isStale=index=>{let s=starts[index],t=ttls[index];return !!t&&!!s&&(cachedNow||getNow())-s>t};}#updateItemAge=()=>{};#statusTTL=()=>{};#setItemTTL=()=>{};#isStale=()=>!1;#initializeSizeTracking(){let sizes=new ZeroArray(this.#max);this.#calculatedSize=0,this.#sizes=sizes,this.#removeItemSize=index=>{this.#calculatedSize-=sizes[index],sizes[index]=0;},this.#requireSize=(k,v,size,sizeCalculation)=>{if(this.#isBackgroundFetch(v))return 0;if(!isPosInt(size))if(sizeCalculation){if(typeof sizeCalculation!="function")throw new TypeError("sizeCalculation must be a function");if(size=sizeCalculation(v,k),!isPosInt(size))throw new TypeError("sizeCalculation return invalid (expect positive integer)")}else throw new TypeError("invalid size value (must be positive integer). When maxSize or maxEntrySize is used, sizeCalculation or size must be set.");return size},this.#addItemSize=(index,size,status)=>{if(sizes[index]=size,this.#maxSize){let maxSize=this.#maxSize-sizes[index];for(;this.#calculatedSize>maxSize;)this.#evict(!0);}this.#calculatedSize+=sizes[index],status&&(status.entrySize=size,status.totalCalculatedSize=this.#calculatedSize);};}#removeItemSize=_i=>{};#addItemSize=(_i,_s,_st)=>{};#requireSize=(_k,_v,size,sizeCalculation)=>{if(size||sizeCalculation)throw new TypeError("cannot set size without setting maxSize or maxEntrySize on cache");return 0};*#indexes({allowStale=this.allowStale}={}){if(this.#size)for(let i=this.#tail;!(!this.#isValidIndex(i)||((allowStale||!this.#isStale(i))&&(yield i),i===this.#head));)i=this.#prev[i];}*#rindexes({allowStale=this.allowStale}={}){if(this.#size)for(let i=this.#head;!(!this.#isValidIndex(i)||((allowStale||!this.#isStale(i))&&(yield i),i===this.#tail));)i=this.#next[i];}#isValidIndex(index){return index!==void 0&&this.#keyMap.get(this.#keyList[index])===index}*entries(){for(let i of this.#indexes())this.#valList[i]!==void 0&&this.#keyList[i]!==void 0&&!this.#isBackgroundFetch(this.#valList[i])&&(yield [this.#keyList[i],this.#valList[i]]);}*rentries(){for(let i of this.#rindexes())this.#valList[i]!==void 0&&this.#keyList[i]!==void 0&&!this.#isBackgroundFetch(this.#valList[i])&&(yield [this.#keyList[i],this.#valList[i]]);}*keys(){for(let i of this.#indexes()){let k=this.#keyList[i];k!==void 0&&!this.#isBackgroundFetch(this.#valList[i])&&(yield k);}}*rkeys(){for(let i of this.#rindexes()){let k=this.#keyList[i];k!==void 0&&!this.#isBackgroundFetch(this.#valList[i])&&(yield k);}}*values(){for(let i of this.#indexes())this.#valList[i]!==void 0&&!this.#isBackgroundFetch(this.#valList[i])&&(yield this.#valList[i]);}*rvalues(){for(let i of this.#rindexes())this.#valList[i]!==void 0&&!this.#isBackgroundFetch(this.#valList[i])&&(yield this.#valList[i]);}[Symbol.iterator](){return this.entries()}find(fn,getOptions={}){for(let i of this.#indexes()){let v=this.#valList[i],value=this.#isBackgroundFetch(v)?v.__staleWhileFetching:v;if(value!==void 0&&fn(value,this.#keyList[i],this))return this.get(this.#keyList[i],getOptions)}}forEach(fn,thisp=this){for(let i of this.#indexes()){let v=this.#valList[i],value=this.#isBackgroundFetch(v)?v.__staleWhileFetching:v;value!==void 0&&fn.call(thisp,value,this.#keyList[i],this);}}rforEach(fn,thisp=this){for(let i of this.#rindexes()){let v=this.#valList[i],value=this.#isBackgroundFetch(v)?v.__staleWhileFetching:v;value!==void 0&&fn.call(thisp,value,this.#keyList[i],this);}}purgeStale(){let deleted=!1;for(let i of this.#rindexes({allowStale:!0}))this.#isStale(i)&&(this.delete(this.#keyList[i]),deleted=!0);return deleted}info(key){let i=this.#keyMap.get(key);if(i===void 0)return;let v=this.#valList[i],value=this.#isBackgroundFetch(v)?v.__staleWhileFetching:v;if(value===void 0)return;let entry={value};if(this.#ttls&&this.#starts){let ttl=this.#ttls[i],start2=this.#starts[i];if(ttl&&start2){let remain=ttl-(perf.now()-start2);entry.ttl=remain,entry.start=Date.now();}}return this.#sizes&&(entry.size=this.#sizes[i]),entry}dump(){let arr=[];for(let i of this.#indexes({allowStale:!0})){let key=this.#keyList[i],v=this.#valList[i],value=this.#isBackgroundFetch(v)?v.__staleWhileFetching:v;if(value===void 0||key===void 0)continue;let entry={value};if(this.#ttls&&this.#starts){entry.ttl=this.#ttls[i];let age=perf.now()-this.#starts[i];entry.start=Math.floor(Date.now()-age);}this.#sizes&&(entry.size=this.#sizes[i]),arr.unshift([key,entry]);}return arr}load(arr){this.clear();for(let[key,entry]of arr){if(entry.start){let age=Date.now()-entry.start;entry.start=perf.now()-age;}this.set(key,entry.value,entry);}}set(k,v,setOptions={}){if(v===void 0)return this.delete(k),this;let{ttl=this.ttl,start:start2,noDisposeOnSet=this.noDisposeOnSet,sizeCalculation=this.sizeCalculation,status}=setOptions,{noUpdateTTL=this.noUpdateTTL}=setOptions,size=this.#requireSize(k,v,setOptions.size||0,sizeCalculation);if(this.maxEntrySize&&size>this.maxEntrySize)return status&&(status.set="miss",status.maxEntrySizeExceeded=!0),this.delete(k),this;let index=this.#size===0?void 0:this.#keyMap.get(k);if(index===void 0)index=this.#size===0?this.#tail:this.#free.length!==0?this.#free.pop():this.#size===this.#max?this.#evict(!1):this.#size,this.#keyList[index]=k,this.#valList[index]=v,this.#keyMap.set(k,index),this.#next[this.#tail]=index,this.#prev[index]=this.#tail,this.#tail=index,this.#size++,this.#addItemSize(index,size,status),status&&(status.set="add"),noUpdateTTL=!1;else {this.#moveToTail(index);let oldVal=this.#valList[index];if(v!==oldVal){if(this.#hasFetchMethod&&this.#isBackgroundFetch(oldVal)){oldVal.__abortController.abort(new Error("replaced"));let{__staleWhileFetching:s}=oldVal;s!==void 0&&!noDisposeOnSet&&(this.#hasDispose&&this.#dispose?.(s,k,"set"),this.#hasDisposeAfter&&this.#disposed?.push([s,k,"set"]));}else noDisposeOnSet||(this.#hasDispose&&this.#dispose?.(oldVal,k,"set"),this.#hasDisposeAfter&&this.#disposed?.push([oldVal,k,"set"]));if(this.#removeItemSize(index),this.#addItemSize(index,size,status),this.#valList[index]=v,status){status.set="replace";let oldValue=oldVal&&this.#isBackgroundFetch(oldVal)?oldVal.__staleWhileFetching:oldVal;oldValue!==void 0&&(status.oldValue=oldValue);}}else status&&(status.set="update");}if(ttl!==0&&!this.#ttls&&this.#initializeTTLTracking(),this.#ttls&&(noUpdateTTL||this.#setItemTTL(index,ttl,start2),status&&this.#statusTTL(status,index)),!noDisposeOnSet&&this.#hasDisposeAfter&&this.#disposed){let dt=this.#disposed,task;for(;task=dt?.shift();)this.#disposeAfter?.(...task);}return this}pop(){try{for(;this.#size;){let val=this.#valList[this.#head];if(this.#evict(!0),this.#isBackgroundFetch(val)){if(val.__staleWhileFetching)return val.__staleWhileFetching}else if(val!==void 0)return val}}finally{if(this.#hasDisposeAfter&&this.#disposed){let dt=this.#disposed,task;for(;task=dt?.shift();)this.#disposeAfter?.(...task);}}}#evict(free){let head=this.#head,k=this.#keyList[head],v=this.#valList[head];return this.#hasFetchMethod&&this.#isBackgroundFetch(v)?v.__abortController.abort(new Error("evicted")):(this.#hasDispose||this.#hasDisposeAfter)&&(this.#hasDispose&&this.#dispose?.(v,k,"evict"),this.#hasDisposeAfter&&this.#disposed?.push([v,k,"evict"])),this.#removeItemSize(head),free&&(this.#keyList[head]=void 0,this.#valList[head]=void 0,this.#free.push(head)),this.#size===1?(this.#head=this.#tail=0,this.#free.length=0):this.#head=this.#next[head],this.#keyMap.delete(k),this.#size--,head}has(k,hasOptions={}){let{updateAgeOnHas=this.updateAgeOnHas,status}=hasOptions,index=this.#keyMap.get(k);if(index!==void 0){let v=this.#valList[index];if(this.#isBackgroundFetch(v)&&v.__staleWhileFetching===void 0)return !1;if(this.#isStale(index))status&&(status.has="stale",this.#statusTTL(status,index));else return updateAgeOnHas&&this.#updateItemAge(index),status&&(status.has="hit",this.#statusTTL(status,index)),!0}else status&&(status.has="miss");return !1}peek(k,peekOptions={}){let{allowStale=this.allowStale}=peekOptions,index=this.#keyMap.get(k);if(index===void 0||!allowStale&&this.#isStale(index))return;let v=this.#valList[index];return this.#isBackgroundFetch(v)?v.__staleWhileFetching:v}#backgroundFetch(k,index,options,context){let v=index===void 0?void 0:this.#valList[index];if(this.#isBackgroundFetch(v))return v;let ac=new AC,{signal}=options;signal?.addEventListener("abort",()=>ac.abort(signal.reason),{signal:ac.signal});let fetchOpts={signal:ac.signal,options,context},cb=(v2,updateCache=!1)=>{let{aborted}=ac.signal,ignoreAbort=options.ignoreFetchAbort&&v2!==void 0;if(options.status&&(aborted&&!updateCache?(options.status.fetchAborted=!0,options.status.fetchError=ac.signal.reason,ignoreAbort&&(options.status.fetchAbortIgnored=!0)):options.status.fetchResolved=!0),aborted&&!ignoreAbort&&!updateCache)return fetchFail(ac.signal.reason);let bf2=p;return this.#valList[index]===p&&(v2===void 0?bf2.__staleWhileFetching?this.#valList[index]=bf2.__staleWhileFetching:this.delete(k):(options.status&&(options.status.fetchUpdated=!0),this.set(k,v2,fetchOpts.options))),v2},eb=er=>(options.status&&(options.status.fetchRejected=!0,options.status.fetchError=er),fetchFail(er)),fetchFail=er=>{let{aborted}=ac.signal,allowStaleAborted=aborted&&options.allowStaleOnFetchAbort,allowStale=allowStaleAborted||options.allowStaleOnFetchRejection,noDelete=allowStale||options.noDeleteOnFetchRejection,bf2=p;if(this.#valList[index]===p&&(!noDelete||bf2.__staleWhileFetching===void 0?this.delete(k):allowStaleAborted||(this.#valList[index]=bf2.__staleWhileFetching)),allowStale)return options.status&&bf2.__staleWhileFetching!==void 0&&(options.status.returnedStale=!0),bf2.__staleWhileFetching;if(bf2.__returned===bf2)throw er},pcall=(res,rej)=>{let fmp=this.#fetchMethod?.(k,v,fetchOpts);fmp&&fmp instanceof Promise&&fmp.then(v2=>res(v2===void 0?void 0:v2),rej),ac.signal.addEventListener("abort",()=>{(!options.ignoreFetchAbort||options.allowStaleOnFetchAbort)&&(res(void 0),options.allowStaleOnFetchAbort&&(res=v2=>cb(v2,!0)));});};options.status&&(options.status.fetchDispatched=!0);let p=new Promise(pcall).then(cb,eb),bf=Object.assign(p,{__abortController:ac,__staleWhileFetching:v,__returned:void 0});return index===void 0?(this.set(k,bf,{...fetchOpts.options,status:void 0}),index=this.#keyMap.get(k)):this.#valList[index]=bf,bf}#isBackgroundFetch(p){if(!this.#hasFetchMethod)return !1;let b=p;return !!b&&b instanceof Promise&&b.hasOwnProperty("__staleWhileFetching")&&b.__abortController instanceof AC}async fetch(k,fetchOptions={}){let{allowStale=this.allowStale,updateAgeOnGet=this.updateAgeOnGet,noDeleteOnStaleGet=this.noDeleteOnStaleGet,ttl=this.ttl,noDisposeOnSet=this.noDisposeOnSet,size=0,sizeCalculation=this.sizeCalculation,noUpdateTTL=this.noUpdateTTL,noDeleteOnFetchRejection=this.noDeleteOnFetchRejection,allowStaleOnFetchRejection=this.allowStaleOnFetchRejection,ignoreFetchAbort=this.ignoreFetchAbort,allowStaleOnFetchAbort=this.allowStaleOnFetchAbort,context,forceRefresh=!1,status,signal}=fetchOptions;if(!this.#hasFetchMethod)return status&&(status.fetch="get"),this.get(k,{allowStale,updateAgeOnGet,noDeleteOnStaleGet,status});let options={allowStale,updateAgeOnGet,noDeleteOnStaleGet,ttl,noDisposeOnSet,size,sizeCalculation,noUpdateTTL,noDeleteOnFetchRejection,allowStaleOnFetchRejection,allowStaleOnFetchAbort,ignoreFetchAbort,status,signal},index=this.#keyMap.get(k);if(index===void 0){status&&(status.fetch="miss");let p=this.#backgroundFetch(k,index,options,context);return p.__returned=p}else {let v=this.#valList[index];if(this.#isBackgroundFetch(v)){let stale=allowStale&&v.__staleWhileFetching!==void 0;return status&&(status.fetch="inflight",stale&&(status.returnedStale=!0)),stale?v.__staleWhileFetching:v.__returned=v}let isStale=this.#isStale(index);if(!forceRefresh&&!isStale)return status&&(status.fetch="hit"),this.#moveToTail(index),updateAgeOnGet&&this.#updateItemAge(index),status&&this.#statusTTL(status,index),v;let p=this.#backgroundFetch(k,index,options,context),staleVal=p.__staleWhileFetching!==void 0&&allowStale;return status&&(status.fetch=isStale?"stale":"refresh",staleVal&&isStale&&(status.returnedStale=!0)),staleVal?p.__staleWhileFetching:p.__returned=p}}get(k,getOptions={}){let{allowStale=this.allowStale,updateAgeOnGet=this.updateAgeOnGet,noDeleteOnStaleGet=this.noDeleteOnStaleGet,status}=getOptions,index=this.#keyMap.get(k);if(index!==void 0){let value=this.#valList[index],fetching=this.#isBackgroundFetch(value);return status&&this.#statusTTL(status,index),this.#isStale(index)?(status&&(status.get="stale"),fetching?(status&&allowStale&&value.__staleWhileFetching!==void 0&&(status.returnedStale=!0),allowStale?value.__staleWhileFetching:void 0):(noDeleteOnStaleGet||this.delete(k),status&&allowStale&&(status.returnedStale=!0),allowStale?value:void 0)):(status&&(status.get="hit"),fetching?value.__staleWhileFetching:(this.#moveToTail(index),updateAgeOnGet&&this.#updateItemAge(index),value))}else status&&(status.get="miss");}#connect(p,n){this.#prev[n]=p,this.#next[p]=n;}#moveToTail(index){index!==this.#tail&&(index===this.#head?this.#head=this.#next[index]:this.#connect(this.#prev[index],this.#next[index]),this.#connect(this.#tail,index),this.#tail=index);}delete(k){let deleted=!1;if(this.#size!==0){let index=this.#keyMap.get(k);if(index!==void 0)if(deleted=!0,this.#size===1)this.clear();else {this.#removeItemSize(index);let v=this.#valList[index];if(this.#isBackgroundFetch(v)?v.__abortController.abort(new Error("deleted")):(this.#hasDispose||this.#hasDisposeAfter)&&(this.#hasDispose&&this.#dispose?.(v,k,"delete"),this.#hasDisposeAfter&&this.#disposed?.push([v,k,"delete"])),this.#keyMap.delete(k),this.#keyList[index]=void 0,this.#valList[index]=void 0,index===this.#tail)this.#tail=this.#prev[index];else if(index===this.#head)this.#head=this.#next[index];else {let pi=this.#prev[index];this.#next[pi]=this.#next[index];let ni=this.#next[index];this.#prev[ni]=this.#prev[index];}this.#size--,this.#free.push(index);}}if(this.#hasDisposeAfter&&this.#disposed?.length){let dt=this.#disposed,task;for(;task=dt?.shift();)this.#disposeAfter?.(...task);}return deleted}clear(){for(let index of this.#rindexes({allowStale:!0})){let v=this.#valList[index];if(this.#isBackgroundFetch(v))v.__abortController.abort(new Error("deleted"));else {let k=this.#keyList[index];this.#hasDispose&&this.#dispose?.(v,k,"delete"),this.#hasDisposeAfter&&this.#disposed?.push([v,k,"delete"]);}}if(this.#keyMap.clear(),this.#valList.fill(void 0),this.#keyList.fill(void 0),this.#ttls&&this.#starts&&(this.#ttls.fill(0),this.#starts.fill(0)),this.#sizes&&this.#sizes.fill(0),this.#head=0,this.#tail=0,this.#free.length=0,this.#calculatedSize=0,this.#size=0,this.#hasDisposeAfter&&this.#disposed){let dt=this.#disposed,task;for(;task=dt?.shift();)this.#disposeAfter?.(...task);}}};var proc=typeof process=="object"&&process?process:{stdout:null,stderr:null},isStream=s=>!!s&&typeof s=="object"&&(s instanceof Minipass||s instanceof Stream||isReadable(s)||isWritable(s)),isReadable=s=>!!s&&typeof s=="object"&&s instanceof EventEmitter&&typeof s.pipe=="function"&&s.pipe!==Stream.Writable.prototype.pipe,isWritable=s=>!!s&&typeof s=="object"&&s instanceof EventEmitter&&typeof s.write=="function"&&typeof s.end=="function",EOF=Symbol("EOF"),MAYBE_EMIT_END=Symbol("maybeEmitEnd"),EMITTED_END=Symbol("emittedEnd"),EMITTING_END=Symbol("emittingEnd"),EMITTED_ERROR=Symbol("emittedError"),CLOSED=Symbol("closed"),READ=Symbol("read"),FLUSH=Symbol("flush"),FLUSHCHUNK=Symbol("flushChunk"),ENCODING=Symbol("encoding"),DECODER=Symbol("decoder"),FLOWING=Symbol("flowing"),PAUSED=Symbol("paused"),RESUME=Symbol("resume"),BUFFER=Symbol("buffer"),PIPES=Symbol("pipes"),BUFFERLENGTH=Symbol("bufferLength"),BUFFERPUSH=Symbol("bufferPush"),BUFFERSHIFT=Symbol("bufferShift"),OBJECTMODE=Symbol("objectMode"),DESTROYED=Symbol("destroyed"),ERROR=Symbol("error"),EMITDATA=Symbol("emitData"),EMITEND=Symbol("emitEnd"),EMITEND2=Symbol("emitEnd2"),ASYNC=Symbol("async"),ABORT=Symbol("abort"),ABORTED=Symbol("aborted"),SIGNAL=Symbol("signal"),DATALISTENERS=Symbol("dataListeners"),DISCARDED=Symbol("discarded"),defer=fn=>Promise.resolve().then(fn),nodefer=fn=>fn(),isEndish=ev=>ev==="end"||ev==="finish"||ev==="prefinish",isArrayBufferLike=b=>b instanceof ArrayBuffer||!!b&&typeof b=="object"&&b.constructor&&b.constructor.name==="ArrayBuffer"&&b.byteLength>=0,isArrayBufferView=b=>!Buffer.isBuffer(b)&&ArrayBuffer.isView(b),Pipe=class{src;dest;opts;ondrain;constructor(src,dest,opts){this.src=src,this.dest=dest,this.opts=opts,this.ondrain=()=>src[RESUME](),this.dest.on("drain",this.ondrain);}unpipe(){this.dest.removeListener("drain",this.ondrain);}proxyErrors(_er){}end(){this.unpipe(),this.opts.end&&this.dest.end();}},PipeProxyErrors=class extends Pipe{unpipe(){this.src.removeListener("error",this.proxyErrors),super.unpipe();}constructor(src,dest,opts){super(src,dest,opts),this.proxyErrors=er=>dest.emit("error",er),src.on("error",this.proxyErrors);}},isObjectModeOptions=o=>!!o.objectMode,isEncodingOptions=o=>!o.objectMode&&!!o.encoding&&o.encoding!=="buffer",Minipass=class extends EventEmitter{[FLOWING]=!1;[PAUSED]=!1;[PIPES]=[];[BUFFER]=[];[OBJECTMODE];[ENCODING];[ASYNC];[DECODER];[EOF]=!1;[EMITTED_END]=!1;[EMITTING_END]=!1;[CLOSED]=!1;[EMITTED_ERROR]=null;[BUFFERLENGTH]=0;[DESTROYED]=!1;[SIGNAL];[ABORTED]=!1;[DATALISTENERS]=0;[DISCARDED]=!1;writable=!0;readable=!0;constructor(...args){let options=args[0]||{};if(super(),options.objectMode&&typeof options.encoding=="string")throw new TypeError("Encoding and objectMode may not be used together");isObjectModeOptions(options)?(this[OBJECTMODE]=!0,this[ENCODING]=null):isEncodingOptions(options)?(this[ENCODING]=options.encoding,this[OBJECTMODE]=!1):(this[OBJECTMODE]=!1,this[ENCODING]=null),this[ASYNC]=!!options.async,this[DECODER]=this[ENCODING]?new StringDecoder(this[ENCODING]):null,options&&options.debugExposeBuffer===!0&&Object.defineProperty(this,"buffer",{get:()=>this[BUFFER]}),options&&options.debugExposePipes===!0&&Object.defineProperty(this,"pipes",{get:()=>this[PIPES]});let{signal}=options;signal&&(this[SIGNAL]=signal,signal.aborted?this[ABORT]():signal.addEventListener("abort",()=>this[ABORT]()));}get bufferLength(){return this[BUFFERLENGTH]}get encoding(){return this[ENCODING]}set encoding(_enc){throw new Error("Encoding must be set at instantiation time")}setEncoding(_enc){throw new Error("Encoding must be set at instantiation time")}get objectMode(){return this[OBJECTMODE]}set objectMode(_om){throw new Error("objectMode must be set at instantiation time")}get async(){return this[ASYNC]}set async(a){this[ASYNC]=this[ASYNC]||!!a;}[ABORT](){this[ABORTED]=!0,this.emit("abort",this[SIGNAL]?.reason),this.destroy(this[SIGNAL]?.reason);}get aborted(){return this[ABORTED]}set aborted(_){}write(chunk,encoding,cb){if(this[ABORTED])return !1;if(this[EOF])throw new Error("write after end");if(this[DESTROYED])return this.emit("error",Object.assign(new Error("Cannot call write after a stream was destroyed"),{code:"ERR_STREAM_DESTROYED"})),!0;typeof encoding=="function"&&(cb=encoding,encoding="utf8"),encoding||(encoding="utf8");let fn=this[ASYNC]?defer:nodefer;if(!this[OBJECTMODE]&&!Buffer.isBuffer(chunk)){if(isArrayBufferView(chunk))chunk=Buffer.from(chunk.buffer,chunk.byteOffset,chunk.byteLength);else if(isArrayBufferLike(chunk))chunk=Buffer.from(chunk);else if(typeof chunk!="string")throw new Error("Non-contiguous data written to non-objectMode stream")}return this[OBJECTMODE]?(this[FLOWING]&&this[BUFFERLENGTH]!==0&&this[FLUSH](!0),this[FLOWING]?this.emit("data",chunk):this[BUFFERPUSH](chunk),this[BUFFERLENGTH]!==0&&this.emit("readable"),cb&&fn(cb),this[FLOWING]):chunk.length?(typeof chunk=="string"&&!(encoding===this[ENCODING]&&!this[DECODER]?.lastNeed)&&(chunk=Buffer.from(chunk,encoding)),Buffer.isBuffer(chunk)&&this[ENCODING]&&(chunk=this[DECODER].write(chunk)),this[FLOWING]&&this[BUFFERLENGTH]!==0&&this[FLUSH](!0),this[FLOWING]?this.emit("data",chunk):this[BUFFERPUSH](chunk),this[BUFFERLENGTH]!==0&&this.emit("readable"),cb&&fn(cb),this[FLOWING]):(this[BUFFERLENGTH]!==0&&this.emit("readable"),cb&&fn(cb),this[FLOWING])}read(n){if(this[DESTROYED])return null;if(this[DISCARDED]=!1,this[BUFFERLENGTH]===0||n===0||n&&n>this[BUFFERLENGTH])return this[MAYBE_EMIT_END](),null;this[OBJECTMODE]&&(n=null),this[BUFFER].length>1&&!this[OBJECTMODE]&&(this[BUFFER]=[this[ENCODING]?this[BUFFER].join(""):Buffer.concat(this[BUFFER],this[BUFFERLENGTH])]);let ret=this[READ](n||null,this[BUFFER][0]);return this[MAYBE_EMIT_END](),ret}[READ](n,chunk){if(this[OBJECTMODE])this[BUFFERSHIFT]();else {let c=chunk;n===c.length||n===null?this[BUFFERSHIFT]():typeof c=="string"?(this[BUFFER][0]=c.slice(n),chunk=c.slice(0,n),this[BUFFERLENGTH]-=n):(this[BUFFER][0]=c.subarray(n),chunk=c.subarray(0,n),this[BUFFERLENGTH]-=n);}return this.emit("data",chunk),!this[BUFFER].length&&!this[EOF]&&this.emit("drain"),chunk}end(chunk,encoding,cb){return typeof chunk=="function"&&(cb=chunk,chunk=void 0),typeof encoding=="function"&&(cb=encoding,encoding="utf8"),chunk!==void 0&&this.write(chunk,encoding),cb&&this.once("end",cb),this[EOF]=!0,this.writable=!1,(this[FLOWING]||!this[PAUSED])&&this[MAYBE_EMIT_END](),this}[RESUME](){this[DESTROYED]||(!this[DATALISTENERS]&&!this[PIPES].length&&(this[DISCARDED]=!0),this[PAUSED]=!1,this[FLOWING]=!0,this.emit("resume"),this[BUFFER].length?this[FLUSH]():this[EOF]?this[MAYBE_EMIT_END]():this.emit("drain"));}resume(){return this[RESUME]()}pause(){this[FLOWING]=!1,this[PAUSED]=!0,this[DISCARDED]=!1;}get destroyed(){return this[DESTROYED]}get flowing(){return this[FLOWING]}get paused(){return this[PAUSED]}[BUFFERPUSH](chunk){this[OBJECTMODE]?this[BUFFERLENGTH]+=1:this[BUFFERLENGTH]+=chunk.length,this[BUFFER].push(chunk);}[BUFFERSHIFT](){return this[OBJECTMODE]?this[BUFFERLENGTH]-=1:this[BUFFERLENGTH]-=this[BUFFER][0].length,this[BUFFER].shift()}[FLUSH](noDrain=!1){do;while(this[FLUSHCHUNK](this[BUFFERSHIFT]())&&this[BUFFER].length);!noDrain&&!this[BUFFER].length&&!this[EOF]&&this.emit("drain");}[FLUSHCHUNK](chunk){return this.emit("data",chunk),this[FLOWING]}pipe(dest,opts){if(this[DESTROYED])return dest;this[DISCARDED]=!1;let ended=this[EMITTED_END];return opts=opts||{},dest===proc.stdout||dest===proc.stderr?opts.end=!1:opts.end=opts.end!==!1,opts.proxyErrors=!!opts.proxyErrors,ended?opts.end&&dest.end():(this[PIPES].push(opts.proxyErrors?new PipeProxyErrors(this,dest,opts):new Pipe(this,dest,opts)),this[ASYNC]?defer(()=>this[RESUME]()):this[RESUME]()),dest}unpipe(dest){let p=this[PIPES].find(p2=>p2.dest===dest);p&&(this[PIPES].length===1?(this[FLOWING]&&this[DATALISTENERS]===0&&(this[FLOWING]=!1),this[PIPES]=[]):this[PIPES].splice(this[PIPES].indexOf(p),1),p.unpipe());}addListener(ev,handler){return this.on(ev,handler)}on(ev,handler){let ret=super.on(ev,handler);if(ev==="data")this[DISCARDED]=!1,this[DATALISTENERS]++,!this[PIPES].length&&!this[FLOWING]&&this[RESUME]();else if(ev==="readable"&&this[BUFFERLENGTH]!==0)super.emit("readable");else if(isEndish(ev)&&this[EMITTED_END])super.emit(ev),this.removeAllListeners(ev);else if(ev==="error"&&this[EMITTED_ERROR]){let h=handler;this[ASYNC]?defer(()=>h.call(this,this[EMITTED_ERROR])):h.call(this,this[EMITTED_ERROR]);}return ret}removeListener(ev,handler){return this.off(ev,handler)}off(ev,handler){let ret=super.off(ev,handler);return ev==="data"&&(this[DATALISTENERS]=this.listeners("data").length,this[DATALISTENERS]===0&&!this[DISCARDED]&&!this[PIPES].length&&(this[FLOWING]=!1)),ret}removeAllListeners(ev){let ret=super.removeAllListeners(ev);return (ev==="data"||ev===void 0)&&(this[DATALISTENERS]=0,!this[DISCARDED]&&!this[PIPES].length&&(this[FLOWING]=!1)),ret}get emittedEnd(){return this[EMITTED_END]}[MAYBE_EMIT_END](){!this[EMITTING_END]&&!this[EMITTED_END]&&!this[DESTROYED]&&this[BUFFER].length===0&&this[EOF]&&(this[EMITTING_END]=!0,this.emit("end"),this.emit("prefinish"),this.emit("finish"),this[CLOSED]&&this.emit("close"),this[EMITTING_END]=!1);}emit(ev,...args){let data=args[0];if(ev!=="error"&&ev!=="close"&&ev!==DESTROYED&&this[DESTROYED])return !1;if(ev==="data")return !this[OBJECTMODE]&&!data?!1:this[ASYNC]?(defer(()=>this[EMITDATA](data)),!0):this[EMITDATA](data);if(ev==="end")return this[EMITEND]();if(ev==="close"){if(this[CLOSED]=!0,!this[EMITTED_END]&&!this[DESTROYED])return !1;let ret2=super.emit("close");return this.removeAllListeners("close"),ret2}else if(ev==="error"){this[EMITTED_ERROR]=data,super.emit(ERROR,data);let ret2=!this[SIGNAL]||this.listeners("error").length?super.emit("error",data):!1;return this[MAYBE_EMIT_END](),ret2}else if(ev==="resume"){let ret2=super.emit("resume");return this[MAYBE_EMIT_END](),ret2}else if(ev==="finish"||ev==="prefinish"){let ret2=super.emit(ev);return this.removeAllListeners(ev),ret2}let ret=super.emit(ev,...args);return this[MAYBE_EMIT_END](),ret}[EMITDATA](data){for(let p of this[PIPES])p.dest.write(data)===!1&&this.pause();let ret=this[DISCARDED]?!1:super.emit("data",data);return this[MAYBE_EMIT_END](),ret}[EMITEND](){return this[EMITTED_END]?!1:(this[EMITTED_END]=!0,this.readable=!1,this[ASYNC]?(defer(()=>this[EMITEND2]()),!0):this[EMITEND2]())}[EMITEND2](){if(this[DECODER]){let data=this[DECODER].end();if(data){for(let p of this[PIPES])p.dest.write(data);this[DISCARDED]||super.emit("data",data);}}for(let p of this[PIPES])p.end();let ret=super.emit("end");return this.removeAllListeners("end"),ret}async collect(){let buf=Object.assign([],{dataLength:0});this[OBJECTMODE]||(buf.dataLength=0);let p=this.promise();return this.on("data",c=>{buf.push(c),this[OBJECTMODE]||(buf.dataLength+=c.length);}),await p,buf}async concat(){if(this[OBJECTMODE])throw new Error("cannot concat in objectMode");let buf=await this.collect();return this[ENCODING]?buf.join(""):Buffer.concat(buf,buf.dataLength)}async promise(){return new Promise((resolve3,reject)=>{this.on(DESTROYED,()=>reject(new Error("stream destroyed"))),this.on("error",er=>reject(er)),this.on("end",()=>resolve3());})}[Symbol.asyncIterator](){this[DISCARDED]=!1;let stopped=!1,stop=async()=>(this.pause(),stopped=!0,{value:void 0,done:!0});return {next:()=>{if(stopped)return stop();let res=this.read();if(res!==null)return Promise.resolve({done:!1,value:res});if(this[EOF])return stop();let resolve3,reject,onerr=er=>{this.off("data",ondata),this.off("end",onend),this.off(DESTROYED,ondestroy),stop(),reject(er);},ondata=value=>{this.off("error",onerr),this.off("end",onend),this.off(DESTROYED,ondestroy),this.pause(),resolve3({value,done:!!this[EOF]});},onend=()=>{this.off("error",onerr),this.off("data",ondata),this.off(DESTROYED,ondestroy),stop(),resolve3({done:!0,value:void 0});},ondestroy=()=>onerr(new Error("stream destroyed"));return new Promise((res2,rej)=>{reject=rej,resolve3=res2,this.once(DESTROYED,ondestroy),this.once("error",onerr),this.once("end",onend),this.once("data",ondata);})},throw:stop,return:stop,[Symbol.asyncIterator](){return this}}}[Symbol.iterator](){this[DISCARDED]=!1;let stopped=!1,stop=()=>(this.pause(),this.off(ERROR,stop),this.off(DESTROYED,stop),this.off("end",stop),stopped=!0,{done:!0,value:void 0}),next=()=>{if(stopped)return stop();let value=this.read();return value===null?stop():{done:!1,value}};return this.once("end",stop),this.once(ERROR,stop),this.once(DESTROYED,stop),{next,throw:stop,return:stop,[Symbol.iterator](){return this}}}destroy(er){if(this[DESTROYED])return er?this.emit("error",er):this.emit(DESTROYED),this;this[DESTROYED]=!0,this[DISCARDED]=!0,this[BUFFER].length=0,this[BUFFERLENGTH]=0;let wc=this;return typeof wc.close=="function"&&!this[CLOSED]&&wc.close(),er?this.emit("error",er):this.emit(DESTROYED),this}static get isStream(){return isStream}};var realpathSync=realpathSync$1.native,defaultFS={lstatSync,readdir:readdir,readdirSync,readlinkSync,realpathSync,promises:{lstat,readdir: readdir$1,readlink,realpath}},fsFromOption=fsOption=>!fsOption||fsOption===defaultFS||fsOption===actualFS?defaultFS:{...defaultFS,...fsOption,promises:{...defaultFS.promises,...fsOption.promises||{}}},uncDriveRegexp=/^\\\\\?\\([a-z]:)\\?$/i,uncToDrive=rootPath=>rootPath.replace(/\//g,"\\").replace(uncDriveRegexp,"$1\\"),eitherSep=/[\\\/]/,UNKNOWN=0,IFIFO=1,IFCHR=2,IFDIR=4,IFBLK=6,IFREG=8,IFLNK=10,IFSOCK=12,IFMT=15,IFMT_UNKNOWN=~IFMT,READDIR_CALLED=16,LSTAT_CALLED=32,ENOTDIR=64,ENOENT=128,ENOREADLINK=256,ENOREALPATH=512,ENOCHILD=ENOTDIR|ENOENT|ENOREALPATH,TYPEMASK=1023,entToType=s=>s.isFile()?IFREG:s.isDirectory()?IFDIR:s.isSymbolicLink()?IFLNK:s.isCharacterDevice()?IFCHR:s.isBlockDevice()?IFBLK:s.isSocket()?IFSOCK:s.isFIFO()?IFIFO:UNKNOWN,normalizeCache=new Map,normalize=s=>{let c=normalizeCache.get(s);if(c)return c;let n=s.normalize("NFKD");return normalizeCache.set(s,n),n},normalizeNocaseCache=new Map,normalizeNocase=s=>{let c=normalizeNocaseCache.get(s);if(c)return c;let n=normalize(s.toLowerCase());return normalizeNocaseCache.set(s,n),n},ResolveCache=class extends LRUCache{constructor(){super({max:256});}},ChildrenCache=class extends LRUCache{constructor(maxSize=16*1024){super({maxSize,sizeCalculation:a=>a.length+1});}},setAsCwd=Symbol("PathScurry setAsCwd"),PathBase=class{name;root;roots;parent;nocase;#fs;#dev;get dev(){return this.#dev}#mode;get mode(){return this.#mode}#nlink;get nlink(){return this.#nlink}#uid;get uid(){return this.#uid}#gid;get gid(){return this.#gid}#rdev;get rdev(){return this.#rdev}#blksize;get blksize(){return this.#blksize}#ino;get ino(){return this.#ino}#size;get size(){return this.#size}#blocks;get blocks(){return this.#blocks}#atimeMs;get atimeMs(){return this.#atimeMs}#mtimeMs;get mtimeMs(){return this.#mtimeMs}#ctimeMs;get ctimeMs(){return this.#ctimeMs}#birthtimeMs;get birthtimeMs(){return this.#birthtimeMs}#atime;get atime(){return this.#atime}#mtime;get mtime(){return this.#mtime}#ctime;get ctime(){return this.#ctime}#birthtime;get birthtime(){return this.#birthtime}#matchName;#depth;#fullpath;#fullpathPosix;#relative;#relativePosix;#type;#children;#linkTarget;#realpath;get path(){return (this.parent||this).fullpath()}constructor(name,type=UNKNOWN,root,roots,nocase,children,opts){this.name=name,this.#matchName=nocase?normalizeNocase(name):normalize(name),this.#type=type&TYPEMASK,this.nocase=nocase,this.roots=roots,this.root=root||this,this.#children=children,this.#fullpath=opts.fullpath,this.#relative=opts.relative,this.#relativePosix=opts.relativePosix,this.parent=opts.parent,this.parent?this.#fs=this.parent.#fs:this.#fs=fsFromOption(opts.fs);}depth(){return this.#depth!==void 0?this.#depth:this.parent?this.#depth=this.parent.depth()+1:this.#depth=0}childrenCache(){return this.#children}resolve(path7){if(!path7)return this;let rootPath=this.getRootString(path7),dirParts=path7.substring(rootPath.length).split(this.splitSep);return rootPath?this.getRoot(rootPath).#resolveParts(dirParts):this.#resolveParts(dirParts)}#resolveParts(dirParts){let p=this;for(let part of dirParts)p=p.child(part);return p}children(){let cached=this.#children.get(this);if(cached)return cached;let children=Object.assign([],{provisional:0});return this.#children.set(this,children),this.#type&=~READDIR_CALLED,children}child(pathPart,opts){if(pathPart===""||pathPart===".")return this;if(pathPart==="..")return this.parent||this;let children=this.children(),name=this.nocase?normalizeNocase(pathPart):normalize(pathPart);for(let p of children)if(p.#matchName===name)return p;let s=this.parent?this.sep:"",fullpath=this.#fullpath?this.#fullpath+s+pathPart:void 0,pchild=this.newChild(pathPart,UNKNOWN,{...opts,parent:this,fullpath});return this.canReaddir()||(pchild.#type|=ENOENT),children.push(pchild),pchild}relative(){if(this.#relative!==void 0)return this.#relative;let name=this.name,p=this.parent;if(!p)return this.#relative=this.name;let pv=p.relative();return pv+(!pv||!p.parent?"":this.sep)+name}relativePosix(){if(this.sep==="/")return this.relative();if(this.#relativePosix!==void 0)return this.#relativePosix;let name=this.name,p=this.parent;if(!p)return this.#relativePosix=this.fullpathPosix();let pv=p.relativePosix();return pv+(!pv||!p.parent?"":"/")+name}fullpath(){if(this.#fullpath!==void 0)return this.#fullpath;let name=this.name,p=this.parent;if(!p)return this.#fullpath=this.name;let fp=p.fullpath()+(p.parent?this.sep:"")+name;return this.#fullpath=fp}fullpathPosix(){if(this.#fullpathPosix!==void 0)return this.#fullpathPosix;if(this.sep==="/")return this.#fullpathPosix=this.fullpath();if(!this.parent){let p2=this.fullpath().replace(/\\/g,"/");return /^[a-z]:\//i.test(p2)?this.#fullpathPosix=`//?/${p2}`:this.#fullpathPosix=p2}let p=this.parent,pfpp=p.fullpathPosix(),fpp=pfpp+(!pfpp||!p.parent?"":"/")+this.name;return this.#fullpathPosix=fpp}isUnknown(){return (this.#type&IFMT)===UNKNOWN}isType(type){return this[`is${type}`]()}getType(){return this.isUnknown()?"Unknown":this.isDirectory()?"Directory":this.isFile()?"File":this.isSymbolicLink()?"SymbolicLink":this.isFIFO()?"FIFO":this.isCharacterDevice()?"CharacterDevice":this.isBlockDevice()?"BlockDevice":this.isSocket()?"Socket":"Unknown"}isFile(){return (this.#type&IFMT)===IFREG}isDirectory(){return (this.#type&IFMT)===IFDIR}isCharacterDevice(){return (this.#type&IFMT)===IFCHR}isBlockDevice(){return (this.#type&IFMT)===IFBLK}isFIFO(){return (this.#type&IFMT)===IFIFO}isSocket(){return (this.#type&IFMT)===IFSOCK}isSymbolicLink(){return (this.#type&IFLNK)===IFLNK}lstatCached(){return this.#type&LSTAT_CALLED?this:void 0}readlinkCached(){return this.#linkTarget}realpathCached(){return this.#realpath}readdirCached(){let children=this.children();return children.slice(0,children.provisional)}canReadlink(){if(this.#linkTarget)return !0;if(!this.parent)return !1;let ifmt=this.#type&IFMT;return !(ifmt!==UNKNOWN&&ifmt!==IFLNK||this.#type&ENOREADLINK||this.#type&ENOENT)}calledReaddir(){return !!(this.#type&READDIR_CALLED)}isENOENT(){return !!(this.#type&ENOENT)}isNamed(n){return this.nocase?this.#matchName===normalizeNocase(n):this.#matchName===normalize(n)}async readlink(){let target=this.#linkTarget;if(target)return target;if(this.canReadlink()&&this.parent)try{let read=await this.#fs.promises.readlink(this.fullpath()),linkTarget=this.parent.resolve(read);if(linkTarget)return this.#linkTarget=linkTarget}catch(er){this.#readlinkFail(er.code);return}}readlinkSync(){let target=this.#linkTarget;if(target)return target;if(this.canReadlink()&&this.parent)try{let read=this.#fs.readlinkSync(this.fullpath()),linkTarget=this.parent.resolve(read);if(linkTarget)return this.#linkTarget=linkTarget}catch(er){this.#readlinkFail(er.code);return}}#readdirSuccess(children){this.#type|=READDIR_CALLED;for(let p=children.provisional;p<children.length;p++)children[p].#markENOENT();}#markENOENT(){this.#type&ENOENT||(this.#type=(this.#type|ENOENT)&IFMT_UNKNOWN,this.#markChildrenENOENT());}#markChildrenENOENT(){let children=this.children();children.provisional=0;for(let p of children)p.#markENOENT();}#markENOREALPATH(){this.#type|=ENOREALPATH,this.#markENOTDIR();}#markENOTDIR(){if(this.#type&ENOTDIR)return;let t=this.#type;(t&IFMT)===IFDIR&&(t&=IFMT_UNKNOWN),this.#type=t|ENOTDIR,this.#markChildrenENOENT();}#readdirFail(code=""){code==="ENOTDIR"||code==="EPERM"?this.#markENOTDIR():code==="ENOENT"?this.#markENOENT():this.children().provisional=0;}#lstatFail(code=""){code==="ENOTDIR"?this.parent.#markENOTDIR():code==="ENOENT"&&this.#markENOENT();}#readlinkFail(code=""){let ter=this.#type;ter|=ENOREADLINK,code==="ENOENT"&&(ter|=ENOENT),(code==="EINVAL"||code==="UNKNOWN")&&(ter&=IFMT_UNKNOWN),this.#type=ter,code==="ENOTDIR"&&this.parent&&this.parent.#markENOTDIR();}#readdirAddChild(e,c){return this.#readdirMaybePromoteChild(e,c)||this.#readdirAddNewChild(e,c)}#readdirAddNewChild(e,c){let type=entToType(e),child=this.newChild(e.name,type,{parent:this}),ifmt=child.#type&IFMT;return ifmt!==IFDIR&&ifmt!==IFLNK&&ifmt!==UNKNOWN&&(child.#type|=ENOTDIR),c.unshift(child),c.provisional++,child}#readdirMaybePromoteChild(e,c){for(let p=c.provisional;p<c.length;p++){let pchild=c[p];if((this.nocase?normalizeNocase(e.name):normalize(e.name))===pchild.#matchName)return this.#readdirPromoteChild(e,pchild,p,c)}}#readdirPromoteChild(e,p,index,c){let v=p.name;return p.#type=p.#type&IFMT_UNKNOWN|entToType(e),v!==e.name&&(p.name=e.name),index!==c.provisional&&(index===c.length-1?c.pop():c.splice(index,1),c.unshift(p)),c.provisional++,p}async lstat(){if(!(this.#type&ENOENT))try{return this.#applyStat(await this.#fs.promises.lstat(this.fullpath())),this}catch(er){this.#lstatFail(er.code);}}lstatSync(){if(!(this.#type&ENOENT))try{return this.#applyStat(this.#fs.lstatSync(this.fullpath())),this}catch(er){this.#lstatFail(er.code);}}#applyStat(st){let{atime,atimeMs,birthtime,birthtimeMs,blksize,blocks,ctime,ctimeMs,dev,gid,ino,mode,mtime,mtimeMs,nlink,rdev,size,uid}=st;this.#atime=atime,this.#atimeMs=atimeMs,this.#birthtime=birthtime,this.#birthtimeMs=birthtimeMs,this.#blksize=blksize,this.#blocks=blocks,this.#ctime=ctime,this.#ctimeMs=ctimeMs,this.#dev=dev,this.#gid=gid,this.#ino=ino,this.#mode=mode,this.#mtime=mtime,this.#mtimeMs=mtimeMs,this.#nlink=nlink,this.#rdev=rdev,this.#size=size,this.#uid=uid;let ifmt=entToType(st);this.#type=this.#type&IFMT_UNKNOWN|ifmt|LSTAT_CALLED,ifmt!==UNKNOWN&&ifmt!==IFDIR&&ifmt!==IFLNK&&(this.#type|=ENOTDIR);}#onReaddirCB=[];#readdirCBInFlight=!1;#callOnReaddirCB(children){this.#readdirCBInFlight=!1;let cbs=this.#onReaddirCB.slice();this.#onReaddirCB.length=0,cbs.forEach(cb=>cb(null,children));}readdirCB(cb,allowZalgo=!1){if(!this.canReaddir()){allowZalgo?cb(null,[]):queueMicrotask(()=>cb(null,[]));return}let children=this.children();if(this.calledReaddir()){let c=children.slice(0,children.provisional);allowZalgo?cb(null,c):queueMicrotask(()=>cb(null,c));return}if(this.#onReaddirCB.push(cb),this.#readdirCBInFlight)return;this.#readdirCBInFlight=!0;let fullpath=this.fullpath();this.#fs.readdir(fullpath,{withFileTypes:!0},(er,entries)=>{if(er)this.#readdirFail(er.code),children.provisional=0;else {for(let e of entries)this.#readdirAddChild(e,children);this.#readdirSuccess(children);}this.#callOnReaddirCB(children.slice(0,children.provisional));});}#asyncReaddirInFlight;async readdir(){if(!this.canReaddir())return [];let children=this.children();if(this.calledReaddir())return children.slice(0,children.provisional);let fullpath=this.fullpath();if(this.#asyncReaddirInFlight)await this.#asyncReaddirInFlight;else {let resolve3=()=>{};this.#asyncReaddirInFlight=new Promise(res=>resolve3=res);try{for(let e of await this.#fs.promises.readdir(fullpath,{withFileTypes:!0}))this.#readdirAddChild(e,children);this.#readdirSuccess(children);}catch(er){this.#readdirFail(er.code),children.provisional=0;}this.#asyncReaddirInFlight=void 0,resolve3();}return children.slice(0,children.provisional)}readdirSync(){if(!this.canReaddir())return [];let children=this.children();if(this.calledReaddir())return children.slice(0,children.provisional);let fullpath=this.fullpath();try{for(let e of this.#fs.readdirSync(fullpath,{withFileTypes:!0}))this.#readdirAddChild(e,children);this.#readdirSuccess(children);}catch(er){this.#readdirFail(er.code),children.provisional=0;}return children.slice(0,children.provisional)}canReaddir(){if(this.#type&ENOCHILD)return !1;let ifmt=IFMT&this.#type;return ifmt===UNKNOWN||ifmt===IFDIR||ifmt===IFLNK}shouldWalk(dirs,walkFilter){return (this.#type&IFDIR)===IFDIR&&!(this.#type&ENOCHILD)&&!dirs.has(this)&&(!walkFilter||walkFilter(this))}async realpath(){if(this.#realpath)return this.#realpath;if(!((ENOREALPATH|ENOREADLINK|ENOENT)&this.#type))try{let rp=await this.#fs.promises.realpath(this.fullpath());return this.#realpath=this.resolve(rp)}catch{this.#markENOREALPATH();}}realpathSync(){if(this.#realpath)return this.#realpath;if(!((ENOREALPATH|ENOREADLINK|ENOENT)&this.#type))try{let rp=this.#fs.realpathSync(this.fullpath());return this.#realpath=this.resolve(rp)}catch{this.#markENOREALPATH();}}[setAsCwd](oldCwd){if(oldCwd===this)return;let changed=new Set([]),rp=[],p=this;for(;p&&p.parent;)changed.add(p),p.#relative=rp.join(this.sep),p.#relativePosix=rp.join("/"),p=p.parent,rp.push("..");for(p=oldCwd;p&&p.parent&&!changed.has(p);)p.#relative=void 0,p.#relativePosix=void 0,p=p.parent;}},PathWin32=class _PathWin32 extends PathBase{sep="\\";splitSep=eitherSep;constructor(name,type=UNKNOWN,root,roots,nocase,children,opts){super(name,type,root,roots,nocase,children,opts);}newChild(name,type=UNKNOWN,opts={}){return new _PathWin32(name,type,this.root,this.roots,this.nocase,this.childrenCache(),opts)}getRootString(path7){return win32.parse(path7).root}getRoot(rootPath){if(rootPath=uncToDrive(rootPath.toUpperCase()),rootPath===this.root.name)return this.root;for(let[compare,root]of Object.entries(this.roots))if(this.sameRoot(rootPath,compare))return this.roots[rootPath]=root;return this.roots[rootPath]=new PathScurryWin32(rootPath,this).root}sameRoot(rootPath,compare=this.root.name){return rootPath=rootPath.toUpperCase().replace(/\//g,"\\").replace(uncDriveRegexp,"$1\\"),rootPath===compare}},PathPosix=class _PathPosix extends PathBase{splitSep="/";sep="/";constructor(name,type=UNKNOWN,root,roots,nocase,children,opts){super(name,type,root,roots,nocase,children,opts);}getRootString(path7){return path7.startsWith("/")?"/":""}getRoot(_rootPath){return this.root}newChild(name,type=UNKNOWN,opts={}){return new _PathPosix(name,type,this.root,this.roots,this.nocase,this.childrenCache(),opts)}},PathScurryBase=class{root;rootPath;roots;cwd;#resolveCache;#resolvePosixCache;#children;nocase;#fs;constructor(cwd=process.cwd(),pathImpl,sep2,{nocase,childrenCacheSize=16*1024,fs:fs3=defaultFS}={}){this.#fs=fsFromOption(fs3),(cwd instanceof URL||cwd.startsWith("file://"))&&(cwd=fileURLToPath(cwd));let cwdPath=pathImpl.resolve(cwd);this.roots=Object.create(null),this.rootPath=this.parseRootPath(cwdPath),this.#resolveCache=new ResolveCache,this.#resolvePosixCache=new ResolveCache,this.#children=new ChildrenCache(childrenCacheSize);let split=cwdPath.substring(this.rootPath.length).split(sep2);if(split.length===1&&!split[0]&&split.pop(),nocase===void 0)throw new TypeError("must provide nocase setting to PathScurryBase ctor");this.nocase=nocase,this.root=this.newRoot(this.#fs),this.roots[this.rootPath]=this.root;let prev=this.root,len=split.length-1,joinSep=pathImpl.sep,abs=this.rootPath,sawFirst=!1;for(let part of split){let l=len--;prev=prev.child(part,{relative:new Array(l).fill("..").join(joinSep),relativePosix:new Array(l).fill("..").join("/"),fullpath:abs+=(sawFirst?"":joinSep)+part}),sawFirst=!0;}this.cwd=prev;}depth(path7=this.cwd){return typeof path7=="string"&&(path7=this.cwd.resolve(path7)),path7.depth()}childrenCache(){return this.#children}resolve(...paths){let r="";for(let i=paths.length-1;i>=0;i--){let p=paths[i];if(!(!p||p===".")&&(r=r?`${p}/${r}`:p,this.isAbsolute(p)))break}let cached=this.#resolveCache.get(r);if(cached!==void 0)return cached;let result=this.cwd.resolve(r).fullpath();return this.#resolveCache.set(r,result),result}resolvePosix(...paths){let r="";for(let i=paths.length-1;i>=0;i--){let p=paths[i];if(!(!p||p===".")&&(r=r?`${p}/${r}`:p,this.isAbsolute(p)))break}let cached=this.#resolvePosixCache.get(r);if(cached!==void 0)return cached;let result=this.cwd.resolve(r).fullpathPosix();return this.#resolvePosixCache.set(r,result),result}relative(entry=this.cwd){return typeof entry=="string"&&(entry=this.cwd.resolve(entry)),entry.relative()}relativePosix(entry=this.cwd){return typeof entry=="string"&&(entry=this.cwd.resolve(entry)),entry.relativePosix()}basename(entry=this.cwd){return typeof entry=="string"&&(entry=this.cwd.resolve(entry)),entry.name}dirname(entry=this.cwd){return typeof entry=="string"&&(entry=this.cwd.resolve(entry)),(entry.parent||entry).fullpath()}async readdir(entry=this.cwd,opts={withFileTypes:!0}){typeof entry=="string"?entry=this.cwd.resolve(entry):entry instanceof PathBase||(opts=entry,entry=this.cwd);let{withFileTypes}=opts;if(entry.canReaddir()){let p=await entry.readdir();return withFileTypes?p:p.map(e=>e.name)}else return []}readdirSync(entry=this.cwd,opts={withFileTypes:!0}){typeof entry=="string"?entry=this.cwd.resolve(entry):entry instanceof PathBase||(opts=entry,entry=this.cwd);let{withFileTypes=!0}=opts;return entry.canReaddir()?withFileTypes?entry.readdirSync():entry.readdirSync().map(e=>e.name):[]}async lstat(entry=this.cwd){return typeof entry=="string"&&(entry=this.cwd.resolve(entry)),entry.lstat()}lstatSync(entry=this.cwd){return typeof entry=="string"&&(entry=this.cwd.resolve(entry)),entry.lstatSync()}async readlink(entry=this.cwd,{withFileTypes}={withFileTypes:!1}){typeof entry=="string"?entry=this.cwd.resolve(entry):entry instanceof PathBase||(withFileTypes=entry.withFileTypes,entry=this.cwd);let e=await entry.readlink();return withFileTypes?e:e?.fullpath()}readlinkSync(entry=this.cwd,{withFileTypes}={withFileTypes:!1}){typeof entry=="string"?entry=this.cwd.resolve(entry):entry instanceof PathBase||(withFileTypes=entry.withFileTypes,entry=this.cwd);let e=entry.readlinkSync();return withFileTypes?e:e?.fullpath()}async realpath(entry=this.cwd,{withFileTypes}={withFileTypes:!1}){typeof entry=="string"?entry=this.cwd.resolve(entry):entry instanceof PathBase||(withFileTypes=entry.withFileTypes,entry=this.cwd);let e=await entry.realpath();return withFileTypes?e:e?.fullpath()}realpathSync(entry=this.cwd,{withFileTypes}={withFileTypes:!1}){typeof entry=="string"?entry=this.cwd.resolve(entry):entry instanceof PathBase||(withFileTypes=entry.withFileTypes,entry=this.cwd);let e=entry.realpathSync();return withFileTypes?e:e?.fullpath()}async walk(entry=this.cwd,opts={}){typeof entry=="string"?entry=this.cwd.resolve(entry):entry instanceof PathBase||(opts=entry,entry=this.cwd);let{withFileTypes=!0,follow=!1,filter:filter2,walkFilter}=opts,results=[];(!filter2||filter2(entry))&&results.push(withFileTypes?entry:entry.fullpath());let dirs=new Set,walk=(dir,cb)=>{dirs.add(dir),dir.readdirCB((er,entries)=>{if(er)return cb(er);let len=entries.length;if(!len)return cb();let next=()=>{--len===0&&cb();};for(let e of entries)(!filter2||filter2(e))&&results.push(withFileTypes?e:e.fullpath()),follow&&e.isSymbolicLink()?e.realpath().then(r=>r?.isUnknown()?r.lstat():r).then(r=>r?.shouldWalk(dirs,walkFilter)?walk(r,next):next()):e.shouldWalk(dirs,walkFilter)?walk(e,next):next();},!0);},start2=entry;return new Promise((res,rej)=>{walk(start2,er=>{if(er)return rej(er);res(results);});})}walkSync(entry=this.cwd,opts={}){typeof entry=="string"?entry=this.cwd.resolve(entry):entry instanceof PathBase||(opts=entry,entry=this.cwd);let{withFileTypes=!0,follow=!1,filter:filter2,walkFilter}=opts,results=[];(!filter2||filter2(entry))&&results.push(withFileTypes?entry:entry.fullpath());let dirs=new Set([entry]);for(let dir of dirs){let entries=dir.readdirSync();for(let e of entries){(!filter2||filter2(e))&&results.push(withFileTypes?e:e.fullpath());let r=e;if(e.isSymbolicLink()){if(!(follow&&(r=e.realpathSync())))continue;r.isUnknown()&&r.lstatSync();}r.shouldWalk(dirs,walkFilter)&&dirs.add(r);}}return results}[Symbol.asyncIterator](){return this.iterate()}iterate(entry=this.cwd,options={}){return typeof entry=="string"?entry=this.cwd.resolve(entry):entry instanceof PathBase||(options=entry,entry=this.cwd),this.stream(entry,options)[Symbol.asyncIterator]()}[Symbol.iterator](){return this.iterateSync()}*iterateSync(entry=this.cwd,opts={}){typeof entry=="string"?entry=this.cwd.resolve(entry):entry instanceof PathBase||(opts=entry,entry=this.cwd);let{withFileTypes=!0,follow=!1,filter:filter2,walkFilter}=opts;(!filter2||filter2(entry))&&(yield withFileTypes?entry:entry.fullpath());let dirs=new Set([entry]);for(let dir of dirs){let entries=dir.readdirSync();for(let e of entries){(!filter2||filter2(e))&&(yield withFileTypes?e:e.fullpath());let r=e;if(e.isSymbolicLink()){if(!(follow&&(r=e.realpathSync())))continue;r.isUnknown()&&r.lstatSync();}r.shouldWalk(dirs,walkFilter)&&dirs.add(r);}}}stream(entry=this.cwd,opts={}){typeof entry=="string"?entry=this.cwd.resolve(entry):entry instanceof PathBase||(opts=entry,entry=this.cwd);let{withFileTypes=!0,follow=!1,filter:filter2,walkFilter}=opts,results=new Minipass({objectMode:!0});(!filter2||filter2(entry))&&results.write(withFileTypes?entry:entry.fullpath());let dirs=new Set,queue=[entry],processing=0,process2=()=>{let paused=!1;for(;!paused;){let dir=queue.shift();if(!dir){processing===0&&results.end();return}processing++,dirs.add(dir);let onReaddir=(er,entries,didRealpaths=!1)=>{if(er)return results.emit("error",er);if(follow&&!didRealpaths){let promises=[];for(let e of entries)e.isSymbolicLink()&&promises.push(e.realpath().then(r=>r?.isUnknown()?r.lstat():r));if(promises.length){Promise.all(promises).then(()=>onReaddir(null,entries,!0));return}}for(let e of entries)e&&(!filter2||filter2(e))&&(results.write(withFileTypes?e:e.fullpath())||(paused=!0));processing--;for(let e of entries){let r=e.realpathCached()||e;r.shouldWalk(dirs,walkFilter)&&queue.push(r);}paused&&!results.flowing?results.once("drain",process2):sync2||process2();},sync2=!0;dir.readdirCB(onReaddir,!0),sync2=!1;}};return process2(),results}streamSync(entry=this.cwd,opts={}){typeof entry=="string"?entry=this.cwd.resolve(entry):entry instanceof PathBase||(opts=entry,entry=this.cwd);let{withFileTypes=!0,follow=!1,filter:filter2,walkFilter}=opts,results=new Minipass({objectMode:!0}),dirs=new Set;(!filter2||filter2(entry))&&results.write(withFileTypes?entry:entry.fullpath());let queue=[entry],processing=0,process2=()=>{let paused=!1;for(;!paused;){let dir=queue.shift();if(!dir){processing===0&&results.end();return}processing++,dirs.add(dir);let entries=dir.readdirSync();for(let e of entries)(!filter2||filter2(e))&&(results.write(withFileTypes?e:e.fullpath())||(paused=!0));processing--;for(let e of entries){let r=e;if(e.isSymbolicLink()){if(!(follow&&(r=e.realpathSync())))continue;r.isUnknown()&&r.lstatSync();}r.shouldWalk(dirs,walkFilter)&&queue.push(r);}}paused&&!results.flowing&&results.once("drain",process2);};return process2(),results}chdir(path7=this.cwd){let oldCwd=this.cwd;this.cwd=typeof path7=="string"?this.cwd.resolve(path7):path7,this.cwd[setAsCwd](oldCwd);}},PathScurryWin32=class extends PathScurryBase{sep="\\";constructor(cwd=process.cwd(),opts={}){let{nocase=!0}=opts;super(cwd,win32,"\\",{...opts,nocase}),this.nocase=nocase;for(let p=this.cwd;p;p=p.parent)p.nocase=this.nocase;}parseRootPath(dir){return win32.parse(dir).root.toUpperCase()}newRoot(fs3){return new PathWin32(this.rootPath,IFDIR,void 0,this.roots,this.nocase,this.childrenCache(),{fs:fs3})}isAbsolute(p){return p.startsWith("/")||p.startsWith("\\")||/^[a-z]:(\/|\\)/i.test(p)}},PathScurryPosix=class extends PathScurryBase{sep="/";constructor(cwd=process.cwd(),opts={}){let{nocase=!1}=opts;super(cwd,posix,"/",{...opts,nocase}),this.nocase=nocase;}parseRootPath(_dir){return "/"}newRoot(fs3){return new PathPosix(this.rootPath,IFDIR,void 0,this.roots,this.nocase,this.childrenCache(),{fs:fs3})}isAbsolute(p){return p.startsWith("/")}},PathScurryDarwin=class extends PathScurryPosix{constructor(cwd=process.cwd(),opts={}){let{nocase=!0}=opts;super(cwd,{...opts,nocase});}};process.platform==="win32"?PathWin32:PathPosix;var PathScurry=process.platform==="win32"?PathScurryWin32:process.platform==="darwin"?PathScurryDarwin:PathScurryPosix;var isPatternList=pl=>pl.length>=1,isGlobList=gl=>gl.length>=1,Pattern=class _Pattern{#patternList;#globList;#index;length;#platform;#rest;#globString;#isDrive;#isUNC;#isAbsolute;#followGlobstar=!0;constructor(patternList,globList,index,platform){if(!isPatternList(patternList))throw new TypeError("empty pattern list");if(!isGlobList(globList))throw new TypeError("empty glob list");if(globList.length!==patternList.length)throw new TypeError("mismatched pattern list and glob list lengths");if(this.length=patternList.length,index<0||index>=this.length)throw new TypeError("index out of range");if(this.#patternList=patternList,this.#globList=globList,this.#index=index,this.#platform=platform,this.#index===0){if(this.isUNC()){let[p0,p1,p2,p3,...prest]=this.#patternList,[g0,g1,g2,g3,...grest]=this.#globList;prest[0]===""&&(prest.shift(),grest.shift());let p=[p0,p1,p2,p3,""].join("/"),g=[g0,g1,g2,g3,""].join("/");this.#patternList=[p,...prest],this.#globList=[g,...grest],this.length=this.#patternList.length;}else if(this.isDrive()||this.isAbsolute()){let[p1,...prest]=this.#patternList,[g1,...grest]=this.#globList;prest[0]===""&&(prest.shift(),grest.shift());let p=p1+"/",g=g1+"/";this.#patternList=[p,...prest],this.#globList=[g,...grest],this.length=this.#patternList.length;}}}pattern(){return this.#patternList[this.#index]}isString(){return typeof this.#patternList[this.#index]=="string"}isGlobstar(){return this.#patternList[this.#index]===GLOBSTAR}isRegExp(){return this.#patternList[this.#index]instanceof RegExp}globString(){return this.#globString=this.#globString||(this.#index===0?this.isAbsolute()?this.#globList[0]+this.#globList.slice(1).join("/"):this.#globList.join("/"):this.#globList.slice(this.#index).join("/"))}hasMore(){return this.length>this.#index+1}rest(){return this.#rest!==void 0?this.#rest:this.hasMore()?(this.#rest=new _Pattern(this.#patternList,this.#globList,this.#index+1,this.#platform),this.#rest.#isAbsolute=this.#isAbsolute,this.#rest.#isUNC=this.#isUNC,this.#rest.#isDrive=this.#isDrive,this.#rest):this.#rest=null}isUNC(){let pl=this.#patternList;return this.#isUNC!==void 0?this.#isUNC:this.#isUNC=this.#platform==="win32"&&this.#index===0&&pl[0]===""&&pl[1]===""&&typeof pl[2]=="string"&&!!pl[2]&&typeof pl[3]=="string"&&!!pl[3]}isDrive(){let pl=this.#patternList;return this.#isDrive!==void 0?this.#isDrive:this.#isDrive=this.#platform==="win32"&&this.#index===0&&this.length>1&&typeof pl[0]=="string"&&/^[a-z]:$/i.test(pl[0])}isAbsolute(){let pl=this.#patternList;return this.#isAbsolute!==void 0?this.#isAbsolute:this.#isAbsolute=pl[0]===""&&pl.length>1||this.isDrive()||this.isUNC()}root(){let p=this.#patternList[0];return typeof p=="string"&&this.isAbsolute()&&this.#index===0?p:""}checkFollowGlobstar(){return !(this.#index===0||!this.isGlobstar()||!this.#followGlobstar)}markFollowGlobstar(){return this.#index===0||!this.isGlobstar()||!this.#followGlobstar?!1:(this.#followGlobstar=!1,!0)}};var defaultPlatform2=typeof process=="object"&&process&&typeof process.platform=="string"?process.platform:"linux",Ignore=class{relative;relativeChildren;absolute;absoluteChildren;constructor(ignored,{nobrace,nocase,noext,noglobstar,platform=defaultPlatform2}){this.relative=[],this.absolute=[],this.relativeChildren=[],this.absoluteChildren=[];let mmopts={dot:!0,nobrace,nocase,noext,noglobstar,optimizationLevel:2,platform,nocomment:!0,nonegate:!0};for(let ign of ignored){let mm=new Minimatch(ign,mmopts);for(let i=0;i<mm.set.length;i++){let parsed=mm.set[i],globParts=mm.globParts[i];if(!parsed||!globParts)throw new Error("invalid pattern object");let p=new Pattern(parsed,globParts,0,platform),m=new Minimatch(p.globString(),mmopts),children=globParts[globParts.length-1]==="**",absolute=p.isAbsolute();absolute?this.absolute.push(m):this.relative.push(m),children&&(absolute?this.absoluteChildren.push(m):this.relativeChildren.push(m));}}}ignored(p){let fullpath=p.fullpath(),fullpaths=`${fullpath}/`,relative4=p.relative()||".",relatives=`${relative4}/`;for(let m of this.relative)if(m.match(relative4)||m.match(relatives))return !0;for(let m of this.absolute)if(m.match(fullpath)||m.match(fullpaths))return !0;return !1}childrenIgnored(p){let fullpath=p.fullpath()+"/",relative4=(p.relative()||".")+"/";for(let m of this.relativeChildren)if(m.match(relative4))return !0;for(let m of this.absoluteChildren)if(m.match(fullpath))return !0;return !1}};var HasWalkedCache=class _HasWalkedCache{store;constructor(store=new Map){this.store=store;}copy(){return new _HasWalkedCache(new Map(this.store))}hasWalked(target,pattern){return this.store.get(target.fullpath())?.has(pattern.globString())}storeWalked(target,pattern){let fullpath=target.fullpath(),cached=this.store.get(fullpath);cached?cached.add(pattern.globString()):this.store.set(fullpath,new Set([pattern.globString()]));}},MatchRecord=class{store=new Map;add(target,absolute,ifDir){let n=(absolute?2:0)|(ifDir?1:0),current=this.store.get(target);this.store.set(target,current===void 0?n:n&current);}entries(){return [...this.store.entries()].map(([path7,n])=>[path7,!!(n&2),!!(n&1)])}},SubWalks=class{store=new Map;add(target,pattern){if(!target.canReaddir())return;let subs=this.store.get(target);subs?subs.find(p=>p.globString()===pattern.globString())||subs.push(pattern):this.store.set(target,[pattern]);}get(target){let subs=this.store.get(target);if(!subs)throw new Error("attempting to walk unknown path");return subs}entries(){return this.keys().map(k=>[k,this.store.get(k)])}keys(){return [...this.store.keys()].filter(t=>t.canReaddir())}},Processor=class _Processor{hasWalkedCache;matches=new MatchRecord;subwalks=new SubWalks;patterns;follow;dot;opts;constructor(opts,hasWalkedCache){this.opts=opts,this.follow=!!opts.follow,this.dot=!!opts.dot,this.hasWalkedCache=hasWalkedCache?hasWalkedCache.copy():new HasWalkedCache;}processPatterns(target,patterns){this.patterns=patterns;let processingSet=patterns.map(p=>[target,p]);for(let[t,pattern]of processingSet){this.hasWalkedCache.storeWalked(t,pattern);let root=pattern.root(),absolute=pattern.isAbsolute()&&this.opts.absolute!==!1;if(root){t=t.resolve(root==="/"&&this.opts.root!==void 0?this.opts.root:root);let rest2=pattern.rest();if(rest2)pattern=rest2;else {this.matches.add(t,!0,!1);continue}}if(t.isENOENT())continue;let p,rest,changed=!1;for(;typeof(p=pattern.pattern())=="string"&&(rest=pattern.rest());)t=t.resolve(p),pattern=rest,changed=!0;if(p=pattern.pattern(),rest=pattern.rest(),changed){if(this.hasWalkedCache.hasWalked(t,pattern))continue;this.hasWalkedCache.storeWalked(t,pattern);}if(typeof p=="string"){let ifDir=p===".."||p===""||p===".";this.matches.add(t.resolve(p),absolute,ifDir);continue}else if(p===GLOBSTAR){(!t.isSymbolicLink()||this.follow||pattern.checkFollowGlobstar())&&this.subwalks.add(t,pattern);let rp=rest?.pattern(),rrest=rest?.rest();if(!rest||(rp===""||rp===".")&&!rrest)this.matches.add(t,absolute,rp===""||rp===".");else if(rp===".."){let tp=t.parent||t;rrest?this.hasWalkedCache.hasWalked(tp,rrest)||this.subwalks.add(tp,rrest):this.matches.add(tp,absolute,!0);}}else p instanceof RegExp&&this.subwalks.add(t,pattern);}return this}subwalkTargets(){return this.subwalks.keys()}child(){return new _Processor(this.opts,this.hasWalkedCache)}filterEntries(parent,entries){let patterns=this.subwalks.get(parent),results=this.child();for(let e of entries)for(let pattern of patterns){let absolute=pattern.isAbsolute(),p=pattern.pattern(),rest=pattern.rest();p===GLOBSTAR?results.testGlobstar(e,pattern,rest,absolute):p instanceof RegExp?results.testRegExp(e,p,rest,absolute):results.testString(e,p,rest,absolute);}return results}testGlobstar(e,pattern,rest,absolute){if((this.dot||!e.name.startsWith("."))&&(pattern.hasMore()||this.matches.add(e,absolute,!1),e.canReaddir()&&(this.follow||!e.isSymbolicLink()?this.subwalks.add(e,pattern):e.isSymbolicLink()&&(rest&&pattern.checkFollowGlobstar()?this.subwalks.add(e,rest):pattern.markFollowGlobstar()&&this.subwalks.add(e,pattern)))),rest){let rp=rest.pattern();if(typeof rp=="string"&&rp!==".."&&rp!==""&&rp!==".")this.testString(e,rp,rest.rest(),absolute);else if(rp===".."){let ep=e.parent||e;this.subwalks.add(ep,rest);}else rp instanceof RegExp&&this.testRegExp(e,rp,rest.rest(),absolute);}}testRegExp(e,p,rest,absolute){p.test(e.name)&&(rest?this.subwalks.add(e,rest):this.matches.add(e,absolute,!1));}testString(e,p,rest,absolute){e.isNamed(p)&&(rest?this.subwalks.add(e,rest):this.matches.add(e,absolute,!1));}};var makeIgnore=(ignore,opts)=>typeof ignore=="string"?new Ignore([ignore],opts):Array.isArray(ignore)?new Ignore(ignore,opts):ignore,GlobUtil=class{path;patterns;opts;seen=new Set;paused=!1;aborted=!1;#onResume=[];#ignore;#sep;signal;maxDepth;constructor(patterns,path7,opts){this.patterns=patterns,this.path=path7,this.opts=opts,this.#sep=!opts.posix&&opts.platform==="win32"?"\\":"/",opts.ignore&&(this.#ignore=makeIgnore(opts.ignore,opts)),this.maxDepth=opts.maxDepth||1/0,opts.signal&&(this.signal=opts.signal,this.signal.addEventListener("abort",()=>{this.#onResume.length=0;}));}#ignored(path7){return this.seen.has(path7)||!!this.#ignore?.ignored?.(path7)}#childrenIgnored(path7){return !!this.#ignore?.childrenIgnored?.(path7)}pause(){this.paused=!0;}resume(){if(this.signal?.aborted)return;this.paused=!1;let fn;for(;!this.paused&&(fn=this.#onResume.shift());)fn();}onResume(fn){this.signal?.aborted||(this.paused?this.#onResume.push(fn):fn());}async matchCheck(e,ifDir){if(ifDir&&this.opts.nodir)return;let rpc;if(this.opts.realpath){if(rpc=e.realpathCached()||await e.realpath(),!rpc)return;e=rpc;}let needStat=e.isUnknown()||this.opts.stat;return this.matchCheckTest(needStat?await e.lstat():e,ifDir)}matchCheckTest(e,ifDir){return e&&(this.maxDepth===1/0||e.depth()<=this.maxDepth)&&(!ifDir||e.canReaddir())&&(!this.opts.nodir||!e.isDirectory())&&!this.#ignored(e)?e:void 0}matchCheckSync(e,ifDir){if(ifDir&&this.opts.nodir)return;let rpc;if(this.opts.realpath){if(rpc=e.realpathCached()||e.realpathSync(),!rpc)return;e=rpc;}let needStat=e.isUnknown()||this.opts.stat;return this.matchCheckTest(needStat?e.lstatSync():e,ifDir)}matchFinish(e,absolute){if(this.#ignored(e))return;let abs=this.opts.absolute===void 0?absolute:this.opts.absolute;this.seen.add(e);let mark=this.opts.mark&&e.isDirectory()?this.#sep:"";if(this.opts.withFileTypes)this.matchEmit(e);else if(abs){let abs2=this.opts.posix?e.fullpathPosix():e.fullpath();this.matchEmit(abs2+mark);}else {let rel=this.opts.posix?e.relativePosix():e.relative(),pre=this.opts.dotRelative&&!rel.startsWith(".."+this.#sep)?"."+this.#sep:"";this.matchEmit(rel?pre+rel+mark:"."+mark);}}async match(e,absolute,ifDir){let p=await this.matchCheck(e,ifDir);p&&this.matchFinish(p,absolute);}matchSync(e,absolute,ifDir){let p=this.matchCheckSync(e,ifDir);p&&this.matchFinish(p,absolute);}walkCB(target,patterns,cb){this.signal?.aborted&&cb(),this.walkCB2(target,patterns,new Processor(this.opts),cb);}walkCB2(target,patterns,processor,cb){if(this.#childrenIgnored(target))return cb();if(this.signal?.aborted&&cb(),this.paused){this.onResume(()=>this.walkCB2(target,patterns,processor,cb));return}processor.processPatterns(target,patterns);let tasks=1,next=()=>{--tasks===0&&cb();};for(let[m,absolute,ifDir]of processor.matches.entries())this.#ignored(m)||(tasks++,this.match(m,absolute,ifDir).then(()=>next()));for(let t of processor.subwalkTargets()){if(this.maxDepth!==1/0&&t.depth()>=this.maxDepth)continue;tasks++;let childrenCached=t.readdirCached();t.calledReaddir()?this.walkCB3(t,childrenCached,processor,next):t.readdirCB((_,entries)=>this.walkCB3(t,entries,processor,next),!0);}next();}walkCB3(target,entries,processor,cb){processor=processor.filterEntries(target,entries);let tasks=1,next=()=>{--tasks===0&&cb();};for(let[m,absolute,ifDir]of processor.matches.entries())this.#ignored(m)||(tasks++,this.match(m,absolute,ifDir).then(()=>next()));for(let[target2,patterns]of processor.subwalks.entries())tasks++,this.walkCB2(target2,patterns,processor.child(),next);next();}walkCBSync(target,patterns,cb){this.signal?.aborted&&cb(),this.walkCB2Sync(target,patterns,new Processor(this.opts),cb);}walkCB2Sync(target,patterns,processor,cb){if(this.#childrenIgnored(target))return cb();if(this.signal?.aborted&&cb(),this.paused){this.onResume(()=>this.walkCB2Sync(target,patterns,processor,cb));return}processor.processPatterns(target,patterns);let tasks=1,next=()=>{--tasks===0&&cb();};for(let[m,absolute,ifDir]of processor.matches.entries())this.#ignored(m)||this.matchSync(m,absolute,ifDir);for(let t of processor.subwalkTargets()){if(this.maxDepth!==1/0&&t.depth()>=this.maxDepth)continue;tasks++;let children=t.readdirSync();this.walkCB3Sync(t,children,processor,next);}next();}walkCB3Sync(target,entries,processor,cb){processor=processor.filterEntries(target,entries);let tasks=1,next=()=>{--tasks===0&&cb();};for(let[m,absolute,ifDir]of processor.matches.entries())this.#ignored(m)||this.matchSync(m,absolute,ifDir);for(let[target2,patterns]of processor.subwalks.entries())tasks++,this.walkCB2Sync(target2,patterns,processor.child(),next);next();}},GlobWalker=class extends GlobUtil{matches;constructor(patterns,path7,opts){super(patterns,path7,opts),this.matches=new Set;}matchEmit(e){this.matches.add(e);}async walk(){if(this.signal?.aborted)throw this.signal.reason;return this.path.isUnknown()&&await this.path.lstat(),await new Promise((res,rej)=>{this.walkCB(this.path,this.patterns,()=>{this.signal?.aborted?rej(this.signal.reason):res(this.matches);});}),this.matches}walkSync(){if(this.signal?.aborted)throw this.signal.reason;return this.path.isUnknown()&&this.path.lstatSync(),this.walkCBSync(this.path,this.patterns,()=>{if(this.signal?.aborted)throw this.signal.reason}),this.matches}},GlobStream=class extends GlobUtil{results;constructor(patterns,path7,opts){super(patterns,path7,opts),this.results=new Minipass({signal:this.signal,objectMode:!0}),this.results.on("drain",()=>this.resume()),this.results.on("resume",()=>this.resume());}matchEmit(e){this.results.write(e),this.results.flowing||this.pause();}stream(){let target=this.path;return target.isUnknown()?target.lstat().then(()=>{this.walkCB(target,this.patterns,()=>this.results.end());}):this.walkCB(target,this.patterns,()=>this.results.end()),this.results}streamSync(){return this.path.isUnknown()&&this.path.lstatSync(),this.walkCBSync(this.path,this.patterns,()=>this.results.end()),this.results}};var defaultPlatform3=typeof process=="object"&&process&&typeof process.platform=="string"?process.platform:"linux",Glob=class{absolute;cwd;root;dot;dotRelative;follow;ignore;magicalBraces;mark;matchBase;maxDepth;nobrace;nocase;nodir;noext;noglobstar;pattern;platform;realpath;scurry;stat;signal;windowsPathsNoEscape;withFileTypes;opts;patterns;constructor(pattern,opts){if(!opts)throw new TypeError("glob options required");if(this.withFileTypes=!!opts.withFileTypes,this.signal=opts.signal,this.follow=!!opts.follow,this.dot=!!opts.dot,this.dotRelative=!!opts.dotRelative,this.nodir=!!opts.nodir,this.mark=!!opts.mark,opts.cwd?(opts.cwd instanceof URL||opts.cwd.startsWith("file://"))&&(opts.cwd=fileURLToPath(opts.cwd)):this.cwd="",this.cwd=opts.cwd||"",this.root=opts.root,this.magicalBraces=!!opts.magicalBraces,this.nobrace=!!opts.nobrace,this.noext=!!opts.noext,this.realpath=!!opts.realpath,this.absolute=opts.absolute,this.noglobstar=!!opts.noglobstar,this.matchBase=!!opts.matchBase,this.maxDepth=typeof opts.maxDepth=="number"?opts.maxDepth:1/0,this.stat=!!opts.stat,this.ignore=opts.ignore,this.withFileTypes&&this.absolute!==void 0)throw new Error("cannot set absolute and withFileTypes:true");if(typeof pattern=="string"&&(pattern=[pattern]),this.windowsPathsNoEscape=!!opts.windowsPathsNoEscape||opts.allowWindowsEscape===!1,this.windowsPathsNoEscape&&(pattern=pattern.map(p=>p.replace(/\\/g,"/"))),this.matchBase){if(opts.noglobstar)throw new TypeError("base matching requires globstar");pattern=pattern.map(p=>p.includes("/")?p:`./**/${p}`);}if(this.pattern=pattern,this.platform=opts.platform||defaultPlatform3,this.opts={...opts,platform:this.platform},opts.scurry){if(this.scurry=opts.scurry,opts.nocase!==void 0&&opts.nocase!==opts.scurry.nocase)throw new Error("nocase option contradicts provided scurry option")}else {let Scurry=opts.platform==="win32"?PathScurryWin32:opts.platform==="darwin"?PathScurryDarwin:opts.platform?PathScurryPosix:PathScurry;this.scurry=new Scurry(this.cwd,{nocase:opts.nocase,fs:opts.fs});}this.nocase=this.scurry.nocase;let nocaseMagicOnly=this.platform==="darwin"||this.platform==="win32",mmo={...opts,dot:this.dot,matchBase:this.matchBase,nobrace:this.nobrace,nocase:this.nocase,nocaseMagicOnly,nocomment:!0,noext:this.noext,nonegate:!0,optimizationLevel:2,platform:this.platform,windowsPathsNoEscape:this.windowsPathsNoEscape,debug:!!this.opts.debug},mms=this.pattern.map(p=>new Minimatch(p,mmo)),[matchSet,globParts]=mms.reduce((set,m)=>(set[0].push(...m.set),set[1].push(...m.globParts),set),[[],[]]);this.patterns=matchSet.map((set,i)=>{let g=globParts[i];if(!g)throw new Error("invalid pattern object");return new Pattern(set,g,0,this.platform)});}async walk(){return [...await new GlobWalker(this.patterns,this.scurry.cwd,{...this.opts,maxDepth:this.maxDepth!==1/0?this.maxDepth+this.scurry.cwd.depth():1/0,platform:this.platform,nocase:this.nocase}).walk()]}walkSync(){return [...new GlobWalker(this.patterns,this.scurry.cwd,{...this.opts,maxDepth:this.maxDepth!==1/0?this.maxDepth+this.scurry.cwd.depth():1/0,platform:this.platform,nocase:this.nocase}).walkSync()]}stream(){return new GlobStream(this.patterns,this.scurry.cwd,{...this.opts,maxDepth:this.maxDepth!==1/0?this.maxDepth+this.scurry.cwd.depth():1/0,platform:this.platform,nocase:this.nocase}).stream()}streamSync(){return new GlobStream(this.patterns,this.scurry.cwd,{...this.opts,maxDepth:this.maxDepth!==1/0?this.maxDepth+this.scurry.cwd.depth():1/0,platform:this.platform,nocase:this.nocase}).streamSync()}iterateSync(){return this.streamSync()[Symbol.iterator]()}[Symbol.iterator](){return this.iterateSync()}iterate(){return this.stream()[Symbol.asyncIterator]()}[Symbol.asyncIterator](){return this.iterate()}};var hasMagic=(pattern,options={})=>{Array.isArray(pattern)||(pattern=[pattern]);for(let p of pattern)if(new Minimatch(p,options).hasMagic())return !0;return !1};function globStreamSync(pattern,options={}){return new Glob(pattern,options).streamSync()}function globStream(pattern,options={}){return new Glob(pattern,options).stream()}function globSync(pattern,options={}){return new Glob(pattern,options).walkSync()}async function glob_(pattern,options={}){return new Glob(pattern,options).walk()}function globIterateSync(pattern,options={}){return new Glob(pattern,options).iterateSync()}function globIterate(pattern,options={}){return new Glob(pattern,options).iterate()}var streamSync=globStreamSync,stream=Object.assign(globStream,{sync:globStreamSync}),iterateSync=globIterateSync,iterate=Object.assign(globIterate,{sync:globIterateSync}),sync=Object.assign(globSync,{stream:globStreamSync,iterate:globIterateSync}),glob=Object.assign(glob_,{glob:glob_,globSync,sync,globStream,stream,globStreamSync,streamSync,globIterate,iterate,globIterateSync,iterateSync,Glob,hasMagic,escape,unescape});glob.glob=glob;async function listStories(options){let{normalizePath}=await import('vite');return (await Promise.all(normalizeStories(await options.presets.apply("stories",[],options),{configDir:options.configDir,workingDir:options.configDir}).map(({directory,files})=>{let pattern=path2.join(directory,files),absolutePattern=path2.isAbsolute(pattern)?pattern:path2.join(options.configDir,pattern);return glob(slash(absolutePattern),{...commonGlobOptions(absolutePattern),follow:!0})}))).reduce((carry,stories)=>carry.concat(stories.map(normalizePath)),[]).sort()}function toImportPath(relativePath){return relativePath.startsWith("../")?relativePath:`./${relativePath}`}async function toImportFn(stories){let{normalizePath}=await import('vite');return `
    const importers = {
      ${stories.map(file=>{let relativePath=normalizePath(path2.relative(process.cwd(),file));return `  '${toImportPath(relativePath)}': async () => import('/@fs/${file}')`}).join(`,
`)}
    };

    export async function importFn(path) {
        return importers[path]();
    }
  `}async function generateImportFnScriptCode(options){let stories=await listStories(options);return (await toImportFn(stories)).trim()}async function generateAddonSetupCode(){return `
    import { createBrowserChannel } from 'storybook/internal/channels';
    import { addons } from 'storybook/internal/preview-api';

    const channel = createBrowserChannel({ page: 'preview' });
    addons.setChannel(channel);
    window.__STORYBOOK_ADDONS_CHANNEL__ = channel;
    
    if (window.CONFIG_TYPE === 'DEVELOPMENT'){
      window.__STORYBOOK_SERVER_CHANNEL__ = channel;
    }
  `.trim()}function codeGeneratorPlugin(options){let iframePath=__require.resolve("@storybook/builder-vite/input/iframe.html"),iframeId,projectRoot;return {name:"storybook:code-generator-plugin",enforce:"pre",configureServer(server2){server2.watcher.on("change",()=>{let appModule=server2.moduleGraph.getModuleById(virtualFileId);appModule&&server2.moduleGraph.invalidateModule(appModule);let storiesModule=server2.moduleGraph.getModuleById(virtualStoriesFile);storiesModule&&server2.moduleGraph.invalidateModule(storiesModule);}),server2.watcher.on("add",path7=>{(/\.stories\.([tj])sx?$/.test(path7)||/\.mdx$/.test(path7))&&server2.watcher.emit("change",virtualStoriesFile);});},config(config,{command}){command==="build"&&(config.build||(config.build={}),config.build.rollupOptions={...config.build.rollupOptions,input:iframePath});},configResolved(config){projectRoot=config.root,iframeId=`${config.root}/iframe.html`;},resolveId(source){if(source===virtualFileId)return virtualFileId;if(source===iframePath)return iframeId;if(source===virtualStoriesFile)return virtualStoriesFile;if(source===virtualPreviewFile)return virtualPreviewFile;if(source===virtualAddonSetupFile)return virtualAddonSetupFile},async load(id,config){if(id===virtualStoriesFile)return generateImportFnScriptCode(options);if(id===virtualAddonSetupFile)return generateAddonSetupCode();if(id===virtualFileId)return generateModernIframeScriptCode(options,projectRoot);if(id===iframeId)return actualFS.readFileSync(__require.resolve("@storybook/builder-vite/input/iframe.html"),"utf-8")},async transformIndexHtml(html,ctx){if(ctx.path==="/iframe.html")return transformIframeHtml(html,options)}}}async function csfPlugin(config){let{presets}=config,docsOptions=(await presets.apply("addons",[])).find(a=>[a,a.name].includes("@storybook/addon-docs"))?.options??{};return vite(docsOptions?.csfPluginOptions)}var escapeKeys=key=>key.replace(/[-[\]{}()*+?.,\\^$|#\s]/g,"\\$&"),defaultImportRegExp="import ([^*{}]+) from",replacementMap=new Map([["import ","const "],["import{","const {"],["* as ",""],[" as ",": "],[" from "," = "],["}from","} ="]]);async function externalGlobalsPlugin(externals){await init;let{mergeAlias}=await import('vite');return {name:"storybook:external-globals-plugin",enforce:"post",async config(config,{command}){if(command!=="serve")return;let newAlias=mergeAlias([],config.resolve?.alias),cachePath=findCacheDirectory({name:"sb-vite-plugin-externals",create:!0});return await Promise.all(Object.keys(externals).map(async externalKey=>{let externalCachePath=join$1(cachePath,`${externalKey}.js`);newAlias.push({find:new RegExp(`^${externalKey}$`),replacement:externalCachePath}),await ensureFile(externalCachePath),await writeFile(externalCachePath,`module.exports = ${externals[externalKey]};`);})),{resolve:{alias:newAlias}}},async transform(code,id){let globalsList=Object.keys(externals);if(globalsList.every(glob2=>!code.includes(glob2)))return;let[imports]=parse$1(code),src=new MagicString(code);return imports.forEach(({n:path7,ss:startPosition,se:endPosition})=>{let packageName=path7;if(packageName&&globalsList.includes(packageName)){let importStatement=src.slice(startPosition,endPosition),transformedImport=rewriteImport(importStatement,externals,packageName);src.update(startPosition,endPosition,transformedImport);}}),{code:src.toString(),map:src.generateMap({source:id,hires:!0})}}}}function getDefaultImportReplacement(match2){let matched=match2.match(defaultImportRegExp);return matched&&`const {default: ${matched[1]}} =`}function getSearchRegExp(packageName){let staticKeys=[...replacementMap.keys()].map(escapeKeys),packageNameLiteral=`.${packageName}.`,dynamicImportExpression=`await import\\(.${packageName}.\\)`,lookup=[defaultImportRegExp,...staticKeys,packageNameLiteral,dynamicImportExpression];return new RegExp(`(${lookup.join("|")})`,"g")}function rewriteImport(importStatement,globs,packageName){let search=getSearchRegExp(packageName);return importStatement.replace(search,match2=>replacementMap.get(match2)??getDefaultImportReplacement(match2)??globs[packageName])}function stripQueryParams(filePath){return filePath.split("?")[0]}function isUserCode(moduleName){return !!(moduleName&&!moduleName.startsWith("vite/")&&!moduleName.startsWith("\0")&&!moduleName.startsWith("\0")&&moduleName!=="react/jsx-runtime"&&!moduleName.match(/node_modules\//))}function pluginWebpackStats({workingDir}){function normalize2(filename){if(filename.startsWith("/virtual:"))return filename;{let relativePath=path2__default.relative(workingDir,stripQueryParams(filename));return `./${slash(relativePath)}`}}function createReasons(importers){return (importers||[]).map(i=>({moduleName:normalize2(i)}))}function createStatsMapModule(filename,importers){return {id:filename,name:filename,reasons:createReasons(importers)}}let statsMap=new Map;return {name:"storybook:rollup-plugin-webpack-stats",enforce:"post",moduleParsed:function(mod){isUserCode(mod.id)&&mod.importedIds.concat(mod.dynamicallyImportedIds).filter(name=>isUserCode(name)).forEach(depIdUnsafe=>{let depId=normalize2(depIdUnsafe);if(statsMap.has(depId)){let m=statsMap.get(depId);m&&(m.reasons=(m.reasons??[]).concat(createReasons([mod.id])).filter(r=>r.moduleName!==depId),statsMap.set(depId,m));}else statsMap.set(depId,createStatsMapModule(depId,[mod.id]));});},storybookGetStats(){let stats={modules:Array.from(statsMap.values())};return {...stats,toJson:()=>stats}}}}var configEnvServe={mode:"development",command:"serve",ssrBuild:!1},configEnvBuild={mode:"production",command:"build",ssrBuild:!1};async function commonConfig(options,_type){let configEnv=_type==="development"?configEnvServe:configEnvBuild,{loadConfigFromFile,mergeConfig}=await import('vite'),{viteConfigPath}=await getBuilderOptions(options),projectRoot=path2.resolve(options.configDir,".."),{config:{build:buildProperty=void 0,...userConfig}={}}=await loadConfigFromFile(configEnv,viteConfigPath,projectRoot)??{},sbConfig={configFile:!1,cacheDir:resolvePathInStorybookCache("sb-vite",options.cacheKey),root:projectRoot,base:"./",plugins:await pluginConfig(options),resolve:{conditions:["storybook","stories","test"],preserveSymlinks:isPreservingSymlinks(),alias:{assert:__require.resolve("browser-assert")}},envPrefix:userConfig.envPrefix?["STORYBOOK_"]:["VITE_","STORYBOOK_"],build:{target:buildProperty?.target}};return mergeConfig(userConfig,sbConfig)}async function pluginConfig(options){let frameworkName=await getFrameworkName(options),build3=await options.presets.apply("build"),externals=globalsNameReferenceMap;build3?.test?.disableBlocks&&(externals["@storybook/blocks"]="__STORYBOOK_BLOCKS_EMPTY_MODULE__");let plugins=[codeGeneratorPlugin(options),await csfPlugin(options),await injectExportOrderPlugin(),await stripStoryHMRBoundary(),{name:"storybook:allow-storybook-dir",enforce:"post",config(config){config?.server?.fs?.allow&&config.server.fs.allow.push(".storybook");}},await externalGlobalsPlugin(externals),pluginWebpackStats({workingDir:process.cwd()})];if(frameworkName==="@storybook/glimmerx-vite"){let plugin=__require("vite-plugin-glimmerx/index.cjs");plugins.push(plugin.default());}return plugins}var INCLUDE_CANDIDATES=["@base2/pretty-print-object","@emotion/core","@emotion/is-prop-valid","@emotion/styled","@storybook/react > acorn-jsx","@storybook/react","@storybook/svelte","@storybook/vue3","acorn-jsx","acorn-walk","acorn","airbnb-js-shims","ansi-to-html","axe-core","color-convert","deep-object-diff","doctrine","emotion-theming","escodegen","estraverse","fast-deep-equal","html-tags","isobject","loader-utils","lodash/camelCase.js","lodash/camelCase","lodash/cloneDeep.js","lodash/cloneDeep","lodash/countBy.js","lodash/countBy","lodash/debounce.js","lodash/debounce","lodash/isEqual.js","lodash/isEqual","lodash/isFunction.js","lodash/isFunction","lodash/isPlainObject.js","lodash/isPlainObject","lodash/isString.js","lodash/isString","lodash/kebabCase.js","lodash/kebabCase","lodash/mapKeys.js","lodash/mapKeys","lodash/mapValues.js","lodash/mapValues","lodash/merge.js","lodash/merge","lodash/mergeWith.js","lodash/mergeWith","lodash/pick.js","lodash/pick","lodash/pickBy.js","lodash/pickBy","lodash/startCase.js","lodash/startCase","lodash/throttle.js","lodash/throttle","lodash/uniq.js","lodash/uniq","lodash/upperFirst.js","lodash/upperFirst","memoizerific","overlayscrollbars","polished","prettier/parser-babel","prettier/parser-flow","prettier/parser-typescript","prop-types","qs","react-dom","react-dom/client","react-fast-compare","react-is","react-textarea-autosize","react","react/jsx-runtime","refractor/core","refractor/lang/bash.js","refractor/lang/css.js","refractor/lang/graphql.js","refractor/lang/js-extras.js","refractor/lang/json.js","refractor/lang/jsx.js","refractor/lang/markdown.js","refractor/lang/markup.js","refractor/lang/tsx.js","refractor/lang/typescript.js","refractor/lang/yaml.js","regenerator-runtime/runtime.js","slash","store2","synchronous-promise","telejson","ts-dedent","unfetch","util-deprecate","vue","warning"],asyncFilter=async(arr,predicate)=>Promise.all(arr.map(predicate)).then(results=>arr.filter((_v,index)=>results[index]));async function getOptimizeDeps(config,options){let extraOptimizeDeps=await options.presets.apply("optimizeViteDeps",[]),{root=process.cwd()}=config,{normalizePath,resolveConfig}=await import('vite'),stories=(await listStories(options)).map(storyPath=>normalizePath(path2.relative(root,storyPath))),resolve3=(await resolveConfig(config,"serve","development")).createResolver({asSrc:!1}),include=await asyncFilter(Array.from(new Set([...INCLUDE_CANDIDATES,...extraOptimizeDeps])),async id=>!!await resolve3(id));return {...config.optimizeDeps,entries:stories,include:[...include,...config.optimizeDeps?.include||[]]}}var allowedEnvVariables=["STORYBOOK","BASE_URL","MODE","DEV","PROD","SSR"];function stringifyProcessEnvs(raw,envPrefix){let updatedRaw={},envs=Object.entries(raw).reduce((acc,[key,value])=>((allowedEnvVariables.includes(key)||Array.isArray(envPrefix)&&envPrefix.find(prefix=>key.startsWith(prefix))||typeof envPrefix=="string"&&key.startsWith(envPrefix))&&(acc[`import.meta.env.${key}`]=JSON.stringify(value),updatedRaw[key]=value),acc),{});return envs["import.meta.env"]=JSON.stringify(stringifyEnvs(updatedRaw)),envs}async function sanitizeEnvVars(options,config){let{presets}=options,envsRaw=await presets.apply("env"),{define}=config;if(Object.keys(envsRaw).length){let envs=stringifyProcessEnvs(envsRaw,config.envPrefix);define={...define,...envs};}return {...config,define}}function getAssetsInclude(config,newPath){let{assetsInclude}=config;return assetsInclude?Array.isArray(assetsInclude)?[...assetsInclude,...newPath]:[assetsInclude,...newPath]:newPath}async function createViteServer(options,devServer){let{presets}=options,commonCfg=await commonConfig(options,"development"),config={...commonCfg,assetsInclude:getAssetsInclude(commonCfg,["/sb-preview/**"]),server:{middlewareMode:!0,hmr:{port:options.port,server:devServer},fs:{strict:!0}},appType:"custom",optimizeDeps:await getOptimizeDeps(commonCfg,options)},finalConfig=await presets.apply("viteFinal",config,options),{createServer}=await import('vite');return createServer(await sanitizeEnvVars(options,finalConfig))}function checkName(plugin,names){return plugin!==null&&typeof plugin=="object"&&"name"in plugin&&names.includes(plugin.name)}async function hasVitePlugins(plugins,names){let resolvedPlugins=await Promise.all(plugins);for(let plugin of resolvedPlugins)if(Array.isArray(plugin)&&await hasVitePlugins(plugin,names)||checkName(plugin,names))return !0;return !1}var withoutVitePlugins=async(plugins=[],namesToRemove)=>{let result=[],resolvedPlugins=await Promise.all(plugins);for(let plugin of resolvedPlugins)Array.isArray(plugin)&&result.push(await withoutVitePlugins(plugin,namesToRemove)),plugin&&"name"in plugin&&!namesToRemove.includes(plugin.name)&&result.push(plugin);return result};function findPlugin(config,name){return config.plugins?.find(p=>p&&"name"in p&&p.name===name)}async function build(options){let{build:viteBuild,mergeConfig}=await import('vite'),{presets}=options,config=await commonConfig(options,"build");config.build=mergeConfig(config,{build:{outDir:options.outputDir,emptyOutDir:!1,rollupOptions:{external:["./sb-preview/runtime.js",/\.\/sb-common-assets\/.*\.woff2/]},...options.test?{reportCompressedSize:!1,sourcemap:!options.build?.test?.disableSourcemaps,target:"esnext",treeshake:!options.build?.test?.disableTreeShaking}:{}}}).build;let finalConfig=await presets.apply("viteFinal",config,options),turbosnapPluginName="rollup-plugin-turbosnap";return finalConfig.plugins&&await hasVitePlugins(finalConfig.plugins,[turbosnapPluginName])&&(logger.warn(dedent`Found '${turbosnapPluginName}' which is now included by default in Storybook 8.
      Removing from your plugins list. Ensure you pass \`--stats-json\` to generate stats.

      For more information, see https://github.com/storybookjs/storybook/blob/next/MIGRATION.md#turbosnap-vite-plugin-is-no-longer-needed`),finalConfig.plugins=await withoutVitePlugins(finalConfig.plugins,[turbosnapPluginName])),await viteBuild(await sanitizeEnvVars(options,finalConfig)),findPlugin(finalConfig,"storybook:rollup-plugin-webpack-stats")?.storybookGetStats()}function iframeMiddleware(options,server2){return async(req,res,next)=>{if(!req.url.match(/^\/iframe\.html($|\?)/)){next();return}if(req.query["html-proxy"]!==void 0){next();return}let indexHtml=await fs2.readFile(__require.resolve("@storybook/builder-vite/input/iframe.html"),"utf-8"),generated=await transformIframeHtml(indexHtml,options),transformed=await server2.transformIndexHtml("/iframe.html",generated);res.setHeader("Content-Type","text/html"),res.status(200).send(transformed);}}var server;async function bail(){return server?.close()}var start=async({startTime,options,router,server:devServer})=>{server=await createViteServer(options,devServer);let previewDirOrigin=join(corePath,"dist/preview");return router.use("/sb-preview",express.static(previewDirOrigin,{immutable:!0,maxAge:"5m"})),router.use(iframeMiddleware(options,server)),router.use(server.middlewares),{bail,stats:{toJson:()=>{throw new NoStatsForViteDevError}},totalTime:process.hrtime(startTime)}},build2=async({options})=>{let viteCompilation=build(options),previewDirOrigin=join(corePath,"dist/preview"),previewDirTarget=join(options.outputDir||"","sb-preview"),previewFiles=fs2.copy(previewDirOrigin,previewDirTarget,{filter:src=>{let{ext:ext2}=parse(src);return ext2?ext2===".js":!0}}),[out]=await Promise.all([viteCompilation,previewFiles]);return out};

export { bail, build2 as build, hasVitePlugins, start, withoutVitePlugins };
