Object.defineProperty(exports, '__esModule', { value: true });

const util = require('util');
const core = require('@sentry/core');
const utils = require('@sentry/utils');

const INTEGRATION_NAME = 'Console';

const consoleIntegration = (() => {
  return {
    name: INTEGRATION_NAME,
    setup(client) {
      utils.addConsoleInstrumentationHandler(({ args, level }) => {
        if (core.getClient() !== client) {
          return;
        }

        core.addBreadcrumb(
          {
            category: 'console',
            level: utils.severityLevelFromString(level),
            message: util.format.apply(undefined, args),
          },
          {
            input: [...args],
            level,
          },
        );
      });
    },
  };
}) ;

/** Console module integration */
// eslint-disable-next-line deprecation/deprecation
const Console = core.convertIntegrationFnToClass(INTEGRATION_NAME, consoleIntegration);

exports.Console = Console;
//# sourceMappingURL=console.js.map
