const core = require('@sentry/core');
const utils = require('@sentry/utils');
const ipc = require('../ipc.js');

const INTEGRATION_NAME = 'ScopeToMain';
const scopeToMain = () => {
    return {
        name: INTEGRATION_NAME,
        setup() {
            const scope = core.getCurrentScope();
            if (scope) {
                const ipc$1 = ipc.getIPC();
                scope.addScopeListener((updatedScope) => {
                    ipc$1.sendScope(JSON.stringify(utils.normalize(updatedScope.getScopeData(), 20, 2000)));
                    scope.clearBreadcrumbs();
                    scope.clearAttachments();
                });
            }
        },
    };
};
/**
 * Passes scope changes to the main process.
 */
// eslint-disable-next-line deprecation/deprecation
const ScopeToMain = core.convertIntegrationFnToClass(INTEGRATION_NAME, scopeToMain);

exports.ScopeToMain = ScopeToMain;
//# sourceMappingURL=scope-to-main.js.map
