import { BaseTransportOptions, Transport, TransportRequestExecutor } from '@sentry/types';
export interface ElectronNetTransportOptions extends BaseTransportOptions {
    /** Define custom headers */
    headers?: Record<string, string>;
}
/**
 * Creates a Transport that uses Electrons net module to send events to Sentry.
 */
export declare function makeElectronTransport(options: ElectronNetTransportOptions): Transport;
/**
 * Creates a RequestExecutor to be used with `createTransport`.
 */
export declare function createElectronNetRequestExecutor(url: string, baseHeaders: Record<string, string>): TransportRequestExecutor;
//# sourceMappingURL=electron-net.d.ts.map