const core = require('@sentry/core');
const utils = require('@sentry/utils');
const electron = require('electron');
const fs = require('fs');
const path = require('path');
const urlModule = require('url');
const electronNormalize = require('../electron-normalize.js');
const mode = require('../../common/mode.js');

var _documentCurrentScript = typeof document !== 'undefined' ? document.currentScript : null;
// After bundling with webpack, require.resolve can return number so we include that in the types
// to ensure we check for that!
function getPreloadPath() {
    try {
        return electronNormalize.rendererRequiresCrashReporterStart()
            ? require.resolve('../../preload/legacy.js')
            : require.resolve('../../preload/index.js');
    }
    catch (_) {
        try {
            // This could be ESM
            const currentDir = urlModule.fileURLToPath((typeof document === 'undefined' ? require('u' + 'rl').pathToFileURL(__filename).href : (_documentCurrentScript && _documentCurrentScript.src || new URL('main/integrations/preload-injection.js', document.baseURI).href)));
            // Use the CJS preload
            return path.resolve(currentDir, '..', '..', '..', '..', 'preload', 'index.js');
        }
        catch (_) {
            //
        }
    }
    return undefined;
}
const INTEGRATION_NAME = 'PreloadInjection';
const preloadInjection = () => {
    return {
        name: INTEGRATION_NAME,
        setup(client) {
            const options = client.getOptions();
            // If classic IPC mode is disabled, we shouldn't attempt to inject preload scripts
            // eslint-disable-next-line no-bitwise
            if ((options.ipcMode & mode.IPCMode.Classic) == 0) {
                return;
            }
            electron.app.once('ready', () => {
                const path$1 = getPreloadPath();
                if (path$1 && typeof path$1 === 'string' && path.isAbsolute(path$1) && fs.existsSync(path$1)) {
                    for (const sesh of options.getSessions()) {
                        // Fetch any existing preloads so we don't overwrite them
                        const existing = sesh.getPreloads();
                        sesh.setPreloads([path$1, ...existing]);
                    }
                }
                else {
                    utils.logger.log('The preload script could not be injected automatically. This is most likely caused by bundling of the main process');
                }
            });
        },
    };
};
/**
 * Injects the preload script into the provided sessions.
 *
 * Defaults to injecting into the defaultSession
 */
// eslint-disable-next-line deprecation/deprecation
const PreloadInjection = core.convertIntegrationFnToClass(INTEGRATION_NAME, preloadInjection);

exports.PreloadInjection = PreloadInjection;
//# sourceMappingURL=preload-injection.js.map
