const core = require('@sentry/core');
const sessions = require('../sessions.js');

const INTEGRATION_NAME = 'MainProcessSession';
const mainProcessSession = (options = {}) => {
    return {
        name: INTEGRATION_NAME,
        setup() {
            sessions.startSession(!!options.sendOnCreate);
            sessions.endSessionOnExit();
        },
    };
};
/** Tracks sessions as the main process lifetime. */
// eslint-disable-next-line deprecation/deprecation
const MainProcessSession = core.convertIntegrationFnToClass(INTEGRATION_NAME, mainProcessSession);

exports.MainProcessSession = MainProcessSession;
//# sourceMappingURL=main-process-session.js.map
